/****************************************************************************
 xtract.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved

 $Revision:   1.12  $
   $Author:   gmills  $
     $Date:   24 Feb 1992 16:56:18  $

 This file contains part of the API definition for clsXtract.  For
 the remainder see xlate.h.

 clsXtract inherits from clsObject.

****************************************************************************/
#ifndef XTRACT_INCLUDED
#define XTRACT_INCLUDED

#ifndef GO_INCLUDED
#include <go.h>
#endif
#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Messages											   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/****************************************************************************
 msgSave: takes P_OBJ_SAVE, returns STATUS
	Saves an extraction object.
 
 Writes the instance data for this object out to a file.
*/


/****************************************************************************
 msgRestore: takes P_OBJ_RESTORE, returns STATUS
	Restores an extraction object.

 Reads back in from a file the instance data for an extraction object and
 recreates the object.
*/

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Initialization Messages								   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/****************************************************************************
 msgAdded: takes OBJECT, returns STATUS
	Attachment to a scribble object
	
 The extraction object receives this message when it has been made
 an observer of a scribble object.  When it receives this message,
 the extractor queries the scribble for all strokes which have been
 added to the scribble up to this time.  Henceforth the scribble
 object will send msgScrAddedStroke to the extraction object every
 time a new stroke is added to the scribble.  Thus one way or another
 the extractor has access to all the strokes associated with the
 scribble.

 An extractor cannot be an observer of more than one scribble object at
 a time.
*/


/****************************************************************************
 msgRemoved: takes OBJECT, returns STATUS
	Detachment from a scribble object
	
 The extraction object receives this message when it is no longer an
 observer of the scribble object.
*/


/****************************************************************************
 msgXtractGetScribble: takes P_OBJECT, returns STATUS.
    Reads the id of the attached scribble object.

 This message is used to obtain the id of the scribble object that this
 extraction object is attached to.  It can be used by the client or by
 a subclass if it is interested in modifying and/or reading the scribble
 information directly.
*/
#define msgXtractGetScribble        MakeMsg(clsXtract, 1)


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Control Messages									   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/****************************************************************************
 msgScrAddedStroke: takes P_SCR_ADDED_STROKE, returns STATUS
	Add a stroke to the extraction object.

 This message is received by the extractor from the scribble object
 each time a new stroke is added to the scribble.
*/


/****************************************************************************
 msgScrRemovedStroke: takes P_SCR_REMOVED_STROKE, returns STATUS
	Remove a stroke from the extraction object.

 This message is received by the extractor from the scribble object
 each time an existing stroke is deleted from the scribble.
*/


/****************************************************************************
 msgXtractStrokesClear: takes NULL, returns STATUS
    Clears out all strokes previously sent to translation object by scribble

 Effectively restarts the translator as if it had just been attached to
 a fresh scribble.  
 
 As a side effect, the shape engine is released.  A new shape engine will
 be attached as soon as new strokes get added by the scribble.

 All the settings of the translator remain unchanged (e.g. hwxFlags,
 xlateCaseMetrics, xlateMetrics, etc).

 This message was formerly called msgXtractContextClear.  The new name
 more accurately reflects its functionality.
*/
#define msgXtractStrokesClear			MakeMsg(clsXtract, 3)


/****************************************************************************
 msgScrCompleted: takes NULL, returns STATUS
	Notification that no more strokes will be added to scribble.

 This message is sent by the scribble object to the extraction object
 when the scribble has determined that no more strokes will be added.
 When it receives this message, the extractor will self-send the message
 msgXtractComplete (see below) to kick off the final stages of translation.
*/


/****************************************************************************
 msgXtractComplete: takes NULL, returns STATUS
	Hook for subclasses to complete the translation.

 The extraction object self-sends this message when it receives the
 message msgScrCompleted.  This message will be processed by the
 appropriate subclass of clsXtract which will complete the translation.

 Note that in certain instances (such as multiple line text pads),
 the translation object may have already translated a subset of the
 existing strokes as they were entered.  This message tells the 
 translation object to finish up (complete) the translation and not wait
 for any further strokes.
*/
#define msgXtractComplete         MakeMsg(clsXtract, 0x81)


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Private Functions									   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*************************************************************************
 XlateGetUnknownCharacter: returns CHAR
	Reads the current unrecognized character code.

 The code to represent an unrecognized character is set via the
 Preferences.  This function reads the code that the extraction object
 is currently using.
*/

// NLS: API: YELLOW: XlateGetUnknownCharacter returns CHAR
CHAR EXPORTED XlateGetUnknownCharacter(void);

#endif
