/****************************************************************************
 xtext.h
 Copyright 1992, GO Corporation, All Rights Reserved

 Defines the API for clsXText

 $Revision:   1.8  $
   $Author:   gmills  $
     $Date:   24 Feb 1992 16:56:12  $

    clsXText inherits from clsXtract.

****************************************************************************/
#ifndef XTEXT_INCLUDED
#define XTEXT_INCLUDED

#ifndef GO_INCLUDED
#include <go.h>
#endif
#ifndef UID_INCLUDED
#include <uid.h>
#endif
#ifndef XLATE_INCLUDED
#include <xlate.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef struct XTEXT_WORD {     // xtTextWord data
    RECT32      bounds;         // bounding box
    CHAR str[1];                // text string, 0 terminated
} XTEXT_WORD, *P_XTEXT_WORD;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							Messages									   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNewDefaults:               takes P_XLATE_NEW, returns STATUS.
    Fills in default values to XLATE_NEW structure.

 All fields are set to 0 except the following hwxFlags which are turned ON:
	alphaNumericEnable
	punctuationEnable
	verticalEnable
	caseEnable

 In most cases
	smartCaseDisable
 is also on (i.e. there will be NO "smart case" postprocessing to
 correct the capitalization of letters).  The exception is that if
 the writer is an all caps writer (as determined by the global
 preference setting) then the default setting is OFF (i.e. there WILL
 be smart case postprocessing).                                                      
*/

/****************************************************************************
 msgNew:     	               takes P_XLATE_NEW, returns STATUS.
    Creates a new Text translation object.

*/

/****************************************************************************
 msgXTextGetXList:          takes P_XLATE_DATA, returns STATUS
    Convert data to XList.

*/
#define msgXTextGetXList         MakeMsg(clsXText, 0x01)


/****************************************************************************
 msgXTextWordList:          takes P_WORD_LIST, returns STATUS
    subclass opportunity to alter word list/disambig
    Called during the disambiguation extraction pass.

*/
#define msgXTextWordList         MakeMsg(clsXText, 0x02)


/****************************************************************************
 msgXTextComplete:          takes P_XLIST, returns STATUS
    Hook for subclasses to postprocess translation results from clsXText

 clsXtext responds to msgXlateComplete by completing the translation and
 then self-sending this message (msgXTextComplete) to allow its subclasses
 to post-process the translation results.
*/
#define msgXTextComplete         MakeMsg(clsXText, 0x81)


/****************************************************************************
 msgXTextNewLine:           takes P_UNKNOWN, returns STATUS
    Indicates the start of a new line to subclasses.

*/
#define msgXTextNewLine          MakeMsg(clsXText, 0x82)


/****************************************************************************
 msgXTextModLine:           takes P_UNKNOWN, returns STATUS
    Indicates a modification of a line to subclasses.

*/
#define msgXTextModLine          MakeMsg(clsXText, 0x83)

#endif // #ifndef XTEXT_INCLUDED
