/****************************************************************************
 File: uuid.h

 (C) Copyright 1992, GO Corporation, All Rights Reserved.

 $Revision:   1.17  $
   $Author:   twiegman  $
     $Date:   24 Feb 1992 17:06:20  $

 This file contains the API for UUID routines.
 The functions described in this file are contained in PENPOINT.LIB.

 This file contains macros for creating and testing Nil and Invalid UUIDs,
 to compare two UUIDs for equality, and to create a well known UUID
 and a function to create dynamic uuids.

 UUID is an acronym for Universal Unique ID.
****************************************************************************/
#ifndef UUID_INCLUDED
#define UUID_INCLUDED

/* Include files */

#ifndef GO_INCLUDED
#include <go.h>
#endif


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   				Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/**** Macros ****/

/* For setting and testing for a Nil UUID */
#define MakeNilUUID(uuid)		((uuid).machine = (uuid).id = 0L)
#define NilUUID(uuid)	  		(((uuid).machine == 0L) && ((uuid).id == 0L))

/* For setting and testing for an invalid UUID */
#define MakeInvalidUUID(uuid)	((uuid).id = (uuid).machine = maxU32)
#define InvalidUUID(uuid)		((uuid).id == maxU32 && \
								 (uuid).machine == maxU32)

/* To compare two UUIDs for equality */
#define SameUUIDs(a,b)			(((a).machine == (b).machine) && \
								 ((a).id == (b).id))

/* To set the fields of a well known uuid */
#define MakeWknUUID(uuid,tag,i)	\
	((uuid).machine = (tag), (uuid).id = (U32)(i))


/**** Typedefs ****/

typedef struct UUID {
	U32					id;				// Unique counting value
	U32					machine;		// Unique machine identifier
} UUID, *P_UUID;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							Public Functions							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 MakeDynUUID	returns nothing
    Creates a dynamic UUID.
*/
void EXPORTED MakeDynUUID (
	P_UUID				pUUID
);


#endif // UUID_INCLUDED

