/****************************************************************************
 File: tv_tags.h

 Copyright 1992, GO Corporation, All Rights Reserved.

 $Revision:   1.205  $
   $Author:   nkim  $
     $Date:   04 Feb 1992 18:59:48  $

 This file contains clsTextView's well-known TAGs and associated constants.

 The usage of well-known TAGS by clsTextView falls into these categories:
	1) Quick Help identifiers
	2) Option Sheet card and item (i.e., window) tags
	3) Option Sheet card labels
	4) User note identifiers

 Most of clsTextView's Option Sheet components use the same tag for both
 the window tag and the quick help tag.  This causes category 1 above to be
 almost identical to category 2.

 All of the Quick Help resources for clsTextView can be enumerated by
 finding all resources whose .wkn.admin == resForQuickHelp (see qHelp.h)
 and Cls(.wkn.id) == Cls(clsTextView).

****************************************************************************/
#ifndef TV_TAGS_INCLUDED
#define TV_TAGS_INCLUDED

#													ifndef GO_INCLUDED
#include <go.h>
#													endif
#													ifndef UID_INCLUDED
#include <uid.h>
#													endif

// Allocated clsTextView TAGs: 1-54, 94-95

/****  Tags for Option Sheet ****/
typedef enum TV_CARD_INDEX {	// TVMakeCardTag(TV_CARD_INDEX) => tag
	tvCardChar = 0,
	tvCardPara,
	tvCardTabs,
	tvCardView,
	tvCardLength				// Pseudo-card index which gives # cards
} TV_CARD_INDEX;

/*
 Labels for Option sheet & cards.
 All Card Label strings are in a single resource: a string array with
 ResId = tagTVOptResAdmin and indexed via TV_CARD_INDEX.
 */
#define tagTVOptResAdmin	MakeTag(clsTextView, 95)

typedef enum TV_CHAR_OPTION {	// TVMakeCharTag(TV_CHAR_OPTION) => tag
	tvCharOptBold = 0,
	tvCharOptFont,
	tvCharOptItalic,
	tvCharOptSize,
	tvCharOptSizeOther,
	tvCharOptSizeOtherVal,
	tvCharOptSmallCaps,
	tvCharOptStrike,
	tvCharOptStyle,
	tvCharOptUnderlineNormal,
	tvCharOptUnderlineHeavy,
	tvCharOptLength				// Pseudo item which gives # char options
} TV_CHAR_OPTION;

typedef enum TV_PARA_OPTION {	// TVMakeParaTag(TV_PARA_OPTION) => tag
	tvParaOptAfterSpacing = 0,
	tvParaOptBeforeSpacing,
	tvParaOptFirstLineOffset,
	tvParaOptInterLineHeight,
	tvParaOptJustification,
	tvParaOptLeftMargin,
	tvParaOptLineHeight,
	tvParaOptRightMargin,
	tvParaOptLength				// Pseudo item which gives # para options
} TV_PARA_OPTION;

typedef enum TV_VIEW_OPTION {	// TVMakeViewTag(TV_VIEW_OPTION) => tag
	tvViewOptSpecial = 0,
	tvViewOptMagnification,
	tvViewOptLength				// Pseudo item which gives # show options
} TV_VIEW_OPTION;

/*
 The following macros combine all of the sub-ranges into a universal name
 space, suitable for both win.tag and gwin.helpId.  Note that the labels
 of options are not tagged, only the value fields; if the labels must be
 tagged, use a new administered range so that it does not conflict
 with these helpIds.
 */
			//   tv_glbl.c performs runtime consistency checks.
#define TVMakeTag(tag)		MakeTag(clsTextView, (tag))
#define tagTextView			TVMakeTag(1)
#define tagTextViewOption	TVMakeTag(2)
#define TVMakeCardTag(i)	TVMakeTag(3+i)
#define TVMakeCharOptTag(i)	TVMakeTag(10+i)	// min 7  => 3 spare Card
#define TVMakeParaOptTag(i)	TVMakeTag(30+i)	// min 21 => 9 spare Char
#define tagQHTabStop		TVMakeTag(42)	// min 38 => 4 spare Para
#define TVMakeViewOptTag(i)	TVMakeTag(45+i)	// min 43 => 2 spare Tabs
#define TVMakeXXXTag(i)		TVMakeTag(55+i)	// min 48 => 7 spare View


/****  Tags for Notes ****/
/*
 A Note is a string displayed to the user when a Text View encounters
 difficulties processing a user action.
 All of the Note strings are in a single resource: a string array with
 ResId = resForStdMsgDialog(clsTextView) and indexed via the following ids.
 */
#define tagTVNoteResAdmin	MakeTag(clsTextView, 94)
	// Allocated note ids - recycled: none; next: 12L

/* "text view note" abbreviates to "tvn". */
#define tvnHazardousSetting		1L		// margins may overlap
#define tvnInvalidFieldValue	2L
#define	tvnTranslateOutOfMem	3L
#define	tvnTabsOverlap			4L
#define	tvnReadOnlyChars		5L
#define	tvnReadOnlyAttrs		6L
#define	tvnNotAnIP				7L
#define	tvnNotAComponent		8L
#define	tvnApplyWithoutSeln		9L
#define tvnNegForUnsignedField	10L		// a negative number entered for an
										// unsigned field in an option sheet
#define tvnNewParasAdded		11L


#endif // TV_TAGS_INCLUDED
