/*
 *  string.h    String functions
 *
 *  Copyright (C) by WATCOM Systems Inc. 1988,1989,1990.  All rights reserved.
 */
#ifndef _STRING_H_INCLUDED

#ifndef _SIZE_T_DEFINED_
#define _SIZE_T_DEFINED_
typedef unsigned size_t;
#endif

#if defined(__SMALL__) || defined(__MEDIUM__) || defined(__386__)
 #define NULL   0
#else
 #define NULL   0L
#endif

#ifdef  __INLINE_FUNCTIONS__
 void   *memchr( const void *__s, int __c, size_t __n );
 int     memcmp( const void *__s1, const void *__s2, size_t __n );
 void   *memcpy( void *__s1, const void *__s2, size_t __n );
 void   *memmove( void *__s1, const void *__s2, size_t __n );
 void   *memset( void *__s, int __c, size_t __n );
 char   *strcat( char *__s1, const char *__s2 );
 char   *strchr( const char *__s, int __c );
 int     strcmp( const char *__s1, const char *__s2 );
 char   *strcpy( char *__s1, const char *__s2 );
 size_t  strlen( const char *__s );
 #define memchr(p,c,n)          _inline_memchr(p,c,n)
 #define memcmp(p1,p2,n)        _inline_memcmp(p1,p2,n)
 #define memcpy(p1,p2,n)        _inline_memcpy(p1,p2,n)
 #define memset(p,c,n)          _inline_memset(p,c,n)
 #define strcat(p1,p2)          _inline_strcat(p1,p2)
 #define strcmp(p1,p2)          _inline_strcmp(p1,p2)
 #define strcpy(p1,p2)          _inline_strcpy(p1,p2)
 #define strlen(p1)             _inline_strlen(p1)
 #define strchr(p1,p2)          _inline_strchr(p1,p2)
#endif  /* __INLINE_FUNCTIONS__ */

void    *memchr( const void *__s, int __c, size_t __n );
int      memcmp( const void *__s1, const void *__s2, size_t __n );
void    *memcpy( void *__s1, const void *__s2, size_t __n );
void    *memmove( void *__s1, const void *__s2, size_t __n );
void    *memset( void *__s, int __c, size_t __n );
char    *strcat( char *__s1, const char *__s2 );
char    *strchr( const char *__s, int __c );
int      strcmp( const char *__s1, const char *__s2 );
char    *strcpy( char *__s1, const char *__s2 );
size_t   strcspn( const char *__s1, const char *__s2 );
char    *strerror( int __errnum );
size_t   strlen( const char *__s );
char    *strncat( char *__s1, const char *__s2, size_t __n );
int      strncmp( const char *__s1, const char *__s2, size_t __n );
char    *strncpy( char *__s1, const char *__s2, size_t __n );
char    *strpbrk( const char *__s1, const char *__s2 );
char    *strrchr( const char *__s, int __c );
size_t   strspn( const char *__s1, const char *__s2 );
char    *strstr( const char *__s1, const char *__s2 );
char    *strtok( char *__s1, const char *__s2 );

/* WATCOM's Additional Functions (non-ANSI, non-POSIX) */

#if defined(_PP_SOURCE) || !defined(NO_EXT_KEYS)
void        *memccpy( void *__s1, const void *__s2, int __c, size_t __n );
int          memicmp( const void*__s1, const void *__s2, size_t __n );
int          strcmpi( const char *__s1, const char *__s2 );
char        *strdup( const char *__string );
int          stricmp( const char *__s1, const char *__s2 );
char        *strlwr( char *__string );
int          strnicmp( const char *__s1, const char *__s2, size_t __n );
char        *strnset( char *__string, int __c, size_t __len );
char        *strrev( char *__string );
char        *strset( char *__string, int __c );
char        *strupr( char *__string );
#endif  /* _PP_SOURCE || !NO_EXT_KEYS */

#define _STRING_H_INCLUDED
#endif
