/*
 *  stdlib.h    Standard Library functions
 *
 *  Copyright (C) by WATCOM Systems Inc. 1988,1989,1990.  All rights reserved.
 */
#ifndef _STDLIB_H_INCLUDED

#pragma pack(1);

#ifndef _SIZE_T_DEFINED_
 #define _SIZE_T_DEFINED_
 typedef unsigned size_t;
#endif

#ifndef _WCHAR_T_DEFINED_
 #define _WCHAR_T_DEFINED_
 typedef unsigned short wchar_t;
#endif

#if defined(__SMALL__) || defined(__MEDIUM__) || defined(__386__)
 #define NULL   0
#else
 #define NULL   0L
#endif

#define RAND_MAX        32767u
#define EXIT_SUCCESS    0
#define EXIT_FAILURE    1
#define MB_CUR_MAX      1

typedef struct  {
        int     quot;
        int     rem;
} div_t;

typedef struct  {
        long    quot;
        long    rem;
} ldiv_t;

#ifdef  __INLINE_FUNCTIONS__
 int      abs(int __j);
 div_t    div(int __numer,int __denom);
 long int labs(long int __j);
 #ifdef __386__
  ldiv_t  ldiv(long __numer,long __denom);
  #define ldiv(n,d) _inline_ldiv(n,d)
 #endif
 #define abs(x)     _inline_abs(x)
 #define div(x,y)   _inline_div(x,y)
 #define labs(x)    _inline_labs(x)
#endif

void             abort( void );
int              abs( int __j );
int              atexit( void ( *__func )( void ) );
double           atof( const char *__nptr );
int              atoi( const char *__nptr );
long int         atol( const char *__nptr );
void            *bsearch( const void *__key, const void *__base,
                    size_t __nmemb, size_t __size,
                    int ( *__compar )( const void *__pkey, const void *__pbase ) );
void            *calloc( size_t __n, size_t __size );
div_t            div( int __numer, int __denom );
void             exit( int __status );
void             free( void *__ptr );
char            *getenv( const char *__name );
long int         labs( long int __j );
ldiv_t           ldiv( long int __numer, long int __denom );
void            *malloc( size_t __size );
void             qsort( void *__base, size_t __nmemb, size_t __size,
                    int (*__compar)( const void *, const void * ) );
int              rand( void );
void            *realloc( void *__ptr, size_t __size );
void             srand( unsigned int __seed );
double           strtod( const char *__nptr, char **__endptr );
long int         strtol( const char *__nptr, char **__endptr, int __base );
unsigned long    strtoul( const char *__nptr, char **__endptr, int __base );
int              system( const char *__string );

#pragma aux     abort   aborts;
#pragma aux     exit    aborts;

#define atof(p)  strtod(p,(char **)NULL)

#if defined(_POSIX_SOURCE) || defined(_PP_SOURCE) || !defined(NO_EXT_KEYS)
#pragma aux      _exit   aborts;
void             _exit( int __status );
#endif

#if defined(_PP_SOURCE) || !defined(NO_EXT_KEYS)
#ifdef  __INLINE_FUNCTIONS__
 unsigned int _rotl( unsigned int __value, unsigned int __shift );
 unsigned int _rotr( unsigned int __value, unsigned int __shift );
 #ifdef __386__
  unsigned long _lrotl( unsigned long __value, unsigned int __shift );
  unsigned long _lrotr( unsigned long __value, unsigned int __shift );
  #define _lrotl(x,n) _inline__lrotl(x,n)
  #define _lrotr(x,n) _inline__lrotr(x,n)
 #endif
 #define _rotl(x,n) _inline__rotl(x,n)
 #define _rotr(x,n) _inline__rotr(x,n)
#endif
/*
 * The following sizes are the maximum sizes of buffers used by the _makepath()
 * and _splitpath() functions.  They include space for the '\0' terminator.
 */

#define _MAX_PATH       255     /*  maximum length of path name         */
#define _MAX_DRIVE      33      /*  maximum length of node name         */
#define _MAX_NODE       33      /*  maximum length of node name         */
#define _MAX_DIR        255     /*  maximum length of subdirectory      */
#define _MAX_FNAME      33      /*  maximum length of a file name       */
#define _MAX_EXT        33      /*  maximum length of a file extension  */

/* min and max macros */
#define max(a,b)   (((a) > (b)) ? (a) : (b))
#define min(a,b)   (((a) < (b)) ? (a) : (b))

char            *ecvt( double __val, int __ndig, int *__dec, int *__sign );
char            *fcvt( double __val, int __ndig, int *__dec, int *__sign );
char            *_fullpath( char *__buf, const char *__path, size_t __size );
char            *gcvt( double __val, int __ndig, char *__buf );
char            *itoa( int __value, char *__buf, int __radix );
unsigned long    _lrotl( unsigned long __value, unsigned int __shift );
unsigned long    _lrotr( unsigned long __value, unsigned int __shift );
char            *ltoa( long int __value, char *__buf, int __radix );
void             _makepath( char *__path, const char *__drive, const char *__dir,
                    const char *__fname, const char *__ext );
unsigned int     _rotl( unsigned int __value, unsigned int __shift );
unsigned int     _rotr( unsigned int __value, unsigned int __shift );
void             _splitpath( const char *__path, char *__drive,
                    char *__dir, char *__fname, char *__ext );
void             swab( char *__src, char *__dest, int __num );
char            *ultoa( unsigned long int __value, char *__buf, int __radix );
char            *utoa( unsigned int __value, char *__buf, int __radix );
#endif /* _PP_SOURCE || !NO_EXT_KEYS */

#define errno (*__get_errno_ptr())
extern volatile int         errno;      /*  ANSI error number               */

#pragma pack();

#define _STDLIB_H_INCLUDED
#endif
