/*
 *  stddef.h    Standard definitions
 *
 *  Copyright (C) by WATCOM Systems Inc. 1988,1992.  All rights reserved.
 */
#ifndef _STDDEF_H_INCLUDED

#ifndef _SIZE_T_DEFINED_
#define _SIZE_T_DEFINED_
typedef unsigned size_t;
#endif

#ifndef _WCHAR_T_DEFINED_
#define _WCHAR_T_DEFINED_
typedef unsigned short wchar_t;
#endif

#if defined(__SMALL__) || defined(__MEDIUM__) || defined(__386__)
 #define NULL   0
#else
 #define NULL   0L
#endif

#if defined(__HUGE__)
 typedef long   ptrdiff_t;
#else
 typedef int    ptrdiff_t;
#endif

#define offsetof(typ,id) (size_t)&(((typ*)0)->id)

#ifdef __WATCOMC__

/* define pragma for 'cdecl'  keyword to match PenPoint conventions */
/* define pragma for 'pascal' keyword to match PenPoint conventions */
#ifdef __386__
 #pragma aux pascal "^" parm routine []\
   value struct float struct caller [eax] modify [eax ecx edx gs];
 #pragma aux cdecl "_*" parm caller []\
   value struct float struct caller [eax] modify [eax ecx edx gs];
 #pragma aux fortran "^";
#endif

#endif

#define _STDDEF_H_INCLUDED
#endif
