/****************************************************************************
 File: servimgr.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.39  $
   $Author:   rfoster  $
     $Date:   22 Feb 1992 15:35:04  $

 This file contains the API definition for clsServiceInstallMgr.
 clsServiceInstallMgr inherits from clsCodeInstallMgr.
 Manages installation and deinstallation of services.

 There is a single instance of clsServiceInstallMgr in the system; the 
 well-known uid theInstalledServices.

 theInstalledServices performs installation and deinstallation of services,
 allows you to enumerate all of the services that are currently installed, 
 and find out their classes.

 See service.h for the messages that a service implementor needs.
 See servmgr.h for the messages that a service client uses to find and 
 open a particular service.

 Services provide non-application functionality under PenPoint; typically
 some form of background server or device driver.  Examples of services
 include: device drivers, inbox/outbox transfer agents such as fax and 
 e-mail, network protocol stacks, and databases.

 A service is a directory, usually located under \penpoint\service on a
 given filesystem volume.  The name of the directory is the name of the 
 service.  Within this directory are one or more .dlls that make up the
 service.

 If a service includes more than one .dll there must also be a .dlc file
 which lists all the .dlls.  The name of the .dlc file (or the name of
 the .dll file if there is only one .dll) must be the same as the name of
 the service.  If a service is called MAIL, for example, its .dlc file must 
 be named MAIL.DLC.  You can use the STAMP.EXE utility to give a 
 service an extended name.  Be sure to stamp the .dlc file as well.

 A service can contain an init.dll.  This .dll will be loaded, run, and
 unloaded during service loading.  This can be used to set up or modify
 the service's resource file programmatically.  A handle to the service's
 resource file is available to init.dll via msgSvcGetClassMetrics.

 When a service is installed, a service directory is created in the RAM
 filesystem.  All of the state for that service lives in this directory.

 A service can have an optional MISC directory.  This is very similar to an 
 application's MISC directory.  MISC is used to store static data files that
 are common to all service instances.  The MISC directory will be copied 
 into the service directory when the service is installed.  You can get to 
 the MISC directory from a service instance by getting class metrics, then 
 specifying a path of "MISC" relative to the service's directory.

 A service can have a resource file, called service.res.  This is similar to
 an application's app.res file.  The resource file is automatically copied
 to the service directory in RAM when the service is installed, and a
 resource file handle is opened on it and stored in the service class 
 metrics.  This resource file should contain the service's UI components
 and quick-help resources.  Each service's resource file handle is added
 to the well-known resList theServiceResList.  Quick-help searches 
 theServiceResList as part of its normal operation.  Note that
 theServiceResList is not callable; you must ObjectSend to it.

 There is an optional INST directory in a service directory, which contains 
 saved service instance state nodes.  Pre-configured service instances will 
 be created from the nodes in this directory when the service is loaded 
 (see service.h for details).

 There can also be a service.ini and app.ini file in the service directory.
 These specify any additional services and applications that should be 
 installed when this service is installed.  These services and applications
 are deinstalled when the service is deinstalled.  If one of these services or
 applications is already installed it is reference counted, not installed
 again. 

 A service is installed by sending msgIMInstall to theInstalledServices.
 Services are installed under user control from the Services card of the
 Settings Notebook, or via the pop-up quick installer (see qckinstl.h).
 \\boot\penpoint\boot\service.ini specifies services that are automatically 
 loaded when the system cold-boots.

 Each installed service has a service directory in the RAM filesystem,
 under \penpoint\sys\service.  For example, service MAIL would have
 \penpoint\sys\service\mail.  The instance state nodes for the service are
 kept in a directory called INST, under this directory.  If the service has 
 preconfigured instances then they are copied to the INST directory when the
 service is first installed.

 Each installed service is represented by a handle, in a fashion similar
 to other install managers (see instlmgr.h).  This handle is a directory 
 handle onto the service's directory in the RAM filesystem.

 NOTE: THE MESSAGES IN THIS CLASS ARE SENT TO THE MANAGER, NOT TO 
 THE HANDLES.

 A service can be deinstalled.  Deinstallation removes all traces of a
 service and decrements the reference count for any dependent services
 or applications.  All service instances are removed from their service
 managers and freed when a service is deinstalled.

 Deinstallation only occurs if the main service and all dependent applications
 and services agree to deinstall.  A service or application can veto the
 deinstallation if it chooses.  The default behavior for services is to veto
 if any service instance is open (in use).

 The following superclass messages are not understood by clsServiceInstallMgr:
	-:  msgIMGetCurrent
	-:  msgIMSetCurrent
	-:  msgIMSetName
	-:  msgIMDup

 The following notification messages are not sent by clsServiceInstallMgr:
	-:  msgIMNameChanged
	-:  msgIMCurrentChanged

 NOTE: Each service must contain one and only one service class.  Don't
 try and define more than one service class in a single service.

 See Also
	instlmgr.h
****************************************************************************/
#ifndef SERVIMGR_INCLUDED
#define SERVIMGR_INCLUDED

#ifndef SERVICE_INCLUDED
#include <service.h>
#endif

#ifndef CODEMGR_INCLUDED
#include <codemgr.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****  Well-known filenames  ****/
/*
 * These are the files created by clsServiceInstallMgr in a service's
 * directory.
 */
#define svcResFileName			"service.res"


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * 				  				  	Messages  		  					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNew						takes P_SIM_NEW, returns STATUS
	category: class message
	Creates a new service installation manager.

 There is only one instance of this class, theInstalledServices, in the 
 system.  Clients should never send msgNew.
*/

typedef struct SIM_NEW {
	installMgrNewFields
} SIM_NEW, *P_SIM_NEW;


/****************************************************************************
 msgSIMGetMetrics		   		takes P_SIM_GET_METRICS, returns STATUS
	Gets the specified service class's metrics.

 See service.h for SVC_CLASS_METRICS.
*/
#define msgSIMGetMetrics				MakeMsg(clsServiceInstallMgr, 1)

typedef struct SIM_GET_METRICS {
	IM_HANDLE			handle;		// Handle of service class to get metrics
									// on.
	SVC_CLASS_METRICS	metrics;	// Out: metrics.
} SIM_GET_METRICS, *P_SIM_GET_METRICS;


#endif	// SERVIMGR_INCLUDED


