/****************************************************************************
 File: selchmgr.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.40  $
   $Author:   sbartlet  $
     $Date:   04 Mar 1992 13:55:32  $

 This file contains the API for clsSelChoiceMgr.
 
 clsSelChoiceMgr inherits from clsManager.
 Provides a choice manager that defines a protocol for managing the selection.
 Although clients may subclass clsSelChoiceMgr and add to or modify its
 behavior, there should be little reason to do so.  clsSelChoiceMgr
 itself implements all of the standard UI for selectable choices.

 Notes:

 The selection choice manager works in a similar manner to the regular
 choice manager except it causes selection feedback to be displayed on the
 controls it manages. It also tells a client when to acquire the selection
 by sending msgSelChoiceMgrAcquireSel to the client. This message is sent
 every time one of the controls it manages turns on. selchmgr also sends
 msgSelChoiceMgrNullSel when someone programmatically turns off the selected 
 control or sends the selchmgr msgChoiceMgrSetOnButton with an argument of 
 objNull. The client should set the selection to null when it recieves this
 message.

 Note that msgNewDefaults to clsChoice results in a prototypical new struct
 whose values describe a button of contact style bsContactLockOn.  This is
 correct for choices that always have one button on, but this is typically
 not what you'd want for selectable choices--the user should be able to
 deselect a selected button by tapping on it (so the choice then has no
 buttons on).  To acheive this effect, do the equivalent of the following:
//{
	ObjCallWarn(msgNewDefaults, clsChoice, &choiceNew);
	choiceNew.tkTable.pButtonNew->button.style.contact = bsContactToggle;
	choiceNew.tkTable.manager = <uid of a selChoiceMgr>;
	ObjCallRet(msgNew, clsChoice, &choiceNew, s);
//}
 See the documentation for msgTkTableChildDefaults in choice.h.

 When a client receives msgSelYield from the selection manager it should
 send msgSelChoiceMgrNullCurrent to the selchmgr. This will cause it to turn 
 off its currently chosen control and set its current choice to null. Here's
 how a client would typically respond to the relevant messages.
//{
	msgSelChoiceMgrAcquireSel:
		<remember what kind of selection self will own
			by writing pArgs->id into self's instance data>
		ObjCallRet(msgSelSelect, self, pNull, s);
		<don't call ancestor>

	msgSelChoiceMgrNullSel:
		// The following will result in self receiving msgSelYield.
		ObjCallRet(msgSelSetOwner, theSelectionManager, objNull, s);
		<don't call ancestor>

	msgSelYield:
		// Ignore if self isn't the primary selection owner.
		if ((BOOLEAN) (U32) pArgs == false)
			return ObjectCallAncestorCtx(ctx);
		<get the choice by referencing the id value in self's instance data>
		<get the manager of the choice via msgTkTableGetManager>
		ObjCallRet(msgSelChoiceMgrNullCurrent, <manager>, pNull, s);
		<clear the id field in self's instance data>
		<don't call ancestor>

	msgSelOptionTagOK:
		<determine whether the kind of option sheet indicated by pArgs
			(a TAG value) could be applied to the selection, and return
			stsOK if so, stsFailed if not>
		<don't call ancestor>

	msgSelOptions:
		<bring up an option sheet for the selection>
		<don't call ancestor>
//}
 See sel.h for additional selection messages and their documentation.
****************************************************************************/

#ifndef SELCHMGR_INCLUDED
#define SELCHMGR_INCLUDED

												#ifndef CHMGR_INCLUDED
#include <chmgr.h>
												#endif
												#ifndef XFER_INCLUDED
#include <xfer.h>
												#endif
												#ifndef WIN_INCLUDED
#include <win.h>
												#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *						Common #defines and typedefs					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef OBJECT	SEL_CHOICE_MGR;

/****************************************************************************
 msgNew		takes P_SEL_CHOICE_MGR_NEW, returns STATUS
	category: class message
	Creates a selChoiceMgr object.

 The fields you commonly set are:
	pArgs->selChoiceMgr.client:	An object to manage the selection protocol.
								(Typically the app uid.)
	pArgs->selChoiceMgr.id:		An id to distinguish among >1 selectable
								instances of clsChoice within
								the client's domain.
*/

typedef struct SEL_CHOICE_MGR_NEW_ONLY {
	OBJECT	client;		// Object to send acquire/null messages to
	U32		id;			// Id tag sent with acquire/null messages
	U32		spare;
} SEL_CHOICE_MGR_NEW_ONLY, *P_SEL_CHOICE_MGR_NEW_ONLY;

#define	selChoiceMgrNewFields	\
	choiceMgrNewFields			\
	SEL_CHOICE_MGR_NEW_ONLY	   	selChoiceMgr;

typedef struct SEL_CHOICE_MGR_NEW {
	selChoiceMgrNewFields
} SEL_CHOICE_MGR_NEW, *P_SEL_CHOICE_MGR_NEW;

typedef struct SEL_CHOICE_MGR_INFO {
	SEL_CHOICE_MGR			selChoiceMgr;	// Sender
	U32						id;				// Client-specified id tag
	WIN						button;			// Current on button
} SEL_CHOICE_MGR_INFO, *P_SEL_CHOICE_MGR_INFO;


/****************************************************************************
 msgNewDefaults				takes P_SEL_CHOICE_MGR_NEW, returns STATUS
	category: class message
	Initializes the SEL_CHOICE_MGR_NEW structure to default values.

 Zeroes out pArgs->selChoiceMgr.
*/


/****************************************************************************
 msgSelChoiceMgrGetClient			takes P_OBJECT, returns STATUS
	Passes back the client uid held by the receiver.
*/
#define msgSelChoiceMgrGetClient 	MakeMsg(clsSelChoiceMgr, 1)


/****************************************************************************
 msgSelChoiceMgrSetClient			takes OBJECT, returns STATUS
	Sets the client uid held by the receiver.
*/
#define msgSelChoiceMgrSetClient 	MakeMsg(clsSelChoiceMgr, 2)


/****************************************************************************
 msgSelChoiceMgrGetId				takes P_U32, returns STATUS
	Passes back the id held by the receiver.
*/
#define msgSelChoiceMgrGetId	 	MakeMsg(clsSelChoiceMgr, 3)


/****************************************************************************
 msgSelChoiceMgrSetId				takes U32, returns STATUS
	Sets the id held by the receiver.
*/
#define msgSelChoiceMgrSetId 		MakeMsg(clsSelChoiceMgr, 4)


/****************************************************************************
 msgSelChoiceMgrNullCurrent			takes nothing, returns STATUS
	Tells the receiver to clear the visuals and state of the choice.

 After receiving this message, the choice will have no current value.
 This message does not result in the sending of any side-effect messages
 such as msgSelYield.
*/
#define msgSelChoiceMgrNullCurrent 	MakeMsg(clsSelChoiceMgr, 5)


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *			clsChoiceMgr Messages to which selChoiceMgrs Respond		   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgChoiceMgrGetOnButton			takes P_UID, returns STATUS
	Gets the current on button.  Passes back objNull if no button is on.
*/


/****************************************************************************
 msgChoiceMgrSetOnButton			takes UID, returns STATUS
	Sets the current on button.

 Since the choiceMgr will use msgControlSetValue to turn the button on,
 that button's normal notification protocol will be invoked.

 All buttons are turned off if message argument is objNull.
*/


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Client Messages							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgSelChoiceMgrAcquireSel		takes P_SEL_CHOICE_MGR_INFO, returns STATUS
	category: client responsibility
	Sent to the client whenever a different button is selected.

 The client would typically respond by doing the following:
	<remember what kind of selection self will own
		by writing pArgs->id into self's instance data>
	ObjCallRet(msgSelSelect, self, pNull, s);
	<don't call ancestor>
*/
#define msgSelChoiceMgrAcquireSel 	MakeMsg(clsSelChoiceMgr, 6)


/****************************************************************************
 msgSelChoiceMgrNullSel			takes P_SEL_CHOICE_MGR_INFO, returns STATUS
	category: client responsibility
	Sent to the client whenever a different button is selected.

 The client would typically respond by doing the following:
	ObjCallRet(msgSelSetOwner, theSelectionManager, objNull, s);
	<don't call ancestor>
 As a consequence of this, the client would then receive msgSelYield.
*/
#define msgSelChoiceMgrNullSel 		MakeMsg(clsSelChoiceMgr, 7)


#endif


