/****************************************************************************
 prframe.h
 
 Copyright 1992, GO Corporation, All Rights Reserved

 $Revision:   1.4  $
   $Author:   tbartlet  $
     $Date:   21 Feb 1992 17:00:16  $

 This file contains the API for clsPrintFrame.

 clsPrFrame inherits from clsCustomLayout.
 Provides the page outline during printing.

****************************************************************************/
#ifndef PRFRAME_INCLUDED
#define PRFRAME_INCLUDED

#ifndef GO_INCLUDED
#include <go.h>
#endif
#ifndef UID_INCLUDED
#include <uid.h>
#endif
#ifndef PRINT_INCLUDED
#include <print.h>
#endif



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/****   Window Tags for Child Windows  ****/
#define tagPrFrameLeftHeader			MakeTag(clsPrFrame, 255)
#define tagPrFrameCenterHeader			MakeTag(clsPrFrame, 254)
#define tagPrFrameRightHeader			MakeTag(clsPrFrame, 253)
#define tagPrFrameLeftFooter			MakeTag(clsPrFrame, 252)
#define tagPrFrameCenterFooter			MakeTag(clsPrFrame, 251)
#define tagPrFrameRightFooter			MakeTag(clsPrFrame, 250)
#define tagPrFrameMarginWin				MakeTag(clsPrFrame, 249)

#ifndef NO_NEW
#ifndef prFrameNewFields

#include <clayout.h>


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Messages											   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNewDefaults						takes P_PRFRAME_NEW, returns STATUS
	category: class message
	Initializes the PRFRAME_NEW_ONLY structure to default values.
*/
typedef PRINT_SETUP PRFRAME_NEW_ONLY, *P_PRFRAME_NEW_ONLY;

#define prFrameNewFields			\
	customLayoutNewFields			\
	PRFRAME_NEW_ONLY prFrame;

typedef struct PRFRAME_NEW {
	prFrameNewFields
} PRFRAME_NEW, *P_PRFRAME_NEW;

/****************************************************************************
 msgNewDefaults					takes P_PRFRAME_NEW, returns STATUS
	category: class message
	Initializes the default new arguments.

		no header or footer text
		headerMargin.top = 		500 Mils
		headerMargin.left = 	750 Mils
		headerMargin.right = 	750 Mils
		headerMargin.bottom = 	0 Mils
		footerMargin.top = 		0 Mils
		footerMargin.left = 	750 Mils
		footerMargin.right = 	750 Mils
		footerMargin.bottom = 	500 Mils
		mainMargin.top = 		750 Mils
		mainMargin.left = 		750 Mils
		mainMargin.right = 		750 Mils
		mainMargin.bottom = 	750 Mils
*/

/****************************************************************************
 msgNew							takes P_PRFRAME_NEW, returns STATUS
	category: class message
	Creates a new print frame object.
*/
#endif
#endif

/****************************************************************************
 msgPrFrameSend		takes P_PRFRAME_SEND, returns STATUS
	Sends the tagged window the message.
*/

typedef struct PRFRAME_SEND {
	U32 tag;				// window tag
	MESSAGE msg;			// message to send
	P_ARGS pArgs;			// arguments to pass
	SIZEOF lenSend;			// argument length
} PRFRAME_SEND, *P_PRFRAME_SEND;
#define msgPrFrameSend			MakeMsg(clsPrFrame, 1)

/****************************************************************************
 msgPrFrameSetup				takes P_PRINT_SETUP, returns STATUS
	Sets the print frame values/fields to the setup information.
*/
#define msgPrFrameSetup			MakeMsg(clsPrFrame, 2)

/****************************************************************************
 msgPrFrameExpand				takes P_PRFRAME_EXPAND, returns STATUS
	Expand any abbreviated labels for the current page/date/doc name. 
*/
typedef struct PRFRAME_EXPAND {
	char page[nameBufLength];	// printing page number (pg.)
	char date[nameBufLength];	// date string (dt.)
	char name[nameBufLength];	// doc name (nm.)
	char reserved[nameBufLength];
} PRFRAME_EXPAND, *P_PRFRAME_EXPAND;
#define msgPrFrameExpand		MakeMsg(clsPrFrame, 3)

#endif
