/****************************************************************************
 File: opttable.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.26  $
   $Author:   kcatlin  $
     $Date:   10 Mar 1992 10:24:30  $

 This file contains the API definition for clsOptionTable.

 clsOptionTable inherits from clsTkTable.

 Option tables implement no new behavior; they only change ancestor defaults
 to lay out their child windows in the standard two-column table format used
 by option sheets.
****************************************************************************/
#ifndef OPTTABLE_INCLUDED
#define OPTTABLE_INCLUDED

												#ifndef TKTABLE_INCLUDED
#include <tktable.h>
												#endif


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef OBJECT OPTION_TABLE;

typedef struct OPTION_TABLE_STYLE {
	U16	spare		: 16;	// unused (reserved)
} OPTION_TABLE_STYLE, *P_OPTION_TABLE_STYLE;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							Messages									   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNew		takes P_OPTION_TABLE_NEW, returns STATUS
	category: class message
	Creates an option table window.
*/

typedef struct OPTION_TABLE_NEW_ONLY {
	U32					spare1;			// unused (reserved)
	U32					spare2;			// unused (reserved)
} OPTION_TABLE_NEW_ONLY, *P_OPTION_TABLE_NEW_ONLY;

#define	optionTableNewFields	\
	tkTableNewFields   			\
	OPTION_TABLE_NEW_ONLY		optionTable;

typedef struct OPTION_TABLE_NEW {
	optionTableNewFields
} OPTION_TABLE_NEW, *P_OPTION_TABLE_NEW;


/****************************************************************************
 msgNewDefaults				takes P_OPTION_TABLE_NEW, returns STATUS
	category: class message
	Initializes the OPTION_TABLE_NEW structure to default values.

 Sets
//{
	pArgs->win.flags.style &= ~(wsClipChildren | wsFileInline);
	pArgs->border.style.leftMargin = bsMarginLarge;
	pArgs->border.style.rightMargin = bsMarginLarge;
	pArgs->border.style.bottomMargin = bsMarginLarge;
	pArgs->border.style.topMargin = bsMarginLarge;
	pArgs->gWin.style.grabDown = false;
	pArgs->tableLayout.style.childXAlignment = tlAlignBaseline;
	pArgs->tableLayout.style.childYAlignment = tlAlignBaseline;
	pArgs->tableLayout.style.growChildWidth = false;
	pArgs->tableLayout.style.growChildHeight = false;
	pArgs->tableLayout.numRows.constraint = tlInfinite;
	pArgs->tableLayout.numRows.value = 0;
	pArgs->tableLayout.numCols.constraint = tlAbsolute;
	pArgs->tableLayout.numCols.value = 2;
	pArgs->tableLayout.colWidth.constraint = tlGroupMax | tlBaselineBox;
	pArgs->tableLayout.rowHeight.constraint = tlGroupMax | tlBaselineBox;
	pArgs->tableLayout.rowHeight.gap = defaultRowGap;
	pArgs->tableLayout.colWidth.gap = defaultColGap;
//}

 Sends msgNewDefaults to clsLabel to initialize
 pNew->tkTable.pButtonNew, then sets:
//{
	pArgs->tkTable.pButtonNew->win.flags.style |= wsParentClip;
	pArgs->tkTable.pButtonNew->win.flags.style &= ~(wsClipSiblings | wsClipChildren);
	pArgs->tkTable.pButtonNew->border.style.backgroundInk = bsInkTransparent;
	pArgs->tkTable.pButtonNew->label.style.fontType = lsFontCustom;
	pArgs->tkTable.pButtonNew->label.font.attr.weight = sysDcWeightBold;
//}
*/


#endif	// OPTTABLE_INCLUDED


