/****************************************************************************
 File: instlsht.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.23  $
   $Author:   rfoster  $
     $Date:   28 Feb 1992 18:06:52  $

 This file contains the API definition for clsInstallUISheet.
 clsSettingsNB inherits from clsOption.
 This class defines the Installer sheet in the Settings Notebook.

 The Installer sheet contains one card for each installation category (apps, 
 preferences, services, etc).  Each category has an underlying install 
 manager (see instlmgr.h).  A card is automatically created when a new
 install manager is created, and deleted when an install manger is destroyed.

 The Installer sheet allows a client to display a particular card
 and select an item within that card.  Here's example code which activates
 the Settings Notebook from the Bookshelf, turns it to the Installer sheet,
 displays a particular card, selects an item within that card, and finally 
 opens the Settings Notebook:

//{
#include <auxnbmgr.h>
#include <instlsht.h>

{
	ANM_OPEN_NOTEBOOK	openNotebook;
	APP_METRICS			am;
	IUI_SELECT_ITEM		selectItem;
	OPTION_CARD			oc;
	IUI_SHOW_CARD		showCard;
	STATUS				s;

	ObjectCall(msgBusySetState, theBusyManager, (P_ARGS) true);
	openNotebook.notebook = anmSettings;
	openNotebook.activateOnly = true;
	ObjCallRet(msgANMOpenNotebook, theAuxNotebookMgr, &openNotebook, s);
	ObjSendUpdateRet(msgAppGetMetrics, openNotebook.uid, &am, SizeOf(am), s);
	oc.tag = tagSettingsInstallerSheet;
	ObjSendUpdateRet(msgOptionShowCard, am.mainWin, &oc, SizeOf(oc), s);
	ObjSendUpdateRet(msgOptionGetTopCard, am.mainWin, &oc, SizeOf(oc), s);
	strcpy(showCard.pCardName, "Applications");
	ObjSendRet(msgIUIShowCard, oc.win, &showCard, SizeOf(showCard), s);
	strcpy(selectItem.pItemName, appMgrMetrics.name);
	ObjSendRet(msgIUISelectItem, oc.win, &selectItem, SizeOf(selectItem), s);
	openNotebook.notebook = anmSettings;
	openNotebook.activateOnly = false;
	ObjCallRet(msgANMOpenNotebook, theAuxNotebookMgr, &openNotebook, s);
	ObjectCall(msgBusySetState, theBusyManager, (P_ARGS) false);
}
//}
****************************************************************************/
#ifndef INSTLSHT_INCLUDED
#define INSTLSHT_INCLUDED

#ifndef TKTABLE_INCLUDED
#include <tktable.h>
#endif

#ifndef FS_INCLUDED
#include <fs.h>
#endif

#ifndef OPTION_INCLUDED
#include <option.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * 				  				  	Messages  		  					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgIUIShowCard				takes P_IUI_SHOW_CARD, returns STATUS
	Show the specified Installer category card.

 Return Value
	stsFailed:		The specified card was not found.
*/
#define msgIUIShowCard			   		   	MakeMsg(clsInstallUISheet, 1)

typedef struct IUI_SHOW_CARD {
	CHAR				pCardName[nameBufLength]; // Card Name. These names
												  // correspond to installmgr
												  // names; ie. Applications,
												  // Services, Fonts. See
												  // instlmgr.h.
	TAG					itemTag;				  // If name is of zero length
												  // use the tag
} IUI_SHOW_CARD, * P_IUI_SHOW_CARD;


/****************************************************************************
 msgIUISelectItem				takes P_IUI_SELECT_ITEM, returns STATUS
	Set the selection to an item on the current card.

 Return Value
	stsFailed:		The specified item was not found.
*/
#define msgIUISelectItem		   		   	MakeMsg(clsInstallUISheet, 2)

typedef struct IUI_SELECT_ITEM {
	CHAR				pItemName[nameBufLength]; // Name of item to select.
	TAG					itemTag;				  // If name is of zero length
												  // use the tag
} IUI_SELECT_ITEM, * P_IUI_SELECT_ITEM;


/****************************************************************************
 msgIUIGetSelectionUID							takes P_UID, returns STATUS
	Gets the UID of the selection on the current card.

 Return Value
	stsFailed:		There is no selection.
*/
#define msgIUIGetSelectionUID		   		   	MakeMsg(clsInstallUISheet, 5)


/****************************************************************************
 msgIUIGetSelectionName							takes P_CHAR, returns STATUS
	Gets the name of the selection on the current card.

 Return Value
	stsFailed:		There is no selection.
*/
#define msgIUIGetSelectionName		   		   	MakeMsg(clsInstallUISheet, 6)


/****************************************************************************
 msgIUIGetMetrics				takes P_IUI_METRICS, returns STATUS
	Get installUI metrics.

*/
#define msgIUIGetMetrics		   		   	MakeMsg(clsInstallUISheet, 3)

typedef struct IUI_METRICS {
	OBJECT				currentCard;					 // Card displayed.
	CHAR				pCurrentCardName[nameBufLength]; // Name of displayed
														 // card.
	TAG					currentCardTag;					 // Tag of card.
    CHAR                spare[24];
} IUI_METRICS, * P_IUI_METRICS;


//REFGEN BEGINIGNORE
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * 			  			        Private									   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**** Quick Help Tags ****/
#define hlpIUIEditMenu						MakeTag(clsInstallUISheet, 1) 
#define hlpIUIOptionsMenu 					MakeTag(clsInstallUISheet, 2) 
#define hlpIUISaveMenu						MakeTag(clsInstallUISheet, 3) 
#define hlpIUIShowDiskViewer				MakeTag(clsInstallUISheet, 4) 
#define hlpIUICopyMenuItem					MakeTag(clsInstallUISheet, 6) 
#define hlpIUIRenameMenuItem				MakeTag(clsInstallUISheet, 7) 
#define hlpIUIDeleteMenuItem   				MakeTag(clsInstallUISheet, 8) 
#define hlpIUIColName						MakeTag(clsInstallUISheet, 17) 
#define hlpIUIColVersion					MakeTag(clsInstallUISheet, 18)
#define hlpIUIColSize						MakeTag(clsInstallUISheet, 19) 
#define hlpIUIColHwxType					MakeTag(clsInstallUISheet, 20) 
#define hlpIUIColSvcType					MakeTag(clsInstallUISheet, 21) 
#define hlpIUIColModified					MakeTag(clsInstallUISheet, 22) 
#define hlpIUIColCurrent					MakeTag(clsInstallUISheet, 23) 
#define hlpIUIColInUse						MakeTag(clsInstallUISheet, 24) 
#define hlpIUIInstallButton					MakeTag(clsInstallUISheet, 25) 
#define hlpIUIInstallCloseButton			MakeTag(clsInstallUISheet, 26) 
#define hlpIUIInstallEjectButton			MakeTag(clsInstallUISheet, 27) 
#define hlpIUICloseButton					MakeTag(clsInstallUISheet, 28) 

// tags 29 thru 31 are in settings.h, for preferences, installed software,
// and status option sheets

// tags 32 thru 38 are in instlmgr.h, for Installed Software option cards,
// created in init.c in the install project

#define hlpIUIEjectButton					MakeTag(clsInstallUISheet, 39) 


#define tagIUIEditMenu				    	hlpIUIEditMenu
#define tagIUIOptionsMenu		 		    hlpIUIOptionsMenu
#define tagIUIShowDiskViewer			    hlpIUIShowDiskViewer


/****  Tags  ****/
#define tagIUIDiskViewer					MakeTag(clsInstallUISheet, 40)
#define	tagIUIEntryOptionSheet				MakeTag(clsInstallUISheet, 101)
#define tagIUIDiskViewerWin					MakeTag(clsInstallUISheet, 41)


/****  Messages  ****/
/****************************************************************************
 msgIUIDoMyOptions					takes BOOLEAN, returns STATUS
	Sets the state so either I (TRUE) or some other component, such as
		the disk viewer, (FALSE) needs to be the recipient of the option
		protocol run.

*/
#define msgIUIDoMyOptions		   		   	MakeMsg(clsInstallUISheet, 4)


#define msgIUIRemove					   	MakeMsg(clsInstallUISheet, 24)
#define msgIUIRename					   	MakeMsg(clsInstallUISheet, 28)

#define msgIUIShowDiskViewer			   	MakeMsg(clsInstallUISheet, 30)
#define msgIUIPopUpCreate				   	MakeMsg(clsInstallUISheet, 31)
#define msgIUICreateDone				   	MakeMsg(clsInstallUISheet, 32)
#define msgIUIYes						   	MakeMsg(clsInstallUISheet, 40)
#define msgIUINo						   	MakeMsg(clsInstallUISheet, 41)
#define msgIUICancel					   	MakeMsg(clsInstallUISheet, 42)




STATUS GLOBAL TurnVolChoiceOn(
	P_STRING				pVolName,
	OBJECT					choice);

STATUS GLOBAL Layout(
	OBJECT				win);


// Object property tag for dynamic table uid.
#define	propDynTable			 		   MakeTag(clsInstallUISheet, 1)

//REFGEN ENDIGNORE
#endif // INSTLSHT_INCLUDED
