/****************************************************************************
 File: inifile.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.40  $
   $Author:   sisaac  $
     $Date:   02 Mar 1992 10:18:40  $

 This file contains the API definition for clsIniFileHandler.
 clsIniFileHandler inherits from clsObject.
 Reads and processes a .ini file. 

 .ini files are used to ask the system to install multiple applications,
 services, or any installable entity. A .ini file is an ASCII file that
 contains the path of each item to be installed on a seperate line.
 Examples of .ini files include app.ini (applications) and 
 service.ini (services).

 To process a .ini file, simply create an instance of clsIniFileHandler. The
 newArgs specify the location of the .ini file. The .ini file will be 
 completely processed as part of the msgNew. Free the ini file handler 
 immediately after creating it. 
****************************************************************************/
#ifndef INIFILE_INCLUDED
#define INIFILE_INCLUDED

#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
#endif

#ifndef INSTLMGR_INCLUDED
#include <instlmgr.h>
#endif


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * 				  				  	Messages  		  					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNew							takes P_INI_FILE_NEW, returns STATUS
	category: class message
	Creates a new ini file processor.

 This message will return after the entire file has been processed. 
 The file is processed by sending msgIMInstall to the specified 
 install manager for each path in the .ini file.

 pArgs->iniFile.listAttrLabel and pArgs->iniFile.listHandle are passed
 through to msgIMInstall. See instlmgr.h for details on msgIMInstall.
*/

typedef struct INI_FILE_STYLE {
	U16 deleteFileWhenDone	: 1,    // Delete file after processing it.
		returnInstallErrors : 1,	// Aborts the install and returns error
									// status if true. Keeps going if false.
		spare				: 11;	// unused (reserved)
} INI_FILE_STYLE, *P_INI_FILE_STYLE;

typedef struct INI_FILE_NEW_ONLY {
	INI_FILE_STYLE		style;
	IM_INSTALL_EXIST	exist;			// What to do if the item already 
										// exists.
	FS_LOCATOR			locator;		// .ini file location.
	OBJECT				manager;   		// Install manager to send 
										// msgIMInstalls to.
	FS_ATTR_LABEL	  	listAttrLabel;	// List attr; 0 if not needed.
	OBJECT				listHandle;		// FS handle for list attr; objNull 
										// if not needed.
	OBJECT				relDir;			// Relative dir for ini file paths.
    U8                  spare[8];
} INI_FILE_NEW_ONLY, *P_INI_FILE_NEW_ONLY;

#define	iniFileNewFields		\
	objectNewFields 			\
	INI_FILE_NEW_ONLY			iniFile;

typedef struct INI_FILE_NEW {
	iniFileNewFields
} INI_FILE_NEW, *P_INI_FILE_NEW;


/****************************************************************************
 msgNewDefaults					takes P_INI_FILE_NEW, returns STATUS
	category: class message
    Initializes the INI_FILE_NEW structure to default values.
	
 Sets
	iniFile.style.returnInstallErrors = true;
	iniFile.style.deleteFileWhenDone = false;
	iniFile.listAttrLabel = 0;
	iniFile.listHandle = objNull;
	iniFile.exist = imExistReactivate;
*/

#endif	// INIFILE_INCLUDED

