/****************************************************************************
 File: cmdbar.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.49  $
   $Author:   kcatlin  $
     $Date:   17 Mar 1992 14:39:38  $

 This file contains the API definition for clsCommandBar.

 clsCommandBar inherits from clsTkTable.
 Command bars are tkTables of buttons used in option sheets and frames.
****************************************************************************/
#ifndef CMDBAR_INCLUDED
#define CMDBAR_INCLUDED

													#ifndef TKTABLE_INCLUDED
#include <tktable.h>
													#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef OBJECT	COMMAND_BAR;

typedef struct COMMAND_BAR_STYLE {
	U16	spare			: 16;	// unused (reserved)
} COMMAND_BAR_STYLE, *P_COMMAND_BAR_STYLE;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							Messages									   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNew		takes P_COMMAND_BAR_NEW, returns STATUS
	category: class message
	Creates a command bar window.
*/

typedef struct COMMAND_BAR_NEW_ONLY {
	COMMAND_BAR_STYLE  	style;		// overall style
	U32					spare;		// unused (reserved)
} COMMAND_BAR_NEW_ONLY, *P_COMMAND_BAR_NEW_ONLY;

#define	commandBarNewFields	\
	tkTableNewFields		\
	COMMAND_BAR_NEW_ONLY		commandBar;

typedef struct COMMAND_BAR_NEW {
	commandBarNewFields
} COMMAND_BAR_NEW, *P_COMMAND_BAR_NEW;

/****************************************************************************
 msgNewDefaults				takes P_COMMAND_BAR_NEW, returns STATUS
	category: class message
	Initializes the COMMAND_BAR_NEW structure to default values.

 Sets
//{
	pArgs->gWin.style.gestureEnable = false;

	pArgs->border.style.backgroundInk = bsInkGray33;

	pArgs->border.style.topMargin = bsMarginMedium;
	pArgs->border.style.bottomMargin = bsMarginMedium;
	pArgs->border.style.leftMargin = bsMarginSmall;
	pArgs->border.style.rightMargin = bsMarginSmall;

	pArgs->tableLayout.style.tblXAlignment = tlAlignCenter;
	pArgs->tableLayout.style.tblYAlignment = tlAlignCenter;
	pArgs->tableLayout.style.childXAlignment = tlAlignCenter;
	pArgs->tableLayout.style.childYAlignment = tlAlignCenter;
	pArgs->tableLayout.style.growChildWidth = false;
	pArgs->tableLayout.style.growChildHeight = true;

	pArgs->tableLayout.numCols.constraint = tlInfinite;
	pArgs->tableLayout.numRows.constraint = tlAbsolute;
	pArgs->tableLayout.numRows.value = 1;
	pArgs->tableLayout.colWidth.constraint = tlGroupMax;
	pArgs->tableLayout.colWidth.gap = defaultColGap;
	pArgs->tableLayout.rowHeight.constraint = tlChildrenMax;
	pArgs->tableLayout.rowHeight.gap = 0;
//}
 Alters pArgs->tkTable.pButtonNew as in msgTkTableChildDefaults.
*/

/****************************************************************************
 msgCommandBarGetStyle		takes P_COMMAND_BAR_STYLE, returns STATUS
	Passes back the current style values.
*/
#define msgCommandBarGetStyle		MakeMsg(clsCommandBar, 1)

/****************************************************************************
 msgCommandBarSetStyle		takes P_COMMAND_BAR_STYLE, returns STATUS
	Sets the style values.
*/
#define msgCommandBarSetStyle		MakeMsg(clsCommandBar, 2)

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *				    Messages from Other Classes							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgTkTableChildDefaults		takes P_UNKNOWN, returns STATUS
	Sets the defaults in pArgs for a common child.

 clsCommandBar sets up defaults for each child as follows:

 If the child is a descendant of clsGWin, then
//{
	pArgs->gWin.style.gestureEnable = false;
//}

 If the child is a descendant of clsButton, then
//{
	pArgs->button.style.feedback = bsFeedback3D;
//}
*/

#endif	// CMDBAR_INCLUDED
