/****************************************************************************
 File: choice.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.53  $
   $Author:   sbartlet  $
     $Date:   04 Mar 1992 13:56:32  $

 This file contains the API for clsChoice.

 clsChoice inherits from clsTkTable.
 Choices are tkTables of buttons that act as exclusive choices.

 Note that msgNewDefaults to clsChoice results in a prototypical new struct
 whose values describe a button of contact style bsContactLockOn.  This is
 correct for choices that always have one button on, but this won't work
 if you want a choice that can have 0 or 1 buttons on.  In this case,
 making each button child have a contact style of bsContactToggle will
 achieve the desired effect.  Here is the appropriate code.
//{
	ObjCallWarn(MsgNewDefaults, clsChoice, &choiceNew);
	choiceNew.tkTable.pButtonNew->button.style.contact = bsContactToggle;
	ObjCallRet(msgNew, clsChoice, &choiceNew, s);
//}
 See the documentation for msgTkTableChildDefaults below.
****************************************************************************/

#ifndef CHOICE_INCLUDED
#define CHOICE_INCLUDED

												#ifndef TKTABLE_INCLUDED
#include <tktable.h>
												#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *						Common #defines and typedefs					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef OBJECT CHOICE;

typedef struct CHOICE_STYLE {
	U16	spare;  // unused (reserved)
} CHOICE_STYLE, *P_CHOICE_STYLE;

/*
 Informational return status
 returned by msgControlGetValue if choice has no value
*/
#define stsChoiceNoValue	MakeWarning(clsChoice, 1)


/****************************************************************************
 msgNew						takes P_CHOICE_NEW, returns STATUS
	category: class message
	Creates a choice (and its nested button windows).

 Will create a default instance of clsChoiceMgr if the incoming
 pArgs->tkTable.manager is null.  The uid of the created manager will be
 an out parameter.

 After the manager has been set up, clsChoice will use msgControlGetValue
 to find the button that is 'on', and then send msgChoiceMgrSetNoNotify
 to the manager to tell the manager which button is 'on'.
*/

typedef struct CHOICE_NEW_ONLY {
	CHOICE_STYLE	style;	// overall style
	U32				value;	// tag of on button
	U32				spare;	// unused (reserved)
} CHOICE_NEW_ONLY, *P_CHOICE_NEW_ONLY;

#define	choiceNewFields	\
	tkTableNewFields	\
	CHOICE_NEW_ONLY		choice;

typedef struct CHOICE_NEW {
	choiceNewFields
} CHOICE_NEW, *P_CHOICE_NEW;


/****************************************************************************
 msgNewDefaults				takes P_CHOICE_NEW, returns STATUS
	category: class message
	Initializes the CHOICE_NEW structure to default values.

 Sets up tkTable.pButtonNew to create buttons by default.
 Zeroes out pNew.choice and sets:
//{
	pArgs->gWin.style.gestureEnable = false;

	pArgs->tableLayout.style.growChildHeight = false;
	pArgs->tableLayout.style.growChildWidth = true;

	pArgs->tableLayout.numCols.constraint = tlAbsolute;
	pArgs->tableLayout.numCols.value = 1;

	pArgs->tableLayout.numRows.constraint = tlInfinite;

	pArgs->tableLayout.colWidth.constraint = tlChildrenMax;
	pArgs->tableLayout.colWidth.gap = 0;

	pArgs->tableLayout.rowHeight.constraint = tlGroupMax;
	pArgs->tableLayout.rowHeight.gap = 0;

	pArgs->tkTable.manager = objNull;
//}
*/


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Instance Messages		  				   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgChoiceGetStyle		takes P_CHOICE_STYLE, returns STATUS
	Gets the style of the receiver.
*/
#define msgChoiceGetStyle	  	MakeMsg(clsChoice, 1)


/****************************************************************************
 msgChoiceSetStyle		takes P_CHOICE_STYLE, returns STATUS
	Sets the style of the receiver.
*/
#define msgChoiceSetStyle	  	MakeMsg(clsChoice, 2)


/****************************************************************************
 msgChoiceSetNoNotify	takes TAG, returns STATUS
	Like msgControlSetValue (see below), but without button notifications.

 Using this message avoids button notifications being sent out to their
 clients.
*/
#define msgChoiceSetNoNotify 	MakeMsg(clsChoice, 3)


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *				    Messages from Other Classes							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgFree	takes OBJ_KEY, returns STATUS
	Sent as the last of three msgs to destroy an object.

 If the choice had created its own TK_TABLE_NEW_ONLY.manager at msgNew time,
 the manager will be sent msgDestroy.
*/


/****************************************************************************
 msgRestore	takes P_OBJ_RESTORE, returns STATUS
	Creates and restores an object from an object file.

 clsChoice responds by restoring its instance data.  If the choice had
 created its own TK_TABLE_NEW_ONLY.manager at msgNew time, a new one is
 created from clsChoiceMgr.
*/


/****************************************************************************
 msgSave	takes P_OBJ_SAVE, returns STATUS
	Causes an object to file itself in an object file.

 clsChoice responds by filing away its instance data.  It will remember
 whether clsChoice created its own TK_TABLE_NEW_ONLY.manager at msgNew time.
*/


/****************************************************************************
 msgWinSend 	takes P_WIN_SEND, returns STATUS
    Sends a message up a window ancestry chain.

 clsChoice responds when pArgs->msg is msgButtonBeginPreview or msgButtonDone
 by using msgControlSetDirty(true) to mark its children as dirty.  This is
 done as follows:

 clsChoice calls its ancestor and remembers the returned status.  It then
 tests whether pArgs->msg is msgButtonDone.  If so, then if one of the
 child buttons is currently previewing, clsChoice just returns the saved
 status (because it was when the previewing started that the choice marked
 its children as dirty).  If, however, the msg is msgButtonDone and no
 button is previewing, the choice will go ahead and mark its children dirty
 (this case can happen if a child button is changing value programmatically
 and so isn't previewing), then return stsManagerContinue.

 If the pArgs->msg is msgButtonBeginPreview, the choice will mark its children
 dirty and then return stsManagerContinue.

 If the pArgs->msg is anything else, clsChoice will return the status
 saved from the call to its ancestor.

 Return Value
	stsManagerContinue:		tell the caller to continue to propagate
							the msgWinSend
*/


/****************************************************************************
 msgControlGetDirty		takes P_BOOLEAN, returns STATUS
	Sets *pArgs true if any child control is dirty, false otherwise.
*/


/****************************************************************************
 msgControlGetEnable	takes P_BOOLEAN, returns STATUS
	Sets *pArgs true if any child control is enabled, false otherwise.
*/


/****************************************************************************
 msgControlGetValue		takes P_TAG, returns STATUS
	Gets the tag of the child button that is currently on.

 Returns stsChoiceNoValue if no child button is on.
*/


/****************************************************************************
 msgControlSetDirty		takes BOOLEAN, returns STATUS
	Forwards this message and pArgs on to each child control in the choice.
*/


/****************************************************************************
 msgControlSetEnable	takes BOOLEAN, returns STATUS
	Forwards this message and pArgs on to each child control in the choice.
*/


/****************************************************************************
 msgControlSetValue		takes TAG, returns STATUS
	Turns on the child button having the passed tag.

 If another child button was on, it is turned off.
*/


/****************************************************************************
 msgTkTableAddAsFirst		takes WIN, returns STATUS
	Adds specified window as the first child in the table.

 clsChoice first calls its ancestor, then gets its manager via
 msgTkTableGetManager.  If it has no manager, clsChoice returns stsOK.
 Otherwise, clsChoice gets the BUTTON_STYLE.on value of the new button and,
 if that is true, uses msgChoiceMgrSetOnButton to change the choice's 'on'
 button to the one just added.
*/


/****************************************************************************
 msgTkTableAddAsLast		takes WIN, returns STATUS
	Adds specified window as the last child in the table.

 clsChoice first calls its ancestor, then gets its manager via
 msgTkTableGetManager.  If it has no manager, clsChoice returns stsOK.
 Otherwise, clsChoice gets the BUTTON_STYLE.on value of the new button and,
 if that is true, uses msgChoiceMgrSetOnButton to change the choice's 'on'
 button to the one just added.
*/


/****************************************************************************
 msgTkTableAddAsSibling		takes P_TK_TABLE_ADD_SIBLING, returns STATUS
	Inserts specified window in front of or behind an existing child.

 clsChoice first calls its ancestor, then gets its manager via
 msgTkTableGetManager.  If it has no manager, clsChoice returns stsOK.
 Otherwise, clsChoice gets the BUTTON_STYLE.on value of the new button and,
 if that is true, uses msgChoiceMgrSetOnButton to change the choice's 'on'
 button to the one just added.
*/


/****************************************************************************
 msgTkTableAddAt		takes P_TK_TABLE_ADD_AT, returns STATUS
	Inserts specified window table at specified index.

 clsChoice first calls its ancestor, then gets its manager via
 msgTkTableGetManager.  If it has no manager, clsChoice returns stsOK.
 Otherwise, clsChoice gets the BUTTON_STYLE.on value of the new button and,
 if that is true, uses msgChoiceMgrSetOnButton to change the choice's 'on'
 button to the one just added.
*/


/****************************************************************************
 msgTkTableRemove		takes WIN, returns STATUS
	Extracts pArgs from the table.

 clsChoice first calls its ancestor, then gets its manager via
 msgTkTableGetManager.  If it has no manager, clsChoice returns stsOK.
 Otherwise, clsChoice checks to see if the button being removed is the one
 that is currently 'on' (by sending msgChoiceMgrGetOnButton to its manager).
 If so, the choice will either set the manager's 'on' button to the first
 remaining child (if the button's BUTTON_STYLE.contact is bsContactLockOn),
 or to null (if no children remain or the button's BUTTON_STYLE.contact
 is anything else).  Put simply, the choice repairs its state according to
 whether the choice is always exactly one value, or can have no value.
*/


/****************************************************************************
 msgTkTableChildDefaults		takes P_UNKNOWN, returns STATUS
	Sets the defaults in P_ARGS for a common child.

 This can be sent to either an instance of clsChoice or to clsChoice itself.
 Here is the response for either case:
//{
	if <pArgs->object.class inherits from clsGWin>
		pArgs->gWin.style.gestureEnable = false;

	if <pArgs->object.class inherits from clsBorder> {
		pArgs->border.style.edge = bsEdgeNone;
		pArgs->border.style.topMargin = 1;
		pArgs->border.style.bottomMargin = 1;
	}

	if <pArgs->object.class inherits from clsLabel>
		pArgs->label.style.xAlignment = lsAlignLeft;

	if <pArgs->object.class inherits from clsButton> {
		pArgs->button.style.notifyDetail = true;
		pArgs->button.style.contact = bsContactLockOn;
		pArgs->button.style.feedback = bsFeedbackDecorate;
		pArgs->button.style.offDecoration =
			lsDecorationExclusiveOff;
		pArgs->button.style.onDecoration =
			lsDecorationExclusiveOn;
	}
//}
*/


#endif	// CHOICE_INCLUDED
