/****************************************************************************
 File: chmgr.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.43  $
   $Author:   cmeyer  $
     $Date:   18 Mar 1992 16:59:38  $

 This file contains the API for clsChoiceMgr.
 
 clsChoiceMgr inherits from clsManager.
 Choice managers serve as tkTable managers in tables of buttons.

 A choice manager, when plugged in as the manager of a tkTable of buttons,
 responds to the msgWinSend's generated by the buttons and makes the entire
 group perform as a choice.
****************************************************************************/

/**** Debugging Flags ****/
/*
 The clsChoiceMgr debugging flag is 'K'.  Defined values are:

    flag0  (0x0001):    general info
*/

#ifndef CHMGR_INCLUDED
#define CHMGR_INCLUDED

												#ifndef MANAGER_INCLUDED
#include <manager.h>
												#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *						Common #defines and typedefs					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef OBJECT				CHOICE_MGR;

/****************************************************************************
 msgNew						takes P_CHOICE_MGR_NEW, returns STATUS
	category: class message
	Creates a choice manager.
*/

typedef struct CHOICE_MGR_NEW_ONLY {
	U32		spare;	// unused (reserved)
} CHOICE_MGR_NEW_ONLY, *P_CHOICE_MGR_NEW_ONLY;

#define	choiceMgrNewFields	\
	managerNewFields		\
	CHOICE_MGR_NEW_ONLY		choiceMgr;

typedef struct CHOICE_MGR_NEW {
	choiceMgrNewFields
} CHOICE_MGR_NEW, *P_CHOICE_MGR_NEW;


/****************************************************************************
 msgNewDefaults				takes P_CHOICE_MGR_NEW, returns STATUS
	category: class message
	Initializes the CHOICE_MGR_NEW structure to default values.

 clsChoiceManager has no instance data of its own.
*/


/****************************************************************************
 msgChoiceMgrGetOnButton			takes P_UID, returns STATUS
	Gets the current on button.  Passes back objNull if no button is on.
*/
#define msgChoiceMgrGetOnButton		MakeMsg(clsChoiceMgr, 1)


/****************************************************************************
 msgChoiceMgrSetOnButton			takes UID, returns STATUS
	Sets the current on button.

 Since the choiceMgr will use msgControlSetValue to turn the button on,
 that button's normal notification protocol will be invoked.

 All buttons are turned off if message argument is objNull.
*/
#define msgChoiceMgrSetOnButton		MakeMsg(clsChoiceMgr, 2)


/****************************************************************************
 msgChoiceMgrSetNoNotify			takes UID, returns STATUS
	Like msgChoiceMgrSetOnButton, but no notifications are generated.
*/
#define msgChoiceMgrSetNoNotify		MakeMsg(clsChoiceMgr, 3)


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *				    Messages from Other Classes							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgWinSend 	takes P_WIN_SEND, returns STATUS
    Sends a message up a window ancestry chain.

 clsChoiceMgr responds when pArgs->msg is msgButtonBeginPreview,
 msgButtonCancelPreview, or msgButtonDone.  If pArgs->msg is anything else,
 clsChoiceMgr just returns stsManagerContinue.

 For these three messages, clsChoiceMgr will make the set of entry
 windows act as a group.

 Return Value
	stsManagerContinue:	clsChoiceMgr always returns this so that the caller
						will continue to propagate the msgWinSend.
*/


#endif	// CHMGR_INCLUDED


