/****************************************************************************
 File: busy.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.31  $
   $Author:   cmeyer  $
     $Date:   18 Mar 1992 16:57:36  $

 This file contains the API for clsBusy and theBusyManager.

 clsBusy inherits from clsObject.
 theBusyManager is typically the only instance of clsBusy.
 theBusyManager puts up and takes down a visual indication that the system
 is busy.
****************************************************************************/

/**** Debugging Flags ****/
/*
 The clsBusy debugging flag is 'K'.  Defined values are:

    flag0  (0x0001):    general busy on/off/inhibit
    flag10 (0x0400):    never put up the busy UI
*/

#ifndef BUSY_INCLUDED
#define BUSY_INCLUDED

												#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
												#endif


/****************************************************************************
 msgBusyDisplay		takes U32, returns STATUS
	Requests a change in the state of the busy UI.

 You send this message to theBusyManager.

 theBusyManager maintains a reference count.  Requests of busyOn increment
 the count, and requests of busyOff decrement the count.  theBusyManager will
 put up the UI when the count goes from 0 to 1, and take the UI down when
 the count goes from 1 to 0.

 If pArgs is busyOn | busyNoRefCount, and the reference count is already
 1 or greater (i.e. the busy UI is already being displayed), nothing is done.

 If pArgs is busyOn | busyNoDelay, the busy UI will be displayed immediately,
 skipping the usual delay time.

 If pArgs is busyOff | busyNoRefCount, the reference count is set to 0
 and the busy UI is taken down.

 The busy UI will be displayed (i.e. hot spot at) the last xy specified
 via msgBusySetXY.  If this is (minS32, minS32), the xy specified via
 msgBusySetDefaultXY will be used.

 When the busy UI is taken down, the xy for the next display of the busy UI
 is set to (minS32, minS32).  

 See Also
 	msgBusyInhibit
	msgBusySetXY
	msgBusySetDefaultXY
*/
#define msgBusyDisplay			MakeMsg(clsBusy, 9)

#define	busyOff				0		// turn the busy UI off
#define	busyOn				1		// turn the busy UI on

// these can be or-ed into busyOn or busyOff
#define	busyNoRefCount		flag1	// don't increment/decrement the ref count
#define	busyNoDelay			flag2	// don't wait for timer to display

/****************************************************************************
 msgBusyInhibit		takes BOOLEAN, returns STATUS
	Inhibits/allows display of the busy UI.

 You send this message to theBusyManager.

 theBusyManager maintains an inhibit reference count.  Requests of TRUE
 increment the count, and requests of FALSE decrement the count.
 theBusyManager will take down the UI when the count goes from 0 to 1, and
 allow subsequent displays of the busy UI (via msgBusyDisplay(busyOn)) when
 the count is zero.

 You can use msgBusyInhibit to prevent the busy UI from being displayed,
 even if requested by other parts of the system.

 See Also
 	msgBusyDisplay
*/
#define msgBusyInhibit			MakeMsg(clsBusy, 10)

/****************************************************************************
 msgBusySetXY			takes P_XY32, returns STATUS
	Specifies the position for the busy UI the next time it is shown.

 You send this message to theBusyManager.  The UI will be centered at pArgs
 the next time msgBusyDisplay(busyOn) is sent.

 pArgs should be in root window space.

 If the busy UI is currently being shown, this message is ignored.
*/
#define msgBusySetXY		MakeMsg(clsBusy, 11)

/****************************************************************************
 msgBusySetDefaultXY		takes P_XY32, returns STATUS
	Specifies the default position for the busy UI the next time it is shown.

 The input system sends this message to theBusyManager when an input event
 has not been processed within the default time limit.  The UI will be
 centered at pArgs the next time msgBusyDisplay(busyOn) is sent, if
 msgBusySetXY has not been used to specify a position.

 pArgs should be in root window space.
*/
#define msgBusySetDefaultXY		MakeMsg(clsBusy, 12)

/****************************************************************************
 msgBusyGetSize		    takes P_SIZE32, returns STATUS
	Passes back the size of the busy UI.

 theBusyManager will set *pArgs to the size of the default UI.
*/
#define msgBusyGetSize		    MakeMsg(clsBusy, 3)


#endif	// BUSY_INCLUDED

