/****************************************************************************
 booterrs.h
 Copyright 1992, GO Corporation, All Rights Reserved

 Error codes used with the AbortBoot routine in ppboot and penpoint.os.

 $Revision:   1.5  $
   $Author:   CPAYNE  $
     $Date:   13 Mar 1992 19:18:52  $
****************************************************************************/
#ifndef BOOTERRS_INCLUDED
#define BOOTERRS_INCLUDED

/****************************************************************************

	These codes are displayed when a fatal error occures during booting.
	Because a user may have to remember and report the error code to
	someone else the number should be small ( less than 2000).
	
	Code zero is never used.

	Codes 1 through 999 are reserved for the boot program. Of these 1 through
	99 are defined by GO and consistent across all machines. Codes 100 to
	999 can be used by OEMs for machine specific errors. For the sample boot
	programs supplied by GO (and probably copied by some OEMs) the unit of
	the boot device is multiplied by 100 and added to the boot program error
	codes. Thus an error of 115 would indicate error 15 while booting from
	unit 1. Typically the floppy drive in unit 0 and the hard drive unit 1.

	The portable codes used by PenPoint start at 1000.

	Naming convention: to make it easier to track-down the location of
	the error code a name is constructed thusly:

	"bootErr" + <file name> + <terse description>

	See below for examples.

****************************************************************************/

// Next boot program error number available:	28
// Boot program error numbers to be recycled:	None

// Next PenPoint error number available:		1021
// PenPoint error numbers to be recycled:		None

/****************************************************************************

 Errors encountered in the boot program.

****************************************************************************/

#define bootErrDriveNotFound			1
#define bootErrOpenDrive				2		
#define bootErrLabelNotFound			3
#define bootErrCorruptFileSystem		4
#define bootErrMILNotFound				5
#define bootErrMILReadErr				6
#define bootErrMILWrongFormat			7
#define bootErrMILWrongSignature		8
#define bootErrMILWrongTailLen			9
#define bootErrMILZeroLength			10
#define bootErrMILTooBigForMem			11
#define bootErrMILIniNotFound			12
#define bootErrReadErrMILIni			13
#define bootErrPPNotFound				14
#define bootErrPPMILVersionMismatch		15
#define bootErrPPReadErr			   	16
#define bootErrPPWrongFormat			17
#define bootErrPPWrongSignature			18
#define bootErrPPWrongTailLen			19
#define bootErrPPZeroLength				20
#define bootErrPPTooBigForMem			21
#define bootErrSwapFileReadErr			22
#define bootErrMemSizing				23
#define bootErrNoLinearPgDirEntry		24
#define	bootErrInitFileSys				25
#define bootErrUnknownDrive				26
#define bootErrExitProgram				27

/****************************************************************************

 Errors encountered in PenPoint

****************************************************************************/

// Used in DrvMILSetWellKnownIds()
#define bootErrDrvmilNoStylus			1000
#define bootErrDrvmilNoPowerDev			1001
#define bootErrDrvmilNoTimer			1002
#define bootErrDrvmilNoClock			1003
#define bootErrDrvmilNoIntrCtlr			1004
#define bootErrDrvmilNoScreen			1005
#define bootErrDrvmilNoBlock			1006

// File system related
#define bootErrStartupNoBootDiskLabel	1007

// Non-maskable interrupt
#define bootErrDrvmilNMI				1008

// StdError: Note also displays
// TagAdmin(status) and TagNum(status),
#define bootErrStdErrorOccurred			1009

// Environ.ini file not found
#define bootErrStartupNoEnvironIni		1010

// Boot volume not found (or error accessing)
#define bootErrFsvolNoBootVolume		1011

// Invalid PenPointPath specified in environ.ini
#define bootErrFscInvalidPenPointPath	1012

// Boot.dlc file not found
#define bootErrConfNoBootDlc			1013

// Error creating swap file
#define	bootErrVMSwapFile				1014

// Error starting page daemon
#define	bootErrVMPageDaemon				1015

// Not enough memory to boot
#define	bootErrVMMemory					1016

// Boot program did not pass in valid boot time
#define bootErrDrvmilNoBootTime			1017

// Boot program did not pass in complete V8086 information
#define bootErrDrvmilNoV8086Info		1018

// A core MIL device (timer, interrupt, debug and optionally keyboard)
// failed to initialized
#define bootErrDrvmilCoreInitFail		1019

// A core MIL device (timer, interrupt, debug and optionally keyboard)
// has a multi-staged init function
#define bootErrDrvmilCoreMultiStage		1020

#endif
