#define NEWFC 1
/****************************************************************************
 dbinit.c 
 (C) Copyright 1992 by GO Corporation, All Rights Reserved.
 
 $Revision:   1.32  $
   $Author:   mbowles  $
     $Date:   19 Mar 1992 16:24:58  $

 DB initialization C-code (read and interpreted by DB)
 DB version 2.29

***************************************************************************/

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							go.h stuff
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#define NULL 	0
#define null	0
#define pNull			((P_UNKNOWN)0)
#define ppNull			((PP_UNKNOWN)0)
#define Nil(type)		((type)0)

#define flag0			(0x0001)
#define flag1			(0x0002)
#define flag2			(0x0004)
#define flag3			(0x0008)
#define flag4			(0x0010)
#define flag5			(0x0020)
#define flag6			(0x0040)
#define flag7			(0x0080)
#define flag8			(0x0100)
#define flag9			(0x0200)
#define flag10			(0x0400)
#define flag11			(0x0800)
#define flag12			(0x1000)
#define flag13			(0x2000)
#define flag14			(0x4000)
#define flag15			(0x8000)
#define flag16			(0x00010000L)
#define flag17			(0x00020000L)
#define flag18			(0x00040000L)
#define flag19			(0x00080000L)
#define flag20			(0x00100000L)
#define flag21			(0x00200000L)
#define flag22			(0x00400000L)
#define flag23			(0x00800000L)
#define flag24			(0x01000000L)
#define flag25			(0x02000000L)
#define flag26			(0x04000000L)
#define flag27			(0x08000000L)
#define flag28			(0x10000000L)
#define flag29			(0x20000000L)
#define flag30			(0x40000000L)
#define flag31			(0x80000000L)

#define maxU8			((U8)0xFF)
#define minS8			((S8)0x80)
#define maxS8			((S8)0x7F)
#define maxU16			((U16)0xFFFF)
#define minS16			((S16)0x8000)
#define maxS16			((S16)0x7FFF)
#define maxU32			((U32)0xFFFFFFFF)
#define minS32			((S32)0x80000000)
#define maxS32			((S32)0x7FFFFFFF)

#define maxNameLength	32
#define nameBufLength	(maxNameLength+1)

typedef U8 * P_U8;
typedef U8 ** PP_U8;
typedef U16 * P_U16;
typedef U32 ** PP_U32;
typedef S8 * P_S8;
typedef S8 ** PP_S8;
typedef S16 * P_S16;
typedef S16 ** PP_S16;
typedef S32 * P_S32;
typedef S32 ** PP_S32;

typedef U8 CHAR8;
typedef CHAR8 * P_CHAR8;
typedef CHAR8 ** PP_CHAR8;
typedef U16 CHAR16;
typedef CHAR16 * P_CHAR16;
typedef CHAR16 ** PP_CHAR16;

typedef CHAR * P_CHAR;
typedef CHAR ** PP_CHAR;
typedef CHAR STRING;
typedef STRING * P_STRING;
typedef STRING ** PP_STRING;

typedef void * P_UNKNOWN;
typedef P_UNKNOWN * PP_UNKNOWN;

#define Abs(v)			((v)<0?(-(v)):(v))
#define Max(a,b)		((a)>(b)?(a):(b))
#define Min(a,b)		((a)<(b)?(a):(b))
#define Odd(v)			((v)&1)
#define Even(v)			(!Odd(v))

#define LowU16(dw)		((U16)(U32)(dw))
#define HighU16(dw)		((U16)((U32)(dw)>>16))
#define LowU8(w)		((U8)(w))
#define HighU8(w)		((U8)((U16)(w)>>8))
#define MakeU16(lb,hb)	(((U16)(hb)<<8)|(U16)(lb))
#define MakeU32(lw,hw)	(((U32)(hw)<<16)|(U32)(lw))

#define FlagOn(f,v)		(!FlagOff(f,v))
#define FlagOff(f,v)	(!((v)&(f)))
#define FlagSet(f,v)	((v)|(f))
#define FlagClr(f,v)	((v)&(~(f)))

#define OutRange(v,l,h)	((v)<(l)||(v)>(h))
#define InRange(v,l,h)	((v)>=(l)&&(v)<=(h))

#define SizeOf(t)		((SIZEOF)sizeof(t))

typedef OBJECT UID;
typedef UID * P_UID;

#define MakeWKN(admin,version,scope) \
	((UID)((U32)(0x7F&(version))<<24|(U32)(admin)<<1+(scope&1)|scope))
#define MakeGlobalWKN(admin,version) \
	MakeWKN(admin,version,wknGlobal)
#define MakeProcessGlobalWKN(admin,version) \
	MakeWKN(admin,version,wknProcessGlobal)
#define MakePrivateWKN(admin,version) \
	MakeWKN(admin,version,wknPrivate)

#define WKNValue(wkn)	(0x1FFFFF&(U32)wkn)
#define WKNAdmin(wkn)	(WKNValue(wkn)>>1+((U32)wkn&1))
#define WKNVer(wkn)		((U32)(wkn)>>24)
#define WKNScope(wkn)	((U32)(wkn)&-((U32)(wkn)&1)&3)

#define wknGlobal			0
#define wknProcessGlobal	1
#define wknPrivate			3

typedef STATUS TAG;
typedef TAG * P_TAG;
typedef TAG ** PP_TAG;
typedef STATUS * P_STATUS;
typedef STATUS ** PP_STATUS;

#define MakeTag(wkn,tagNum)	(((TAG)(tagNum)&0xFF)<<23|WKNValue(wkn))
#define MakeTagWithFlags(wkn,i,f) (MakeTag(wkn,i)|((U32)(f)&3)<<21)

#define TagNum(tag)		((U32)(tag)<<1>>24)
#define Tag(tag)		TagNum(tag)
#define TagAndFlags(tag) ((U32)(tag)<<1>>22)
#define TagFlags(tag)	(TagAndFlags(tag)&3)
#define TagAdmin(tag)	WKNAdmin(tag)

#define MakeStatus(wkn,sts)	((STATUS)(0x80000000|MakeTag(wkn,sts)))
#define MakeWarning(wkn,sts) ((STATUS)MakeTag(wkn,sts))

#define Sts(sts)		Tag(sts)

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							clsmgr.h stuff
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#define MakeMsg(wkn,msg)		MakeTag(wkn,msg)
#define MsgNum(msg)				TagNum(msg)
#define ClsNum(msg)				WKNValue(msg)

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							debugger.h stuff
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#define clsDebugger				MakeWKN ( 358, 1, wknGlobal )

#define	 stsDebuggerNotDone			MakeWarning(clsDebugger,1)
#define	 stsDebuggerBadCommand		MakeStatus(clsDebugger,2)
#define	 stsDebuggerAsynchronous	MakeStatus(clsDebugger,3)

#define msgDebuggerInterpret		MakeMsg(clsDebugger, 2)
#define msgDebuggerNop				MakeMsg(clsDebugger, 3)
typedef struct DEBUGGER_INTERPRET {
	P_CHAR pCommands;				// a string of DB commands (see above)
	DEBUGGER_LOG_FLAGS logFlags;	// output to accumulate
	P_CHAR pLog;					// (out) accumulated output
} DEBUGGER_INTERPRET;
typedef DEBUGGER_INTERPRET * P_DEBUGGER_INTERPRET;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							key.h stuff
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// shift flags that DB cares about
typedef enum _SHIFT_STATE {
	keyShift = flag3,
	keyCtrl = flag4,
	keyAlt = flag5,
} _SHIFT_STATE;

// useful key codes
typedef enum _KEY_CODE {
	uKeyF1 = 0xf001,
	uKeyF2 = 0xf002,
	uKeyF3 = 0xf003,
	uKeyF4 = 0xf004,
	uKeyF5 = 0xf005,
	uKeyF6 = 0xf006,
	uKeyF7 = 0xf007,
	uKeyF8 = 0xf008,
	uKeyF9 = 0xf009,
	uKeyF10 = 0xf00a,
	uKeyF11 = 0xf00b,
	uKeyF12 = 0xf00c,
	uKeyInsert = 0xf020,
	uKeyDelete = 0xf021,
	uKeyHome = 0xf022,
	uKeyEnd = 0xf023,
	uKeyPageUp = 0xf024,
	uKeyPageDown = 0xf025,
	uKeyUp = 0xf026,
	uKeyDown = 0xf027,
	uKeyLeft = 0xf028,
	uKeyRight = 0xf029,
	uKeyCenter = 0xf02a,
	uKeyPrintScreen = 0xf02b,
	uKeyPause = 0xf02c,
	uKeySysRq = 0xf02d,
	uKeyBreak = 0xf02e,
	uKeyBackTab = 0xf02f,
} _KEY_CODE;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							DB stuff
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// portability
#if typeT == typeI386
	#define _pc eip
	#define _fp ebp
#elif typeT == typeI286
	#define _pc ip
	#define _fp bp
#else
	??? UNKNOWN CPU
#endif

// for backwards compatibility
#define _pAllTSN _allTS
#define _pAllProgTSN _allProgTS
#define _pNewProgTSN _newProgTS
#define _pStarTSN _starTS
#define ssCtx _ssCtx
#define ssLocals _ssLocals
#define ssParams _ssParams

#define printf _Printf
#define putchar _PutChr
#define sprintf _SPrintf

int strlen(
    CHAR __db *pC)
{
    int n;

    n = 0;
    while(*pC++)
        ++n;
    return n;
}

BOOLEAN _showRuntime = false;
BOOLEAN _showRealtime = false;

U16 _schedFudge = 0;

void __target _ShowRT(
    _TASK_SET ts,
    _RUNTIME __db * pRT,
	U32 __db * pNTicks)
{
    _RUNTIME rt1;
    U32 dt;
    U32 dtf;
    U16 dSched = rt1.nSched - pRT->nSched;
	U32 dnt;

    rt1 = _TSRuntime(ts);
    dt = rt1.lo - pRT->lo;
    dtf = dt;
    if(dSched && dt <= _schedFudge * dSched) {
        dtf = 1;
        _schedFudge = (U16)(dt / dSched);
    } else
        dtf -= _schedFudge * dSched;
	dnt = _nTicks - *pNTicks;

    if(_showRuntime)
        _ShowMicroticks(dtf);
	if(_showRealtime) {
		if(_showRuntime)
			_Printf(" in ");
		_ShowSysticks(dnt);
	}
	if(_showRuntime || _showRealtime)
		_Printf("\n");

    *pRT = rt1;
	*pNTicks = _nTicks;
}

void __target _ShowMchStep(void) 
{
    U16 svCodeLength = _curCodeLength;
    CHAR svCodeMode = _curCodeMode;

	#if typeT == typeI286
    	!u @cs:@ip l 1;
	#elif typeT == typeI386
    	!u @eip l 1;
	#else
		??? UNKNOWN CPU
	#endif
    ![.]ctx;    /* restore default "u" address */

    _curCodeLength = svCodeLength;
    _curCodeMode = svCodeMode;
}

void __target _ShowSrcStep(void) 
{
    U16 svViewLength = _curViewLength;
    CHAR svViewMode = _curViewMode;

    ![.]ctx;
    !v l 1;
    ![.]ctx;    /* restore default "v" source position */

    _curViewLength = svViewLength;
    _curViewMode = svViewMode;
}

void __target _ShowBestStep(void)
{
    if(_AtSrcLine(
#if typeT == typeI286
		@cs:@ip
#elif typeT == typeI386
		@eip
#else
		??? UNKNOWN CPU
#endif
	))
        _ShowSrcStep();
    else
        _ShowMchStep();
}

void __target _HostIO(void)
{
	_TSetHostIO();
	_HSetHostIO();
}

void __target _TargetIO(void)
{
	_TSetTargetIO();
	_HSetTargetIO();
} 

void __target _DefOnBreak(
    OS_TASK_ID taskId,
    _HANDLER_NUMBER handlerN)
{
	if(taskId) {
        ![taskId]ti;
        ![taskId]ctx;
        _ShowBestStep();
	}
} 
	
void (__target __db * _pOnBreak)(
    OS_TASK_ID taskId,
    _HANDLER_NUMBER handlerN) = _DefOnBreak;

void (__target __db * _pOnHit)(
    OS_TASK_ID taskId,
    _HANDLER_NUMBER handlerN);

void __target _OnHit(
    OS_TASK_ID taskId,
    _HANDLER_NUMBER handlerN)
{
    _pOnHit(taskId, handlerN);
}

void (__target __db * _EndWait)(void);

BOOLEAN _showInterpret = false;

void __target _DoWait(
    _TASK_SET curTS,
    _TASK_SET ts,
	BOOLEAN resume)
{
    void GotoDone(void)
    {    
        goto done;
    }
    _EndWait = GotoDone;
    void DoBreak(
        OS_TASK_ID taskId,
        _HANDLER_NUMBER handlerN)
    {   
		_pOnBreak(taskId, handlerN);
        goto done;
    }
    _pOnHit = DoBreak;
    !on intReq {
		if(_topCtxTaskId) {
			_ReqTasksSafe(curTS);	// try anyway
        	![curTS]tl;
        	![curTS]ctx;
        	_ShowBestStep();
		}
		_Err("interrupted");
		// actually, we never fall through to...
        goto done;
    }
    ![_allTS]bp _DoDebuggerMsg {
		if(_showInterpret)
			_Printf("dbinit._DoDebuggerMsg1, msg=%x, taskId = %x\n", 
				msg, 
				_taskId);
        ![_taskId]ctx;
		switch(MsgNum(msg)) {
		case MsgNum(msgDebuggerInterpret):
			{
			#define pDI ((P_DEBUGGER_INTERPRET)pArgs)
			OS_TASK_ID caller = _taskId;

			![(caller)]fz; 
			!on exit { 
				![(caller)]ctx; 
				![(caller)]th; 
				if(_showInterpret) {
					_Printf("exiting dbinit handler\n");
					!["dbtest"*]tl;
				}
			}

			if(_showInterpret) {
				_Printf("dbinit._DoDebuggerMsg.Interpret pArgs=%p\n", 
					pDI);
				_Printf("  pDI->pCommands=%p =>\n", 
					pDI->pCommands);
				_Printf("%S\n---\n", pDI->pCommands);
				!["dbtest"*]tl;
			}

			*pStatus = 
				_Interpret(pDI->pCommands, pDI->logFlags, &pDI->pLog)
				? stsOK
				: stsDebuggerBadCommand;

			if(_showInterpret) { 
				_Printf(
		"dbinit._DoDebuggerMsg: _Interpret returned pLog=%p, status=%lx\n", 
					pDI->pLog,
					*pStatus);
				if(0&&pDI->pLog) {
					!ai pDI->pLog;
					_Printf("dbinit._DoDebuggerMsg: strlen(pLog)=%u\n", 
						strlen(pDI->pLog));
					_Printf("dbinit._DoDebuggerMsg: pLog:\n%s\n---\n", 
						pDI->pLog);
				}
			}

			#undef pDI
			}
			break;		// and resume execution
		default:
        	![_taskId]tl;
        	_ShowBestStep();
        	goto done;
		}
    }
    ![_allTS]on fault {
        ![_taskId]fz;
        ![_taskId]tl;
        ![_taskId]ctx;
        _ShowBestStep();
        goto done;
    }
    ![_allTS-"#Copx"]on debReq {
        ![_taskId]tl;
        ![_taskId]ctx;
        _ShowBestStep();
        goto done;
    }
    ![(ts)]on terminate {
		![_taskId]tl;
		if(_taskId == _topCtxTaskId)
			![]ctx;
		goto done;
	}
	if(resume)
		_RelTasksSafe([ts *]);
	_TargetIO();
    !wait;
done:;
}

void __target _Comma(void)
{
	_DoWait([ts ], [ts ], /* resume */ false);
}

void __target _GoDoWait(
    _TASK_SET curTS,
    _TASK_SET ts)
{
    _DoWait(curTS, ts, /* resume */ true);
}

typedef struct _TRACE_DATA {
    unsigned count;
    _RUNTIME start;
	U32 startTicks;
    _TASK_SET ts;
} _TRACE_DATA;

_HANDLER_NUMBER _handlerN;
BOOLEAN _handlerDone;

void __target _Trace(
    _TASK_SET ts, 
    unsigned n) 
{
    _TRACE_DATA __db *pTD;
	_HANDLER_NUMBER hn;

    pTD = (_TRACE_DATA __db *)_Alc(sizeof(_TRACE_DATA));
    pTD->count = n;
    pTD->start = _TSRuntime(ts);
	pTD->startTicks = _nTicks;
    pTD->ts = ts;

    ![(ts)]global on(&_handlerN, pTD) step {
        _TRACE_DATA __db *pTD = (_TRACE_DATA __db*)_pData;

        _ShowMchStep();
        _ShowRT(pTD->ts, &pTD->start, &pTD->startTicks);
        if(--pTD->count == 0) {
            _Free(pTD);
            !bc _handlerN;
			_handlerDone = true;
            _EndWait();
        }
    }
	_handlerDone = false;
	hn = _handlerN;
	!on exit {
		if(!_handlerDone)
			_Printf("\"T\" starting point remembered as bp %u\n", hn);
	}
    _GoDoWait([ts .], ts);
}

BOOLEAN _showSrcTraceSteps = false;

void __target _SrcTrace(
    _TASK_SET ts, 
    unsigned n) 
{
    _TRACE_DATA __db *pTD;
	_HANDLER_NUMBER hn;

    if(!_HaveSrc(
#if typeT == typeI286
		@cs:@ip
#elif typeT == typeI386
		@eip
#else
		??? UNKNOWN CPU
#endif
	)) {
		_Trace(ts, n);
		return;
	}

    pTD = (_TRACE_DATA __db*)_Alc(sizeof(_TRACE_DATA));
    pTD->count = n;
    pTD->start = _TSRuntime(ts);
    pTD->startTicks = _nTicks;
    pTD->ts = ts;

    ![(ts)]global on(&_handlerN, pTD) step {
        _TRACE_DATA __db *pTD = (_TRACE_DATA __db*)_pData;

        if(_AtSrcLine(
			#if typeT == typeI286
				cs:ip
			#elif typeT == typeI386
				eip
			#else
				??? UNKNOWN CPU
			#endif
		)) {
            _ShowSrcStep();
            _ShowRT(pTD->ts, &pTD->start, &pTD->startTicks);
            if(--pTD->count == 0) {
                _Free(pTD);
                !bc _handlerN;
				_handlerDone = true;
                _EndWait();
            }
        } else if(_showSrcTraceSteps) {
			_ShowMchStep();
		}
    }
	_handlerDone = false;
	hn = _handlerN;
	!on exit {
		if(!_handlerDone)
			_Printf("\"t\" starting point remembered as bp %u\n", hn);
	}
    _GoDoWait([ts .], ts);
}

void __target _PTrace(
    _TASK_SET ts, 
    unsigned n) 
{
    _TRACE_DATA __db *pTD;
	_HANDLER_NUMBER hn;

    pTD = (_TRACE_DATA __db*)_Alc(sizeof(_TRACE_DATA));
    pTD->count = n;
    pTD->start = _TSRuntime(ts);
    pTD->startTicks = _nTicks;
    pTD->ts = ts;

    ![(ts)]global on(&_handlerN, pTD) pstep {
        _TRACE_DATA __db *pTD = (_TRACE_DATA __db*)_pData;

        _ShowMchStep();
        _ShowRT(pTD->ts, &pTD->start, &pTD->startTicks);
        if(--pTD->count == 0) {
            _Free(pTD);
            !bc _handlerN;
			_handlerDone = true;
            _EndWait();
        }
    }
	_handlerDone = false;
	hn = _handlerN;
	!on exit {
		if(!_handlerDone)
			_Printf("\"P\" starting point remembered as bp %u\n", hn);
	}
    _GoDoWait([ts .], ts);
}

void __target _SrcPTrace(
    _TASK_SET ts, 
    unsigned n) 
{
    _TRACE_DATA __db*pTD;
	_HANDLER_NUMBER hn;

    if(!_HaveSrc(
#if typeT == typeI286
		@cs:@ip
#elif typeT == typeI386
		@eip
#else
		??? UNKNOWN CPU
#endif
	)) {
		_PTrace(ts, n);
		return;
	}

    pTD = (_TRACE_DATA __db*)_Alc(sizeof(_TRACE_DATA));
    pTD->count = n;
    pTD->start = _TSRuntime(ts);
    pTD->startTicks = _nTicks;
    pTD->ts = ts;

    ![(ts)]global on(&_handlerN, pTD) pstep {
        _TRACE_DATA __db *pTD = (_TRACE_DATA __db*)_pData;

        if(_AtSrcLine(
			#if typeT == typeI286
				cs:ip
			#elif typeT == typeI386
				eip
			#else
				??? UNKNOWN CPU
			#endif
		)) {
            _ShowSrcStep();
            _ShowRT(pTD->ts, &pTD->start, &pTD->startTicks);
            if(--pTD->count == 0) {
                _Free(pTD);
                !bc _handlerN;
				_handlerDone = true;
                _EndWait();
            }
        } else if(_showSrcTraceSteps) {
			_ShowMchStep();
		}
    }
	_handlerDone = false;
	hn = _handlerN;
	!on exit {
		if(!_handlerDone)
			_Printf("\"p\" starting point remembered as bp %u\n", hn);
	}
    _GoDoWait([ts .], ts);
}

void __target _Go(
    _TASK_SET ts)
{
    _RUNTIME start;
	U32 startTicks;

    start = _TSRuntime(ts);
	startTicks = _nTicks;
    _GoDoWait([ts .], ts);
    _ShowRT(ts, &start, &startTicks);
}

void __target _GoBreak(
    _TASK_SET ts, 
    void (__db * pCode)()) 
{
    _TRACE_DATA __db *pTD;
	_HANDLER_NUMBER hn;

    pTD = (_TRACE_DATA __db *)_Alc(sizeof(_TRACE_DATA));
    pTD->start = _TSRuntime(ts);
    pTD->startTicks = _nTicks;
    pTD->ts = ts;
    ![*+.]global on(&_handlerN, pTD) bp pCode {
        _TRACE_DATA __db *pTD = (_TRACE_DATA __db *)_pData;
		![.]ctx;
        _ShowBestStep();
        _ShowRT(pTD->ts, &pTD->start, &pTD->startTicks);
        _Free(pTD);
        !bc _handlerN;
		_handlerDone = true;
        _EndWait();
    }
	_handlerDone = false;
	hn = _handlerN;
	!on exit {
		if(!_handlerDone)
			_Printf("\"g <addr>\" target remembered as bp %u\n", hn);
	}
    _GoDoWait([ts .], ts);
}

typedef struct _INSTALL_DATA {
    OS_TASK_ID installerTaskId;
    _HANDLER_NUMBER installerTerminateEN;
    _HANDLER_NUMBER installBegunEN;
    CHAR __db * pProgPath;
    CHAR __db * pProgName;
} _INSTALL_DATA;

void __target _Install(
    CHAR __db *pProgName,
    CHAR __db *pCmndLine)
{
    _INSTALL_DATA __db *pID = (_INSTALL_DATA __db *)_Alc(sizeof(_INSTALL_DATA));

    pID->pProgPath = pProgName;
    pID->pProgName = 0;

    pID->installerTaskId = _DoStartInstall(pCmndLine);

    ![pID->installerTaskId]global on(&pID->installerTerminateEN) 
    terminate {
        _INSTALL_DATA __db *pID = (_INSTALL_DATA __db *)_pData;
        ![_taskId]tl;
        !bc pID->installBegunEN;
        !bc _handlerN;
        _EndWait();
    }

    ![*]global on(&pID->installBegunEN, pID) installBegun "*" {
        _INSTALL_DATA __db *pID = (_INSTALL_DATA __db *)_pData;

        _SetExe(_ppn, pID->pProgPath, /* obj list */ 0);
        !bc pID->installerTerminateEN;
        !bc _handlerN;
        ![_taskId]tl;
        ![_taskId]ctx;
        _EndWait();
    }

    ![pID->installerTaskId]global on installDone "*" {
        ![_taskId]tl;
        !bc _handlerN;
        _EndWait();
    }

    _DoWait([ts], [ts], /* resume */ true);
}

void __target _Start(
    _P_PROGRAM pProgram,
    CHAR __db *pCmndLine)
{
    OS_TASK_ID taskId;

    taskId = _DoStartApp(pProgram, pCmndLine);
    ![taskId]global on start "*" {
        !bc _handlerN;
        !break;
    }
    _DoWait([ts], [ts taskId], /* resume */ true);
}

void __target memcpy(
    CHAR __db *pD,
    CHAR __db *pS,
    int l)
{
    while(l--)
        *pD++ = *pS++;
} 

#if 0

void __target _SetPC(
	_T_ADDR pCode)
{
	#if typeT == typeI386
    	@eip = _pCode.off;
	#else
		??? UNKNOWN CPU
	#endif
}

void __target _SetFrame(
	_TASK_FRAME *pTF)
{
	#if typeT == typeI386
		@eip = pTF->pResume.off;
		@ebp = pTF->pCode.off;
	#else
		??? UNKNOWN CPU
	#endif
}

#endif

CHAR __target _showCall = 0;

typedef struct _PRECALL_STATE __db * _P_PRECALL_STATE;
typedef struct _PRECALL_STATE {
	BOOLEAN forcedNop;
	_T_REGS regs;
	U16 callN;
	void (__target __db * pSvOnHit)(
    	OS_TASK_ID taskId,
    	_HANDLER_NUMBER handlerN);
	_P_PRECALL_STATE pNext;
} _PRECALL_STATE;

_P_PRECALL_STATE _pPSs = 0;

_P_PRECALL_STATE _FindPrecallState(
	U16 callN)
{
	_P_PRECALL_STATE pPS;

	for(pPS = _pPSs; pPS && pPS->callN != callN; pPS = pPS->pNext)
		;
	return pPS;
} // _FindPrecallState

U16 _precallN = 0;

U16 __target _SavePrecallState(void)
{
	_P_PRECALL_STATE pPS;

	if(_showCall) {
		_Printf("_SavePrecallState()\n");
		!r;
		!dd @esp l 16;
	}
	if((pPS = _FindPrecallState(0)) == 0) {
		pPS = (_P_PRECALL_STATE)_Alc(sizeof(_PRECALL_STATE));
		pPS->pNext = _pPSs;
		_pPSs = pPS;
	}
	pPS->forcedNop = false;
	if(_AwaitingMsg(_topCtxTaskId)) {
		if(_showCall) 
			_Printf("in msg wait: post a DebuggerNop\n");
		![ts _topCtxTaskId] on oc msgDebuggerNop { 
			if(_showCall) 
				_Printf("msgDebuggerNop succeeded\n");
			pPS->forcedNop = true;
			goto ok; 
		}
		_RelTasksSafe([ts _topCtxTaskId]);
		_PostDebuggerNop(_topCtxTaskId);
    	_GoDoWait([ts .], [ts .]);
		if(_showCall) 
			_Printf("msgDebuggerNop failed\n");
	ok:;
	}
	pPS->callN = ++_precallN;
	pPS->regs = regs;
	pPS->pSvOnHit = _pOnHit;
	return pPS->callN;
} // _SavePrecallState

void __target _RestorePrecallState(
	U16 callN)
{
	_P_PRECALL_STATE pPS;

	if(_showCall) {
		_Printf("_RestorePrecallState(%u)\n", callN);
		!r;
	}
	if(pPS = _FindPrecallState(callN)) {
		regs = pPS->regs;
		pPS->callN = 0;	// mark invalid
		_pOnHit = pPS->pSvOnHit;
		if(_showCall) {
			!r;
			!dd @esp l 16;
		}
	} else
		_Err("can't find precall state for call %u", callN);
	_FixCurCtx();
} // RestorePrecallState

#if NEWFC
	void __target _TryTargetCall(
		U16 callN,
		void __db * pArgInfo)
	{
		if(_showCall) {
			_Printf("_TryTargetCall(%u)\n", callN);
			!dd pArgInfo l 80;
			!r;
		}
	#if typeT == typeI386
		if((@cs & 3) != 3)
			_Err("can't force a call: the current task is in privileged code");
		@ebx = pArgInfo;
		@eip = _DoForceCall; 

    	void DoFail(
        	OS_TASK_ID taskId,
        	_HANDLER_NUMBER handlerN)
    	{    
			if(taskId)
        		![taskId]tl;
			_Err(
				"target call failed: to restore precall state, type !_RestorePrecallState(%u)",
				callN);
    	}
		!bp _DoBP {
			if(_showCall) {
				_Printf("_TryTargetCall() ok\n");
				!r;
			}
			goto done;
		}
    	_pOnHit = DoFail;
		_RelTasksSafe([ts *]);
	//  !wait;
    	_GoDoWait([ts .], [ts .]);
	done:;
	#else
		??? UNKNOWN CPU
	#endif
	} // _TryTargetCall
#else
	void __target _TryTargetCall(
		U16 callN,
		void (__db * pCode)())
	{
		if(_showCall) {
			_Printf("_TryTargetCall(%u, %p)\n", callN, pCode);
			!r;
		}
	#if typeT == typeI386
		if((@cs & 3) != 3)
			_Err("can't force a call: the current task is in privileged code");
		@ebp = 0;
		@esp -= 4;
		*(U32 __near *)@esp = _DoBP;	// will get a BP exception
    	@eip = (U32)pCode;
		if(_showCall) {
			!r;
			!dd @esp l 16;
		}

    	void DoFail(
        	OS_TASK_ID taskId,
        	_HANDLER_NUMBER handlerN)
    	{    
			if(taskId)
        		![taskId]tl;
			_Err(
				"target call failed: to restore precall state, type !_RestorePrecallState(%u)",
				callN);
    	}
		!bp _DoBP {
			if(_showCall) {
				_Printf("_TryTargetCall() ok\n");
				!r;
			}
			goto done;
		}
    	_pOnHit = DoFail;
		_RelTasksSafe([ts *]);
	//  !wait;
    	_GoDoWait([ts .], [ts .]);
	done:;
	#else
		??? UNKNOWN CPU
	#endif
	} // _TryTargetCall
#endif

void __target _Terminate(
	OS_TASK_ID taskId)
{
	if(taskId == _topCtxTaskId)
		![0] ctx;
	_DoTerminate(taskId);
} 

// print routines

void _DoShowMP(_MSG_PAT __db *pMP) { _ShowMP(*pMP); }
!setprint _MSG_PAT = _DoShowMP;

void _DoShowTS(_TASK_SET __db *pTS) { _ShowTS(*pTS); }
!setprint _TASK_SET = _DoShowTS;

void _DoShowRS(_ROUTINE_SET __db *pRS) { _ShowRS(*pRS); }
!setprint _ROUTINE_SET = _DoShowRS;

void _ShowHexLong(_HEX_LONG __db *pHL) { _Printf("%#x", *pHL); }
!setprint _HEX_LONG = _ShowHexLong;

void _ShowHexShort(_HEX_SHORT __db *pHS) { _Printf("%#x", *pHS); }
!setprint _HEX_SHORT = _ShowHexShort;

void _ShowHexByte(_HEX_BYTE __db *pHB) { _Printf("%#x", *pHB); }
!setprint _HEX_BYTE = _ShowHexByte;

void _Show1Flag(unsigned nonzero, CHAR c) {
    _Printf("%c", nonzero ? c : '-');
}
void _ShowFlags(_FLAGS __db *pF) {
    _FLAGS f = *pF;
    _Show1Flag(f & 0x4000, 'N');
    _Printf("%d", (f & 0x3000) >> 12);
    _Show1Flag(f & 0x0800, 'O');
    _Show1Flag(f & 0x0400, 'D');
    _Show1Flag(f & 0x0200, 'I');
    _Show1Flag(f & 0x0100, 'T');
    _Show1Flag(f & 0x0080, 'S');
    _Show1Flag(f & 0x0040, 'Z');
    _Show1Flag(f & 0x0010, 'A');
    _Show1Flag(f & 0x0004, 'P');
    _Show1Flag(f & 0x0001, 'C');
}
!setprint _FLAGS = _ShowFlags;

void _ShowTAddr(_T_ADDR __db *pTA) { 
	#if typeT == typeI286
		_Printf("%#x:%#xp", pTA->sel, pTA->off); 
	#elif typeT == typeI386
		_Printf("%#x", pTA->off);
	#else
		??? UNKNOWN CPU
	#endif
}
!setprint _T_ADDR = _ShowTAddr;

typedef STATUS STS;
typedef OBJECT OBJ;
typedef MESSAGE MSG;

void _PrintAndFree(CHAR __db *pS) {
    _Printf("%s", pS);
    _Free(pS);
}
void _ShowStatus(STATUS __db *pSts) { 
    _PrintAndFree(_StsToString(*pSts));
}
void _ShowObject(OBJECT __db *pObj) { 
    _PrintAndFree(_ObjToString(*pObj));
}
void _ShowMessage(MESSAGE __db *pMsg) { 
    _PrintAndFree(_MsgToString(*pMsg));
}

!setprint STATUS = _ShowStatus;
!setprint OBJECT = _ShowObject;
!setprint MESSAGE = _ShowMessage;

typedef enum _BITS {
    b0  = (1 << 0),
    b1  = (1 << 1),
    b2  = (1 << 2),
    b3  = (1 << 3),
    b4  = (1 << 4),
    b5  = (1 << 5),
    b6  = (1 << 6),
    b7  = (1 << 7),
    b8  = (1 << 8),
    b9  = (1 << 9),
    b10 = (1 << 10),
    b11 = (1 << 11),
    b12 = (1 << 12),
    b13 = (1 << 13),
    b14 = (1 << 14),
    b15 = (1 << 15)
} _BITS;

void __target _MakeTasksSafe(
    _TASK_SET ts)
{
	if(!_ReqTasksSafe(ts)) {
		do {
			_Delay(500);
		} while(!_CkTasksSafe(ts));
	}
}

STATUS __target _DoObjectCall(
	MESSAGE msg,
	OBJECT obj,
	P_ARGS pArgs)
{
	return ObjectCall(msg, obj, pArgs);
}

void __target _DoTargetDelay(
	U32 ms)
{
	U32 doneTicks = _nTicks + ms / _msPerSystick;
	_Printf("[%u..%u", _nTicks, doneTicks);
	do {
		![_allTS]on tick {
			goto ticked;
		}
		_DoWait([ts .], [ts *], /* resume */ false);
	ticked:;
	} while(_nTicks < doneTicks);
	_Printf("]");
} 

!ver;
