/****************************************************************************
 File: tttdata.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.4  $
 $Author:   kcatlin  $
 $Date:   30 Jan 1992 19:14:50  $

 This file contains the API definition for clsTttData.
 clsTttData inherits from clsObject.
****************************************************************************/
#ifndef TTTDATA_INCLUDED
#define TTTDATA_INCLUDED

#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
#endif


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Defines													   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

//
// AKN
//
#define	numberOfRows		5
#define	numberOfColumns		5

#define 	tagTttDataUndoDelete 		MakeTag(clsTttData, 0)
#define 	tagTttDataUndoMoveCopy 		MakeTag(clsTttData, 1)
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Common Typedefs										   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef OBJECT 
TTT_DATA, * P_TTT_DATA;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Exported Functions									   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 ClsTttDataInit	returns STATUS
	Initializes / installs clsTttData.

	This routine is only called during installation of the class.
*/
STATUS PASCAL
ClsTttDataInit (void);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Messages for clsTttData							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNew		takes P_TTT_DATA_NEW, returns STATUS
	category: class message
	Creates an instance of clsTttData.
*/

typedef char 
TTT_SQUARE_VALUE;

#define tttBlank ((TTT_SQUARE_VALUE)' ')
#define tttX	 ((TTT_SQUARE_VALUE)'X')
#define tttO	 ((TTT_SQUARE_VALUE)'O')

typedef TTT_SQUARE_VALUE
TTT_SQUARES [numberOfRows] [numberOfColumns];

typedef struct TTT_DATA_METRICS {

	TTT_SQUARES	squares;
	U32			undoTag;

} TTT_DATA_METRICS, * P_TTT_DATA_METRICS;


typedef struct TTT_DATA_NEW_ONLY {

	TTT_DATA_METRICS	metrics;

} TTT_DATA_NEW_ONLY, * P_TTT_DATA_NEW_ONLY;


#define	tttDataNewFields		\
	objectNewFields			\
	TTT_DATA_NEW_ONLY  tttData;


typedef struct TTT_DATA_NEW {

	tttDataNewFields

} TTT_DATA_NEW, * P_TTT_DATA_NEW;


/****************************************************************************
 msgNewDefaults		takes P_TTT_DATA_NEW, returns STATUS
	category: class message
	Initializes the TTT_DATA_NEW structure to default values.

*/

/****************************************************************************
 msgTttDataGetMetrics	takes P_TTT_DATA_METRICS, returns STATUS
	Gets TTT_DATA metrics.
*/
#define msgTttDataGetMetrics 	 			MakeMsg(clsTttData, 1)


/****************************************************************************
 msgTttDataSetMetrics	takes P_TTT_DATA_METRICS, returns STATUS
	Sets the TTT_DATA metrics.
*/
#define msgTttDataSetMetrics 	 			MakeMsg(clsTttData, 2)


/****************************************************************************
 msgTttDataSetSquare	takes P_TTT_DATA_SET_SQUARE, returns STATUS
	Sets the value of a single square.
*/
#define msgTttDataSetSquare 	 			MakeMsg(clsTttData, 3)

typedef struct {

	U16					row;
	U16					col;
	TTT_SQUARE_VALUE	value;

} TTT_DATA_SET_SQUARE, * P_TTT_DATA_SET_SQUARE;


/****************************************************************************
 msgTttDataRead	takes P_TTT_DATA_READ, returns STATUS
	Causes data object to try to read stationery from fileHandle.
	
	Returns stsOK if no errors occur, otherwise returns the error
	status.  Returns stsOK even if values cannot be read from the
	file.  The "successful" field indicates whether a value was
	successfully read.  If successful, the data object's state
	is changed and notifications are set.
*/
#define msgTttDataRead   	 				MakeMsg(clsTttData, 4)

typedef struct TTT_DATA_READ {

	OBJECT	fileHandle;
	BOOLEAN	successful;

} TTT_DATA_READ, * P_TTT_DATA_READ;


/****************************************************************************
 msgTttDataChanged	takes P_TTT_DATA_CHANGED or nothing, returns nothing
	category: observer notification
	Sent to observers when the value changes.

	If pArgs is pNull, receiver should assume that everything has changed.
*/
#define msgTttDataChanged   	 			MakeMsg(clsTttData, 5)

typedef struct {

	U16	row;
	U16	col;

} TTT_DATA_CHANGED, * P_TTT_DATA_CHANGED;


#endif	// TTTDATA_INCLUDED
