/****************************************************************************
 File: tkdemo.c

 Copyright 1992 GO Corporation. All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.9  $
   $Author:   kcatlin  $
     $Date:   05 Feb 1992 11:39:50  $

 This file contains the main code of the tkdemo application.
****************************************************************************/

#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
#endif 

#include <methods.h>

#ifndef _STDIO_H_INCLUDED
#include <stdio.h>
#endif 

#ifndef APPMGR_INCLUDED
#include <appmgr.h>
#endif 

#ifndef APPTAG_INCLUDED
#include <apptag.h>
#endif 

#ifndef TKDEMO_INCLUDED
#include <tkdemo.h>
#endif 

#ifndef RESFILE_INCLUDED
#include <resfile.h>
#endif 

#ifndef _STRING_H_INCLUDED
#include <string.h>
#endif 

#ifndef FRAME_INCLUDED
#include <frame.h>
#endif 

#ifndef PREFS_INCLUDED
#include <prefs.h>
#endif 

#ifndef SEL_INCLUDED
#include <sel.h>
#endif 

#ifndef SWIN_INCLUDED
#include <swin.h>
#endif 

#ifndef TABBAR_INCLUDED
#include <tabbar.h>
#endif 

#ifndef OPTION_INCLUDED
#include <option.h>
#endif 

#ifndef TBUTTON_INCLUDED
#include <tbutton.h>
#endif 

#ifndef CHOICE_INCLUDED
#include <choice.h>
#endif 

#ifndef MENU_INCLUDED
#include <menu.h>
#endif 

#ifndef MBUTTON_INCLUDED
#include <mbutton.h>
#endif 

#ifndef DEBUG_INCLUDED
#include <debug.h>
#endif 



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *									Types								   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef struct FILED_DATA {

	TKDEMO_METRICS metrics;

} FILED_DATA, *P_FILED_DATA;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *									Constants							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#define tagDynamicClient		MakeTag(clsTkDemo, 1)

static const TK_TABLE_ENTRY	myMenuEntries[] = {
	{"Dynamic None"},
	{"Dynamic Client", 0, 0, tagDynamicClient, tkControlDynamicClient},
	{"Dynamic Sel Local", 0, 0, 0, tkControlSelLocal},
	{pNull}
};


STATUS GLOBAL AddLabel (
	WIN parent, 
	P_STRING pString)
{
	STATUS				s;
	LABEL_NEW			ln;

	ObjCallRet(msgNewDefaults, clsLabel, &ln, s);
	ln.label.style.wordWrap = true;
	ln.label.style.numCols = lsNumAbsolute;
	ln.label.cols = 10;
	ln.label.font.attr.weight = sysDcWeightBold;
	ln.label.pString = pString;
	ObjCallRet(msgNew, clsLabel, &ln, s);

	// insert into the parent
	ln.win.parent = parent;
	ObjCallRet(msgWinInsert, ln.object.uid, &ln.win, s);

	return stsOK;

} /* AddLabel */


STATUS GLOBAL AddTab (
	WIN			tabBar,
	P_STRING	pString,
	WIN			cardWin)
{
	STATUS		  	s;
	WIN_METRICS		wm;
	TAB_BUTTON_NEW	tbn;

	ObjCallRet(msgWinGetFlags, cardWin, &wm, s);
	wm.flags.style |= wsSendFile;
	ObjCallRet(msgWinSetFlags, cardWin, &wm, s);

	ObjCallWarn(msgNewDefaults, clsTabButton, &tbn);
	ObjCallRet(msgTkTableChildDefaults, tabBar, &tbn, s);
	tbn.win.flags.style |= wsSendFile;
	tbn.label.pString = pString;
	tbn.button.style.pArgs = bsPargsUID;
	tbn.button.msg = msgTkDemoShowCard;
	tbn.button.data = (U32) cardWin;
	tbn.tabButton.metrics.win = cardWin;
	ObjCallRet(msgNew, clsTabButton, &tbn, s);
	ObjCallRet(msgTkTableAddAsFirst, tabBar, (P_ARGS) tbn.object.uid, s);

	return stsOK;

} /* AddTab */


STATUS LOCAL SetTitleFromTab (
	WIN					tab,
	P_FRAME_METRICS		pFrameMetrics)
{
	STATUS				s;
	APP_MGR_METRICS		appMgrMetrics;
	U8					cardNameBuf[80];
	U8					title[80];
	CONTROL_STRING		cs;

	cs.len = 80;
	cs.pString = cardNameBuf;
	ObjCallRet(msgLabelGetString, tab, &cs, s);
	ObjCallRet(msgAppMgrGetMetrics, clsTkDemo, &appMgrMetrics, s);
	sprintf(title, "%s: %s", appMgrMetrics.defaultDocName, cardNameBuf);
	ObjCallRet(msgLabelSetString, pFrameMetrics->titleBar, title, s);

	return stsOK;

} /* SetTitleFromTab */


/****************************************************************************
	TkDemoInit
	
	Respond to msgInit.
****************************************************************************/
MsgHandlerArgType(TkDemoInit, P_APP_NEW)
{
	TKDEMO_INST	inst;

	Dbg(Debugf("tkdemo[%p]: msgInit", self);)
	memset(&inst, 0, sizeof(TKDEMO_INST));
	StsWarn(ObjectWrite(self, ctx, &inst));

	return stsOK;
	MsgHandlerParametersNoWarning;

}	/* TkDemoInit */


typedef STATUS FunctionPtr(P_ENUM_PROC)(
	WIN			win,
	P_UNKNOWN	pData);


STATUS GLOBAL NoteWin (
	WIN	 	win,
	P_WIN	pArgs)
{
	*pArgs = win;

	return stsOK;
} /* NoteWin */


STATUS GLOBAL MatchWin (
	WIN	 	tab,
	P_WIN	pArgs)
{
	TAB_BUTTON_METRICS	metrics;

	ObjCallWarn(msgTabButtonGetMetrics, tab, &metrics);
	if (metrics.win == pArgs[0]) {
		pArgs[1] = tab;
		return stsFailed;
	}

	return stsOK;

} /* MatchWin */


STATUS GLOBAL EnumChildren (
	WIN				parent,
	P_ENUM_PROC		proc,
	P_UNKNOWN		pData)
{
	STATUS		s;
	WIN_ENUM	wEnum;
	WIN			wins[10];
	U16			i;

	wEnum.max = wEnum.count = 10;
	wEnum.pWin = wins;
	wEnum.pFlags = pNull;
	wEnum.next = 0;
	wEnum.flags = wsEnumChildren;

	do {
		P_WIN	w;

		s = ObjectCall(msgWinEnum, parent, &wEnum);
		for (i = 0, w = wins; i < wEnum.count; i++, w++) {
			if (proc(*w, pData) < stsOK) {
				return stsOK;
			}
		}
	} while (s != stsEndOfData);

	return stsOK;

} /* EnumChildren */

/****************************************************************************
	TkDemoInitApp
	
	Respond to msgAppInit.  Perform one-time initializations.
****************************************************************************/
MsgHandlerArgType(TkDemoInitApp, DIR_HANDLE)
{
	STATUS				s;
	APP_METRICS			am;
	FRAME_METRICS		fm;
	SCROLL_WIN_NEW		swn;
	TAB_BAR_NEW			tbn;

	Dbg(Debugf("tkdemo[%p]: msgAppInit", self);)
	// Get the main window.
	ObjCallRet(msgAppGetMetrics, self, &am, s);
	ObjCallRet(msgFrameGetMetrics, am.mainWin, &fm, s);

	// Create a scrollwin
	ObjCallRet(msgNewDefaults, clsScrollWin, &swn, s);
	ObjCallRet(msgNew, clsScrollWin, &swn, s);
	fm.clientWin = swn.object.uid;

	// Create a tabbar
	ObjCallRet(msgNewDefaults, clsTabBar, &tbn, s);
	tbn.win.flags.style |= wsSendFile;
	tbn.tabBar.style.incrementalLayout = false;
	ObjCallRet(msgNew, clsTabBar, &tbn, s);
	fm.style.tabBar = true;
	fm.tabBar = tbn.object.uid;

	StsRet(TkDemoAddBordersCard(swn.object.uid, tbn.object.uid, self), s);
	StsRet(TkDemoAddLabelsCard(swn.object.uid, tbn.object.uid, self), s);
	StsRet(TkDemoAddButtonsCard(swn.object.uid, tbn.object.uid, self), s);
	StsRet(TkDemoAddTablesCard(swn.object.uid, tbn.object.uid, self), s);
	StsRet(TkDemoAddTkTablesCard(swn.object.uid, tbn.object.uid, self), s);
	StsRet(TkDemoAddOptionTablesCard(swn.object.uid, tbn.object.uid, self), s);
	StsRet(TkDemoAddCustomsCard(swn.object.uid, tbn.object.uid, self), s);
	StsRet(TkDemoAddOptionsCard(swn.object.uid, tbn.object.uid, self), s);
	StsRet(TkDemoAddNotesCard(swn.object.uid, tbn.object.uid, self), s);
	StsRet(TkDemoAddListBoxesCard(swn.object.uid, tbn.object.uid, self), s);
	StsRet(TkDemoAddFieldsCard(swn.object.uid, tbn.object.uid, self), s);
	StsRet(TkDemoAddIconsCard(swn.object.uid, tbn.object.uid, self), s);

	{
		WIN					tab;
		TAB_BUTTON_METRICS	tbm;

		StsRet(EnumChildren(fm.tabBar, NoteWin, &tab), s);
		ObjCallRet(msgTabButtonGetMetrics, tab, &tbm, s);
		ObjCallRet(msgScrollWinShowClientWin, swn.object.uid, (P_ARGS) tbm.win, s);
	}

	ObjCallRet(msgTkTableSetClient, fm.tabBar, (P_ARGS) self, s);
	ObjCallRet(msgFrameSetMetrics, am.mainWin, &fm, s);

	return stsOK;
	MsgHandlerParametersNoWarning;
}	/* TkDemoInitApp */


/****************************************************************************
	TkDemoOpen
	
	Respond to msgAppOpen.
****************************************************************************/
MsgHandlerArgType(TkDemoOpen, P_APP_OPEN)
{
	STATUS			s;
	FRAME_METRICS	fm;
	APP_METRICS		am;
	MENU_BUTTON_NEW	mbn;
	MENU_NEW		mn;
	WIN				match[2];

	Dbg(Debugf("tkdemo[%p]: msgAppOpen", self);)
	// Get the main window.
	ObjCallRet(msgAppGetMetrics, self, &am, s);
	ObjCallRet(msgFrameGetMetrics, am.mainWin, &fm, s);

	// Set the frame's title.
	ObjCallRet(msgScrollWinGetClientWin, fm.clientWin, &match[0], s);
	match[1] = objNull;
	StsRet(EnumChildren(fm.tabBar, MatchWin, match), s);
	StsRet(SetTitleFromTab(match[1], &fm), s);

	fm.style.menuBar = true;
	ObjCallRet(msgAppCreateMenuBar, self, &fm.menuBar, s);
	ObjCallRet(msgFrameSetMetrics, am.mainWin, &fm, s);

	// Create my menu.
	ObjCallWarn(msgNewDefaults, clsMenu, &mn);
	mn.tkTable.client = self;
	mn.tkTable.pEntries = myMenuEntries;
	mn.menu.style.type = msTypeMenu;
	ObjCallRet(msgNew, clsMenu, &mn, s);

	// Create my menu button.
	ObjCallWarn(msgNewDefaults, clsMenuButton, &mbn);
	mbn.control.client = self;
	mbn.label.pString = "Demo";
	mbn.menuButton.style.subMenuType = mbMenuPullDown;
	mbn.menuButton.style.enableMenu = true;
	mbn.menuButton.menu = mn.object.uid;
	ObjCallRet(msgNew, clsMenuButton, &mbn, s);

	ObjCallRet(msgTkTableAddAsLast, fm.menuBar, (P_ARGS) mbn.object.uid, s);

	// Pass message to ancestor.
	pArgs->childAppParentWin = fm.clientWin;
	
	return stsOK;
	MsgHandlerParametersNoWarning;
}	/* TkDemoOpen */


/****************************************************************************
	TkDemoClose
	
	Respond to msgAppClose.
****************************************************************************/
MsgHandler(TkDemoClose)
{
	STATUS			s;
	FRAME_METRICS	fm;
	APP_METRICS		am;

	Dbg(Debugf("tkdemo[%p]: msgAppClose", self);)
	// Get the main window.
	ObjCallRet(msgAppGetMetrics, self, &am, s);
	ObjCallRet(msgFrameGetMetrics, am.mainWin, &fm, s);

	fm.style.menuBar = false;
	ObjCallWarn(msgDestroy, fm.menuBar, pNull);
	fm.menuBar = objNull;
	ObjCallRet(msgFrameSetMetrics, am.mainWin, &fm, s);

	return stsOK;
	MsgHandlerParametersNoWarning;
}	/* TkDemoClose */


/****************************************************************************
	TkDemoGetMetrics
	
	Get TkDemo metrics.
****************************************************************************/
MsgHandlerArgType(TkDemoGetMetrics, P_TKDEMO_METRICS)
{
	Dbg(Debugf("tkdemo[%p]: msgTkDemoGetMetrics", self);)
	*pArgs = IDataPtr(pData, TKDEMO_INST)->metrics;

	return stsOK;
	MsgHandlerParametersNoWarning;
}	/* TkDemoGetMetrics */


/****************************************************************************
	TkDemoShowCard
	
	Show the passed card window.
****************************************************************************/
MsgHandlerArgType(TkDemoShowCard, WIN)
{
	STATUS		 		s;
	APP_METRICS	 		am;
	FRAME_METRICS		fm;
	TAB_BUTTON_METRICS	metrics;

	Dbg(Debugf("tkdemo[%p]: msgTkDemoShowCard", self);)

	ObjCallRet(msgAppGetMetrics, self, &am, s);
	ObjCallRet(msgFrameGetMetrics, am.mainWin, &fm, s);

	StsRet(SetTitleFromTab(pArgs, &fm), s);

	ObjCallRet(msgTabButtonGetMetrics, pArgs, &metrics, s);
	ObjCallRet(msgScrollWinShowClientWin, fm.clientWin, metrics.win, s);

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* TkDemoShowCard */


MsgHandlerArgType(TkDemoProvideEnable, P_CONTROL_PROVIDE_ENABLE)
{
	if (pArgs->tag == tagDynamicClient)
		pArgs->enable = !pArgs->enable;
	else
		return ObjectCallAncestorCtx(ctx);

	Dbg(Debugf("tkdemo[%p]: msgControlProvideEnable", self);)

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* TkDemoProvideEnable */


/****************************************************************************
	ClsTkDemoInit
	
	Install the application.
****************************************************************************/
STATUS ClsTkDemoInit (void)
{
	APP_MGR_NEW	new;
	STATUS		s;


	// Install the class.
	ObjCallRet(msgNewDefaults, clsAppMgr, &new, s);
	new.object.uid	 				= clsTkDemo;
	new.object.key 		  			= 0;
	new.cls.pMsg					= clsTkDemoTable;
	new.cls.ancestor				= clsApp;
	new.cls.size					= SizeOf(TKDEMO_INST);
	new.cls.newArgsSize			    = SizeOf(APP_NEW);
	new.appMgr.flags.allowEmbedding	= false;
	new.appMgr.defaultRect.size.w	= 300;
	new.appMgr.defaultRect.size.h	= 300;
	strcpy(new.appMgr.defaultDocName, "Tk Demo");
	strcpy(new.appMgr.company, "GO Corporation");
	// 213 (octal) is the "circle-c" copyright symbol
	new.appMgr.copyright =
		"\213 1991 GO Corporation, All Rights Reserved.";
	ObjCallRet(msgNew, clsAppMgr, &new, s);

	return stsOK;

}	/* ClsTkDemoInit */


/****************************************************************************
	main
	
	Main application entry point.
****************************************************************************/
void CDECL main(
	int 	argc, 
	char 	*argv[], 
	U16 	processCount)
{

	Dbg(Debugf("tkdemo.c/main: processCount=%d", processCount);)

	if (processCount == 0) {
		// Initialize self.
		StsWarn(ClsTkDemoInit());

		AppMonitorMain(clsTkDemo, Nil(OBJECT));
	} else
		// Start the application.
		AppMain();

	Unused(argc);  Unused(argv);
}	/* main */
