/****************************************************************************
 File: icons.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.3  $
   $Author:   kcatlin  $
     $Date:   05 Feb 1992 09:07:24  $

 This file contains the field demoing code of the tkdemo application.
****************************************************************************/

#ifndef OPTTABLE_INCLUDED
#include <opttable.h>
#endif

#ifndef SWIN_INCLUDED
#include <swin.h>
#endif

#ifndef ICON_INCLUDED
#include <icon.h>
#endif

#ifndef BITMAP_INCLUDED
#include <bitmap.h>
#endif

#ifndef TKDEMO_INCLUDED
#include <tkdemo.h>
#endif



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *									Constants							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

static const U8 logoImage[] = {
#include <gologo.inc>
};

static const BITMAP_METRICS logoBitmap = { {bmEncode8BPS}, 128, 90, logoImage };

static const U32 stripeImage[] = {
  0x00000000,
  0x55555555,  0x55555555,  0x55555555,  0x55555555,
  0x55555555,  0x55555555,  0x55555555,  0x55555555,
  0x55555555,  0x55555555,  0x55555555,  0x55555555,
  0x55555555,  0x55555555,  0x55555555,  0x55555555,
  0x55555555,  0x55555555,  0x55555555,  0x55555555,
  0x55555555,  0x55555555,  0x55555555,  0x55555555,
  0x55555555,  0x55555555,  0x55555555,  0x55555555,
  0x55555555,  0x55555555,
  0x00000000
};

static const BITMAP_METRICS stripeBitmap = { {bmEncode1BPS}, 32, 32, (P_U8)stripeImage };

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Local Utilities	  					   	   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
	AddIconExamples

	Creates and adds four icon examples to the window. There are two 
	important distinctions to note:

		* The bitmaps for tagTkGO, tagTkStripe, and tagTkFish are defined
	    	"by hand."
		* tagTkResIcon's bitmap was created in PenPoint's Bitmap editor.

	These bitmaps are hooked up to the icons in msgIconProvideBitmap,
	which is called when each icon needs its bitmap.
****************************************************************************/
STATUS LOCAL AddIconExamples (
	WIN	parent,
	APP	app)
{
	STATUS				s;
	ICON_NEW			in;

	// 
	// Create an icon.
	//
	ObjCallRet(msgNewDefaults, clsIcon, &in, s);

	//
	// Set the client to be the tkdemo app. When clsIcon needs the bitmap
	// for the icon, it sends msgIconProvideBitmap to the client. Refer
	// to this message handler below.
	//
	in.control.client = app;

	// Give the icon a window tag (which will be used in msgIconProvideBitmap)
	in.win.tag = tagTkGO;

	// Set the icon's label
	in.label.pString = "GO Icon";

	ObjCallRet(msgNew, clsIcon, &in, s);

	//
	// Insert the new icon into the parent window
	//
	in.win.parent = parent;
	ObjCallRet(msgWinInsert, in.object.uid, &in.win, s);


	//
	// Make three more icons following the same steps
	//
	ObjCallRet(msgNewDefaults, clsIcon, &in, s);
	in.control.client = app;
	in.win.tag = tagTkStripe;
	in.label.scale = lsScaleMedium;
	in.label.style.xAlignment = lsAlignRight;
	in.label.pString = "Right-Justified String";
	ObjCallRet(msgNew, clsIcon, &in, s);
	in.win.parent = parent;
	ObjCallRet(msgWinInsert, in.object.uid, &in.win, s);
	 
	ObjCallRet(msgNewDefaults, clsIcon, &in, s);
	in.control.client = app;
	in.win.tag = tagTkFish;
	in.label.style.xAlignment = lsAlignLeft;
	in.label.pString = "Fish";
	in.icon.style.sizeUnits = bsUnitsLayout;
	ObjCallRet(msgNew, clsIcon, &in, s);
	in.win.parent = parent;
	ObjCallRet(msgWinInsert, in.object.uid, &in.win, s);

	ObjCallRet(msgNewDefaults, clsIcon, &in, s);
	in.control.client = app;
	in.win.tag = tagTkResIcon;
	in.label.pString = "Bitmap from Bitmap Editor";
	ObjCallRet(msgNew, clsIcon, &in, s);
	in.win.parent = parent;
	ObjCallRet(msgWinInsert, in.object.uid, &in.win, s);

	return stsOK;
} /* AddIconExamples */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Global Utilities						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

STATUS GLOBAL TkDemoAddIconsCard (
	WIN		swin,
	WIN		tabBar,
	APP		app)
{
	STATUS				s;
	OPTION_TABLE_NEW	otn;

	// Create the card window.
	ObjCallRet(msgNewDefaults, clsOptionTable, &otn, s);
	ObjCallRet(msgNew, clsOptionTable, &otn, s);

	// Add it to the scrollwin.
	ObjCallRet(msgScrollWinAddClientWin, swin, (P_ARGS) otn.object.uid, s);

	// Create and add a corresponding tab.
	StsRet(AddTab(tabBar, "Icons", otn.object.uid), s);

	// fill the card with examples
	StsRet(AddIconExamples(otn.object.uid, app), s);

	return stsOK;

	Unused(app);

} /* TkDemoAddIconsCard */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Message Handlers						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


MsgHandlerArgType(TkDemoIconProvideBitmap, P_ICON_PROVIDE_BITMAP)
{
 	BITMAP_NEW 	bmn;
	U8  	   	f[50];
	U8		   	m[10];
	STATUS		s;
	

	switch (pArgs->tag) {
		case tagTkGO:
			ObjCallRet(msgNewDefaults, clsBitmap, &bmn, s);
			bmn.bitmap = logoBitmap;
			break;

		case tagTkStripe:
			ObjCallRet(msgNewDefaults, clsBitmap, &bmn, s);
			bmn.bitmap = stripeBitmap;
			break;

		case tagTkFish:
			ObjCallRet(msgNewDefaults, clsBitmap, &bmn, s);
			f[40]=255; f[41]=255; f[42]=0;   f[43]=0;   f[44]=0;   f[45]=0;   f[46]=255; f[47]=255; f[48]=255; f[49]=0;
			f[30]=255; f[31]=0;   f[32]=255; f[33]=255; f[34]=255; f[35]=255; f[36]=0;   f[37]=255; f[38]=0;   f[39]=0;
			f[20]=0;   f[21]=255; f[22]=100; f[23]=255; f[24]=255; f[25]=255; f[26]=255; f[27]=0;   f[28]=0;   f[29]=255;
			f[10]=255; f[11]=0;   f[12]=255; f[13]=255; f[14]=255; f[15]=255; f[16]=0;   f[17]=255; f[18]=0;   f[19]=0;
			f[ 0]=255; f[ 1]=255; f[ 2]=0;   f[ 3]=0;   f[ 4]=0;   f[ 5]=0;   f[ 6]=255; f[ 7]=255; f[ 8]=255; f[ 9]=0;
   
			m[ 8]=60;   m[ 9]=64;
			m[ 6]=126;  m[ 7]=192;
			m[ 4]=255;  m[ 5]=128;
			m[ 2]=126;  m[ 3]=192;
			m[ 0]=60;   m[ 1]=64;
			bmn.bitmap.size.w = 10;
  			bmn.bitmap.size.h = 5;
			bmn.bitmap.pPixels = f;
			bmn.bitmap.pMask = m;
			break;
		default:
			//
			// N.B. We don't case on tagTkResIcon. Since its bitmap is
			// defined in app.res, our ancestor can "provide" it.
			//
			s = ObjectCallAncestorCtx(ctx);	
			return s;
			break;
 	}
	ObjCallRet(msgNew, clsBitmap, &bmn, s);
	pArgs->bitmap = bmn.object.uid;

 	return stsOK;
	MsgHandlerParametersNoWarning;
}

