/****************************************************************************
 File: testsvc.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.18  $
   $Author:   kcatlin  $
     $Date:   31 Jan 1992 08:40:20  $

 This file contains the API definition for clsTestService.
 clsTestService inherits from clsService.

****************************************************************************/
#ifndef TEST_SERVICE_INCLUDED
#define TEST_SERVICE_INCLUDED

#ifndef SERVICE_INCLUDED
#include <service.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****  Class Option Tags  ****/ 
#define	tagTestSvcOptionCard				MakeTag(clsTestService, 10)
#define	tagTestSvcGlobalOptionCard			MakeTag(clsTestService, 11)

/****  Quick Help Tags  ****/
#define hlpTestSvcOptionCard  		 		MakeTag(clsTestService, 20) 
#define hlpTestSvcGlobalOptionCard   		MakeTag(clsTestService, 21) 

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                  				Messages        		               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNew                     takes P_TEST_SVC_NEW, returns STATUS
	category: class message
	Creates a new test service instance.
*/

typedef struct TEST_SVC_NEW_ONLY {
    U32                     unused1;
    U32                     unused2;
    U32                     unused3;
} TEST_SVC_NEW_ONLY, *P_TEST_SVC_NEW_ONLY;

#define testServiceNewFields \
    serviceNewFields         \
    TEST_SVC_NEW_ONLY       testSvc;

typedef struct TEST_SVC_NEW {
    testServiceNewFields
} TEST_SVC_NEW, *P_TEST_SVC_NEW;


/****************************************************************************
 msgNewDefaults                 takes P_TEST_SVC_NEW, returns STATUS
	category: class message
	Set defaults:

*/


						/* Your messages here! */


#endif  // TEST_SERVICE_INCLUDED



