/****************************************************************************
 $Workfile:   PIXELMAP.H  $

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this code in any way you please conditioned on the following:
 the code is licensed "AS-IS" and GO Corporation assumes no liability for
 its use and makes no warranty with respect to the code, including the
 implied warranties of fitness for a particular purpose, merchantability,
 and non-infringement.

 $Revision:   1.2  $
   $Author:   kcatlin  $
     $Date:   31 Jan 1992 08:34:52  $

 This file contains utilities for dealing with pixelmaps
****************************************************************************/

#ifndef PIXELMAP_INCLUDED
#define PIXELMAP_INCLUDED

/***************************************************************************
	CreatePixelMap

	Creates a memory window (pixelmap) that can be copied onto win later
	The window's size in pixels is determined by width and height.
	It's depth is determined by planes.
*/
OBJECT CreatePixelMapSimple( OBJECT win, int planes, int width, int height);
OBJECT CreatePixelMap( OBJECT win, P_WIN_DEV_PIXELMAP ppm);
STATUS SizePixelMap(OBJECT win,	P_WIN_DEV_PIXELMAP ppm);

/***************************************************************************
	CopyPixelMap

	Copies the pixelmap to (0,0) in win.
*/
STATUS CopyPixelMap( OBJECT pixelMap, OBJECT win);

/***************************************************************************
	DrawPixelMap

	Draw the pixelmap to (0,0) in win.
	This is only used for pixelmaps that are one plane deep.
*/
STATUS DrawPixelMap( OBJECT pixelMap, OBJECT win);

#endif
