/****************************************************************************
 $Workfile:   CUTIL.H  $

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this code in any way you please conditioned on the following:
 the code is licensed "AS-IS" and GO Corporation assumes no liability for
 its use and makes no warranty with respect to the code, including the
 implied warranties of fitness for a particular purpose, merchantability,
 and non-infringement.

 $Revision:   1.1  $
   $Author:   kcatlin  $
     $Date:   04 Feb 1992 18:28:40  $

 Routines to read and write data to a file:

	ReadData	- write data to a file
	WriteData	- fill in a structure from a file

	ReadString	- write a string to a file
	WriteString - create and fill in a string from a file

	CreateStringCopy - create and copy into a string
	FreeString - free a string
****************************************************************************/

#ifndef CPAPER_UTIL_INCLUDED
#define CPAPER_UTIL_INCLUDED

STATUS ReadData(
	OBJECT file,
	U32 numBytes,
	P_UNKNOWN pBuf);


STATUS WriteData(
	OBJECT file,
	U32 numBytes,
	P_UNKNOWN pBuf);


P_STRING CreateStringCopy(P_STRING pSrc);
STATUS FreeString(P_STRING pString);


STATUS ReadString(
	OBJECT file,
	P_STRING *pString);


STATUS WriteString(
	OBJECT file,
	P_STRING pString);

#endif
