/****************************************************************************
 $Workfile:   CUTIL.C  $

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.3  $
   $Author:   kcatlin  $
     $Date:   31 Jan 1992 08:34:58  $

 Routines to read and write data to a file:

	ReadData	- write data to a file
	WriteData	- fill in a structure from a file

	ReadString	- write a string to a file
	WriteString - create and fill in a string from a file
	CreateStringCopy - create and copy into a string
****************************************************************************/

#include <go.h>
#include <string.h>
#include <clsmgr.h>
#include <os.h>
#include <stream.h>
#include <debug.h>
#include "cutil.h"

STATUS ReadData(
	OBJECT file,
	U32 numBytes,
	P_UNKNOWN pBuf)
{
	STATUS s;
	STREAM_READ_WRITE	fsRead;
	fsRead.numBytes	= numBytes;
	fsRead.pBuf		= pBuf;
	ObjCallRet(msgStreamRead, file, &fsRead, s);
	if(fsRead.count != fsRead.numBytes)
		return(stsFailed);
	return(stsOK);
}

STATUS WriteData(
	OBJECT file,
	U32 numBytes,
	P_UNKNOWN pBuf)
{
	STREAM_READ_WRITE	fsWrite;
	fsWrite.numBytes	= numBytes;
	fsWrite.pBuf		= pBuf;
	return ObjectCall(msgStreamWrite, file, &fsWrite);
}

P_STRING CreateStringCopy(P_STRING pSrc)
{
	P_STRING pDest = pNull;
	U32 length;

	if(pSrc == pNull)
		return(pNull);

	length = strlen(pSrc) + 1;
	StsWarn(OSHeapBlockAlloc(osProcessHeapId, length, &pDest));
	if(pDest != pNull)
		strcpy(pDest, pSrc);
	return(pDest);
}

STATUS FreeString(P_STRING pString)
{
	return OSHeapBlockFree(pString);
}

STATUS ReadString(
	OBJECT file,
	P_STRING *pString)
{
	STATUS s;
	STREAM_READ_WRITE	fsRead;
	U32 length;
	fsRead.numBytes	= sizeof(length);
	fsRead.pBuf		= &length;
	ObjCallRet(msgStreamRead, file, &fsRead, s);

	if(length == 0)
		*pString = pNull;
	else
	  {
		OSHeapBlockAlloc(osProcessHeapId, length, pString);
		fsRead.numBytes	= length;
		fsRead.pBuf		= *pString;
		ObjCallRet(msgStreamRead, file, &fsRead, s);
	  }
//Debugf("  String '%s'", *pString);
	return(stsOK);
}

STATUS WriteString(
	OBJECT file,
	P_STRING pString)
{
	STATUS s;
	U32 length;
	STREAM_READ_WRITE	fsWrite;

//Debugf("  String '%s'", pString);

	if(pString == pNull)
		length = 0;
	else
		length = strlen(pString) + 1;

	fsWrite.numBytes	= sizeof(length);
	fsWrite.pBuf		= &length;
	ObjCallRet(msgStreamWrite, file, &fsWrite, s);

	if(length != 0)
	  {
		fsWrite.numBytes	= length;
		fsWrite.pBuf		= pString;
		ObjCallRet(msgStreamWrite, file, &fsWrite, s);
	  }

	return(stsOK);
}

