/****************************************************************************
 File: milsvc.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.16  $
   $Author:   jgarrett  $
     $Date:   12 Mar 1992 12:32:32  $

 This file contains the API definition for clsTestMILService.
 clsTestMILService inherits from clsMILService. 

 This mil service provides the interface between the parallel printer
 mil device and the rest of Penpoint.  This interface allows for the
 configuring of the parallel printer mil device and for printing using
 the parallel printer mil device.  The pport mil service will typically
 only be accessed by printer drivers since they are responsible for
 rendering an image for printing.

 You access this mil service by using the standard service access techniques.
 These techniques are discribed in servmgr.h.
 The pport mil service is a member of the 'theParallelDevices' and
 'thePrinterDevices' service managers.

****************************************************************************/

#ifndef MILSVC_INCLUDED
#define MILSVC_INCLUDED

#ifndef GO_INCLUDED
#include <go.h>
#endif

#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
#endif

#ifndef MIL_SERVICE_INCLUDED
#include <milserv.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *				Common #defines and typedefs							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef OBJECT			TEST_MIL_SVC, *P_TEST_MIL_SVC;


#define stsTestMILSvcBusy         MakeStatus(clsTestMILService, 1)
#define stsTestMILSvcOutOfPaper   MakeStatus(clsTestMILService, 2)
#define stsTestMILSvcOffLine      MakeStatus(clsTestMILService, 3)
#define stsTestMILSvcNoPrinter    MakeStatus(clsTestMILService, 4)
#define stsTestMILSvcPrinterErr   MakeStatus(clsTestMILService, 5)



typedef struct TEST_MIL_SVC_METRICS
{
	U16		version;			// version number of test mil service
	U16		devFlags;			// device flags (none defined)
	U16		unitFlags;			// unit flags (see dvparall.h)
	U32		initDelay;			// time in microSeconds init signal
								// is applied to printer
	U32		interruptTimeOut;	// the printer should be ready to accept
								// another character within this time
								// period (in milliseconds)
} TEST_MIL_SVC_METRICS, *P_TEST_MIL_SVC_METRICS;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Parallel Port Class Messages						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgTestMILSvcStatus	takes P_TEST_MIL_SVC_STATUS, returns STATUS
	returns the current hardware status of the printer.

	'testMILSvcStatus' is the contents of the parallel port status register.

*/

#define msgTestMILSvcStatus				MakeMsg(clsTestMILService, 3)

#define testMILSvcStsBusy				flag7	// printer is busy
#define testMILSvcStsAcknowledge		flag6	// printer acknowledged char.
#define testMILSvcStsEndOfPaper			flag5	// printer out of paper
#define testMILSvcStsSelected			flag4	// printer on line
#define testMIlSvcStsIOError			flag3	// printer error occurred
#define testMILSvcStsInterruptHappened	flag2	// printer interrupt occurred

typedef struct TEST_MIL_SVC_STATUS
{
	U16	testMILSvcStatus;
} TEST_MIL_SVC_STATUS, *P_TEST_MIL_SVC_STATUS;


/****************************************************************************
 msgTestMILSvcInitialize	takes P_NULL, returns STATUS
	initializes the printer.

	The printer is initialized by asserting the control
	line "Initialize" to the printer for initDelay microseconds.

*/

#define msgTestMILSvcInitialize			MakeMsg(clsTestMILService, 4)


/****************************************************************************
 msgTestMILSvcAutoLineFeedOn	takes P_NULL, returns STATUS
	inserts a line feed after each carriage return.

	The auto line feed signal to the printer is set active.

*/

#define msgTestMILSvcAutoLineFeedOn		MakeMsg(clsTestMILService, 5)


/****************************************************************************
 msgTestMILSvcAutoLineFeedOff	takes P_NULL, returns STATUS
	disables inserting a line feed after each carriage return.

	The auto line feed signal to the printer is set inactive.

*/

#define msgTestMILSvcAutoLineFeedOff	MakeMsg(clsTestMILService, 6)


/****************************************************************************
 msgTestMILSvcGetTimeDelays	takes P_TEST_MIL_SVC_TIME_DELAYS, returns STATUS
	gets the initialization and interrupt time out intervals.	

	The initialization time period is the time the initialization pulse
	is asserted to the printer in microseconds.  The interrupt time out
	interval is the maximum time the printer will assert busy before being
	ready to accept another character in milliseconds.

*/

#define msgTestMILSvcGetTimeDelays		MakeMsg(clsTestMILService, 7)

typedef struct TEST_MIL_SVC_TIME_DELAYS
{
	U32	initDelay;					// initialization delay
	U32	interruptTimeOut;			// interrupt time out
								
								
} TEST_MIL_SVC_TIME_DELAYS, *P_TEST_MIL_SVC_TIME_DELAYS;


/****************************************************************************
 msgTestMILSvcSetTimeDelays	takes P_TEST_MIL_SVC_TIME_DELAYS, returns STATUS
	sets the initialization and interrupt time out intervals.

	Neither value can be zero.  It's best to get the present
	values before changing the time intervals.

*/

#define msgTestMILSvcSetTimeDelays		MakeMsg(clsTestMILService, 8)

/****************************************************************************
 msgTestMILSvcCancelPrint	takes P_NULL, returns STATUS
	cancels the printing of the buffer currently being printed.

*/

#define msgTestMILSvcCancelPrint		MakeMsg(clsTestMILService, 9)

/****************************************************************************
 msgNew	takes P_TEST_MIL_SVC_NEW, returns STATUS
	creates a new test mil service object.

*/

#define testMILSvcNewFields		\
	milServiceNewFields

typedef struct TEST_MIL_SVC_NEW {
	testMILSvcNewFields
} TEST_MIL_SVC_NEW, *P_TEST_MIL_SVC_NEW;


STATUS EXPORTED ClsTestMILSvcInit(void);

#endif	// MILSVC_INCLUDED

