/****************************************************************************
 File: cntr.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.3  $
   $Author:   kcatlin  $
     $Date:   31 Jan 1992 08:15:44  $

 This file contains the API definition for clsCntr.
****************************************************************************/
#ifndef CNTR_INCLUDED
#define CNTR_INCLUDED

#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
#endif

#define clsCntr MakeWKN( 1, 1, wknPrivate)

#define stsCntrMaxReached MakeStatus(clsCntr, 1)


STATUS GLOBAL ClsCntrInit (void);


/****************************************************************************
 msgNew takes P_CNTR_NEW, returns STATUS

	Creates a new counter object.
****************************************************************************/

typedef struct CNTR_NEW_ONLY {

	S32 initialValue;

} CNTR_NEW_ONLY, *P_CNTR_NEW_ONLY;

#define  cntrNewFields  \
	objectNewFields \
	CNTR_NEW_ONLY  cntr;

typedef struct CNTR_NEW {

	cntrNewFields

} CNTR_NEW, *P_CNTR_NEW;

/****************************************************************************
 msgCntrIncr takes void, returns STATUS

	Bumps counter value by one.
****************************************************************************/
#define msgCntrIncr MakeMsg(clsCntr, 1)

/****************************************************************************
 msgCntrGetValue takes P_CNTR_INFO, returns STATUS

	Passes back counter value.
****************************************************************************/
#define msgCntrGetValue MakeMsg(clsCntr, 2)

typedef struct CNTR_INFO {

	S32 value;

} CNTR_INFO, *P_CNTR_INFO;

#endif // CNTR_INCLUDED

