/****************************************************************************
 File: clockapp.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.18  $
   $Author:   kcatlin  $
     $Date:   11 Feb 1992 14:01:34  $

 This file contains the constants for clsClockApp.
****************************************************************************/

// Messages
#define msgClockDisplayNote				MakeMsg(clsClockApp, 1)
#define msgClockAlarmOK					MakeMsg(clsClockApp, 2)
#define msgClockAlarmPostpone			MakeMsg(clsClockApp, 3)
#define msgClockNoteAccept				MakeMsg(clsClockApp, 4)
#define msgClockNewFormat				MakeMsg(clsClockApp, 5)
#define msgClockAppGetDisplayString		MakeMsg(clsClockApp, 6)

//
// Quick Help tags
//

// controls on "display" option sheet
#define hlpClkAppDisplayShow	MakeTag(clsClockApp,	1)
#define hlpClkAppDisplayFont	MakeTag(clsClockApp,	2)
#define hlpClkAppDisplayDSize	MakeTag(clsClockApp,	3)
#define hlpClkAppDisplayTSize	MakeTag(clsClockApp,	4)

// controls on "alarm" option sheet
#define hlpClkAppAlarmOn		MakeTag(clsClockApp,	5)
#define hlpClkAppAlarmDay		MakeTag(clsClockApp,	6)
#define hlpClkAppAlarmTime		MakeTag(clsClockApp,	7)
#define hlpClkAppAlarmMessage	MakeTag(clsClockApp,	8)
#define hlpClkAppAlarmOptions	MakeTag(clsClockApp,	9)
#define hlpClkAppAlarmCork		MakeTag(clsClockApp,	10)

// pieces of alarm note
#define hlpClkAppNoteMess		MakeTag(clsClockApp,	11)
// the general button area (command bar) of note
#define hlpClkAppNoteButtons	MakeTag(clsClockApp,	12)
// the specific buttons
#define hlpClkAppNoteSnooze	MakeTag(clsClockApp,	13)
#define hlpClkAppNoteDismiss	MakeTag(clsClockApp,	14)

// the main window of the clock
#define hlpClkAppMainWin		MakeTag(clsClockApp,	15)

// quick help and window tags for the entire option sheets
#define tagClkAppDisplayCard	MakeTag(clsClockApp,	16)
#define tagClkAppAlarmCard		MakeTag(clsClockApp,	17)

// status definitions for error messages
#define stsClockAlarmInvalid					MakeStatus(clsClockApp,	0)
#define stsClockFieldRangeError				MakeStatus(clsClockApp,	1)
#define stsClockIntFieldInvalid				MakeStatus(clsClockApp,	2)
#define stsClockDateFieldInvalid				MakeStatus(clsClockApp,	3)

