/****************************************************************************
 File: ttable.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.18  $
   $Author:   sbartlet  $
     $Date:   04 Mar 1992 13:56:00  $

 This file contains the API definition for clsToggleTable.

 clsToggleTable inherits from clsTkTable.
 Toggle tables implement non-exclusive choices.
****************************************************************************/
#ifndef TTABLE_INCLUDED
#define TTABLE_INCLUDED

												#ifndef TKTABLE_INCLUDED
#include <tktable.h>
												#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *						Common #defines and typedefs					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef OBJECT TOGGLE_TABLE;

/****************************************************************************
 msgNew		takes P_TOGGLE_TABLE_NEW, returns STATUS
	category: class message
	Creates a toggle table window.
*/

typedef struct TOGGLE_TABLE_NEW_ONLY {
	U32		spare;		// unused (reserved)
} TOGGLE_TABLE_NEW_ONLY, *P_TOGGLE_TABLE_NEW_ONLY;

#define	toggleTableNewFields	\
	tkTableNewFields			\
	TOGGLE_TABLE_NEW_ONLY		toggleTable;

typedef struct TOGGLE_TABLE_NEW {
	toggleTableNewFields
} TOGGLE_TABLE_NEW, *P_TOGGLE_TABLE_NEW;


/****************************************************************************
 msgNewDefaults					takes P_TOGGLE_TABLE_NEW, returns STATUS
	category: class message
	Initializes the TOGGLE_TABLE_NEW structure to default values.

 Sets the following values:
//{
	pArgs->gWin.style.gestureEnable = false;
	
	pArgs->tableLayout.style.growChildHeight = false;
	pArgs->tableLayout.style.growChildWidth = true;
	
	pArgs->tableLayout.numCols.constraint = tlAbsolute;
	pArgs->tableLayout.numCols.value = 1;
	
	pArgs->tableLayout.numRows.constraint = tlInfinite;
	
	pArgs->tableLayout.colWidth.constraint = tlChildrenMax;
	pArgs->tableLayout.colWidth.gap = 0;
	
	pArgs->tableLayout.rowHeight.constraint = tlGroupMax;
	pArgs->tableLayout.rowHeight.gap = 0;
//}
*/


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *				    Messages from Other Classes							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgTkTableChildDefaults		takes P_UNKNOWN, returns STATUS
	Sets the defaults in P_ARGS for a common child.

 Here is how a choice processes this message:
//{
	if <pArgs->object.class inherits from clsGWin>
		pArgs->gWin.style.gestureEnable = false;

	if <pArgs->object.class inherits from clsBorder> {
		pArgs->border.style.edge = bsEdgeNone;
		pArgs->border.style.topMargin = 1;
		pArgs->border.style.bottomMargin = 1;
	}

	if <pArgs->object.class inherits from clsLabel>
		pArgs->label.style.xAlignment = lsAlignLeft;

	if <pArgs->object.class inherits from clsButton> {
		pArgs->button.style.notifyDetail = true;
		pArgs->button.style.contact = bsContactToggle;
		pArgs->button.style.feedback = bsFeedbackDecorate;
		pArgs->button.style.offDecoration =
			lsDecorationNonExclusiveOff;
		pArgs->button.style.onDecoration =
			lsDecorationNonExclusiveOn;
	}
//}
*/


/****************************************************************************
 msgControlGetDirty		takes P_BOOLEAN, returns STATUS
	Passes back the dirty state of the control.

 clsToggleTable responds by setting *pArgs up as a 32 bit collection of
 the results of sending msgControlGetDirty to its first 32 children.
 The result of the first (bottom) child is placed in bit 0, the second in
 bit 1, and so on.

 The resulting *pArgs is undefined if the toggle table has more than 32
 children.
*/


/****************************************************************************
 msgControlGetEnable	takes P_BOOLEAN, returns STATUS
	Passes back whether the control is enabled.

 clsToggleTable responds by setting *pArgs up as a 32 bit collection of
 the results of sending msgControlGetEnable to its first 32 children.
 The result of the first (bottom) child is placed in bit 0, the second in
 bit 1, and so on.

 The resulting *pArgs is undefined if the toggle table has more than 32
 children.
*/


/****************************************************************************
 msgControlGetValue		takes P_TAG, returns STATUS
	Passes back the value of the control.

 clsToggleTable responds by setting *pArgs up as a 32 bit collection of
 the results of sending msgControlGetValue to its first 32 children.
 The result of the first (bottom) child is placed in bit 0, the second in
 bit 1, and so on.

 The resulting *pArgs is undefined if the toggle table has more than 32
 children.
*/


/****************************************************************************
 msgControlSetDirty		takes BOOLEAN, returns STATUS
	Sets dirty state of the control.

 clsToggleTable treats the pArgs as a 32 bit collection of values to
 send via msgControlSetDirty to its first 32 children.  The value of
 bit 0 is sent to the first (bottom) child, bit 1 is sent to the second
 child, and so on.
*/


/****************************************************************************
 msgControlSetEnable	takes BOOLEAN, returns STATUS
	Sets whether the control is enabled.

 clsToggleTable treats the pArgs as a 32 bit collection of values to
 send via msgControlSetEnable to its first 32 children.  The value of
 bit 0 is sent to the first (bottom) child, bit 1 is sent to the second
 child, and so on.
*/


/****************************************************************************
 msgControlSetValue		takes TAG, returns STATUS
	Sets the value of the control.

 clsToggleTable treats the pArgs as a 32 bit collection of values to
 send via msgControlSetValue to its first 32 children.  The value of
 bit 0 is sent to the first (bottom) child, bit 1 is sent to the second
 child, and so on.
*/


#endif	// TTABLE_INCLUDED
