/****************************************************************************
 File: settings.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.21  $
   $Author:   rfoster  $
     $Date:   28 Mar 1992 13:51:06  $

 clsSettingsNB inherits from clsApp.
 This class defines the Settings Notebook.

 There is only one instance of the Settings Notebook in the system, on
 the bookshelf.

 The Settings Notebook is an option book.  It contains a System Preferences 
 sheet, an Installer sheet, and a Status sheet.

 The Preferences sheet contains a group of Preferences cards.  These update
 the system preferences resource file (penpoint.res).

 The Installer sheet contains one card for each installation category (apps, 
 preferences, services, etc).  Each category has an underlying install 
 manager (see instlmgr.h).  A card is automatically created when a new
 install manager is created, and deleted when an install manger is destroyed.

 The Installer sheet allows a client to display a particular card
 and select an item within that card.  Here's example code which activates
 the Settings Notebook from the Bookshelf, turns it to the Installer sheet,
 displays a particular card, selects an item within that card, and finally 
 opens the Settings Notebook:

//{
#include <auxnbmgr.h>
#include <instlsht.h>

{
	ANM_OPEN_NOTEBOOK	openNotebook;
	APP_METRICS			am;
	IUI_SELECT_ITEM		selectItem;
	OPTION_CARD			oc;
	IUI_SHOW_CARD		showCard;
	STATUS				s;

	ObjectCall(msgBusySetState, theBusyManager, (P_ARGS) true);
	openNotebook.notebook = anmSettings;
	openNotebook.activateOnly = true;
	ObjCallRet(msgANMOpenNotebook, theAuxNotebookMgr, &openNotebook, s);
	ObjSendUpdateRet(msgAppGetMetrics, openNotebook.uid, &am, SizeOf(am), s);
	oc.tag = tagIUIInstallerSheet;
	ObjSendUpdateRet(msgOptionShowCard, am.mainWin, &oc, SizeOf(oc), s);
	ObjSendUpdateRet(msgOptionGetTopCard, am.mainWin, &oc, SizeOf(oc), s);
	strcpy(showCard.pCardName, "Applications");
	ObjSendRet(msgIUIShowCard, oc.win, &showCard, SizeOf(showCard), s);
	strcpy(selectItem.pItemName, appMgrMetrics.name);
	ObjSendRet(msgIUISelectItem, oc.win, &selectItem, SizeOf(selectItem), s);
	openNotebook.notebook = anmSettings;
	openNotebook.activateOnly = false;
	ObjCallRet(msgANMOpenNotebook, theAuxNotebookMgr, &openNotebook, s);
	ObjectCall(msgBusySetState, theBusyManager, (P_ARGS) false);
}
//}

****************************************************************************/

#ifndef SETTINGS_INCLUDED
#define SETTINGS_INCLUDED

#ifndef APPTAG_INCLUDED
#include <apptag.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * 				  		Common #defines and typedefs  					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#define	tagSettingsPrefSheet				  	MakeTag(clsInstallUISheet, 29)
#define	tagSettingsInstallerSheet	  			MakeTag(clsInstallUISheet, 30)
#define	tagSettingsStatusSheet				  	MakeTag(clsInstallUISheet, 31)

#define tagSettingsNBPeripheralsOnIconResId			tagAppIconBitmap
#define tagSettingsNBPeripheralsOnSmallIconResId	tagAppSmallIconBitmap

#define tagSettingsNBPeripheralsOffSmallIconResId \
									MakeTag(clsSettingsNBAppWin, 1)
#define tagSettingsNBPeripheralsOffIconResId \
									MakeTag(clsSettingsNBAppWin, 2)

#define	tagSettingsPrefCmdBar				  	MakeTag(clsSettingsNB, 100)

/**** Error status codes ****/

#define stsSettingsValueOutOfRange              MakeStatus(clsSettingsNB, 1)
#define stsSettingsFixedValueOutOfRange         MakeStatus(clsSettingsNB, 2)

#endif // SETTINGS_INCLUDED
