/****************************************************************************
 File: popupch.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.30  $
   $Author:   cmeyer  $
     $Date:   18 Mar 1992 16:58:34  $

 This file contains the API for clsPopupChoice.

 clsPopupChoice inherits from clsMenuButton.
 Popup choices are buttons that pop up a menu of choices when tapped.

 A popup choice assumes that the first (bottom) child of its menu inherits
 from clsChoice.  When this choice changes value, the popup choice button
 will copy the string of the new 'on' button in the choice as the popup
 choice's own string.  Popup choices also respond to flick gestures by
 cycling their value among the set of possible values in the choice.
****************************************************************************/


/**** Debugging Flags ****/
/*
 The clsPopupChoice debugging flag is 'K'.  Defined values are:

    flag13 (0x2000):    general
*/

#ifndef POPUPCH_INCLUDED
#define POPUPCH_INCLUDED

												#ifndef CHOICE_INCLUDED
#include <choice.h>
												#endif
												#ifndef MBUTTON_INCLUDED
#include <mbutton.h>
												#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *						Common #defines and typedefs					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef struct POPUP_CHOICE_STYLE {
    U16 spare;
} POPUP_CHOICE_STYLE, *P_POPUP_CHOICE_STYLE;

typedef OBJECT POPUP_CHOICE, *P_POPUP_CHOICE;

/****************************************************************************
 msgNew			takes P_POPUP_CHOICE_NEW, returns STATUS
	category: class message
	Creates a popup choice button.

 The popup choice will set its pString from the 'on' button within the popup's
 choice, if any button there is 'on'.

 The fields you commonly set are:
	pArgs->menuButton.menu:		uid of a menu whose first child is a choice
*/

typedef struct POPUP_CHOICE_NEW_ONLY {
    POPUP_CHOICE_STYLE	style;
	U32					spare;		// unused (reserved)
} POPUP_CHOICE_NEW_ONLY, *P_POPUP_CHOICE_NEW_ONLY;

#define popupChoiceNewFields	\
	menuButtonNewFields     	\
	POPUP_CHOICE_NEW_ONLY		popupChoice;
        
typedef struct POPUP_CHOICE_NEW {
	popupChoiceNewFields
} POPUP_CHOICE_NEW, *P_POPUP_CHOICE_NEW;


/****************************************************************************
 msgNewDefaults			takes P_POPUP_CHOICE_NEW, returns STATUS
	category: class message
	Initializes the POPUP_CHOICE_NEW structure to default values.

 Zeroes out pArgs->popupChoice and sets:
//{
	pArgs->gWin.style.gestureEnable = true;
	pArgs->control.style.showDirty = true;
	pArgs->label.style.decoration = lsDecorationPopup;
	pArgs->button.style.feedback = bsFeedbackNone;
	pArgs->menuButton.style.subMenuType = mbMenuPopup;
	pArgs->menuButton.style.getWidth = true;
//}
*/


/****************************************************************************
 msgPopupChoiceGetStyle			takes P_POPUP_CHOICE_STYLE, returns STATUS
	Passes back the receiver's style.  NOT IMPLEMENTED.
*/
#define msgPopupChoiceGetStyle		MakeMsg(clsPopupChoice, 1)


/****************************************************************************
 msgPopupChoiceSetStyle			takes P_POPUP_CHOICE_STYLE, returns STATUS
	Sets the receiver's style.  NOT IMPLEMENTED.
*/
#define msgPopupChoiceSetStyle		MakeMsg(clsPopupChoice, 2)


/****************************************************************************
 msgPopupChoiceGetChoice		takes P_CHOICE, returns STATUS
	Passes back the choice associated with this popup.

 The popup choice will self-send msgMenuButtonGetMenu to get the menu.
 If the menu is null, the popup choice will set *pArgs null and return stsOK.
 Otherwise, *pArgs will be set to the first child of the menu.
*/
#define msgPopupChoiceGetChoice		MakeMsg(clsPopupChoice, 3)


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *				    Messages from Other Classes							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgWinSend 	takes P_WIN_SEND, returns STATUS
    Sends a message up a window ancestry chain.

 If pArgs->msg is not msgMenuDone, clsPopupChoice just calls its ancestor.

 Otherwise, clsPopupChoice calls its ancestor (to allow clsMenuButton to
 take down the menu), then resets its visuals to reflect the new 'on' button
 within the choice.
 
 For popup choices that display a string, this just means obtaining the
 string from the 'on' button (or, if the button has LABEL_STYLE.infoType
 of lsInfoWindow, from the first lsInfoString label found within using
 depth enumeration) and using msgLabelSetString on self.

 For popup choices that display an icon, the visuals are changed by getting
 the icon within self (msgLabelGetWin), sending it msgIconFreeCache,
 setting its window tag to the tag of the 'on' icon, and finally using
 msgWinDirtyRect(pNull) to get the icon to repaint.  Note that because of
 this strategy, the icon within self cannot change size when its picture
 changes.  The picture size is not copied from the 'on' icon to the icon
 within self.
*/


/****************************************************************************
 msgGWinGesture		takes P_GWIN_GESTURE, returns STATUS
	Self-sent to process the gesture.

 If the popup's CONTROL_STYLE.enable is false, the popup choice just returns
 stsOK.

 If the class of pArgs->msg is not clsXGesture, the popup choice returns
 stsMessageIgnored.

 If pArgs->msg is not one of xgsFlick* or xgsDblFlick*, then the popup
 choice returns the result of calling its ancestor.

 Otherwise, the popup choice obtains the 'on' button within its choice,
 and searches through the choice's list of children for the next, previous,
 first, or last child based on what type of flick gesture was received.
 The popup choice sets its value to be this new button and returns stsOK.
 Buttons that are not enabled (msgControlGetEnable) are skipped over.

 Return Value
	stsMessageIgnored:	pArgs->msg is not of clsXGesture.
*/


/****************************************************************************
 msgControlGetValue				takes P_TAG, returns STATUS
	Passes back the receiver's value (tag of button that is on).

 clsPopupChoice overrides clsButton's response (of passing back
 BUTTON_STYLE.on) by instead forwarding msgControlGetValue on to its choice.
 This means popup choices behave like choices with respect to
 msgControlGetValue.
*/


/****************************************************************************
 msgControlSetValue				takes TAG, returns STATUS
	Sets the receiver's value.

 clsPopupChoice overrides clsButton's response (of setting BUTTON_STYLE.on)
 by instead forwarding msgControlSetValue on to its choice.  Changing the
 choice's value then results in an update of the popup's label string.
 This means popup choices behave like choices with respect to
 msgControlSetValue.
*/


/****************************************************************************
 msgControlGetClient		takes P_UID, returns STATUS
	Passes back the receiver's client.

 clsPopupChoice intercepts this message and forwards it on to the popup's
 choice.
*/


/****************************************************************************
 msgControlSetClient		takes UID, returns STATUS
    clsPopupChoice forwards this message on to the popup's choice.
*/


/****************************************************************************
 msgControlBeginPreview		takes P_INPUT_EVENT, returns STATUS
    clsPopupChoice responds by noting internally that its menu is now up,
	then calling ancestor.
*/


/****************************************************************************
 msgControlSetMetrics		takes P_CONTROL_METRICS, returns STATUS
	Sets the metrics.

 If the popup choice's menu is up, it prohibits the CONTROL_STYLE.dirty
 bit from changing.
*/


/****************************************************************************
 msgControlSetStyle		takes P_CONTROL_STYLE, returns STATUS
	Sets the style values.

 If the popup choice's menu is up, it prohibits the CONTROL_STYLE.dirty
 bit from changing.
*/


/****************************************************************************
 msgControlSetDirty		takes BOOLEAN, returns STATUS
	Sets style.dirty.

 If the popup choice's menu is up, it prohibits the CONTROL_STYLE.dirty
 bit from changing.
*/


/****************************************************************************
 msgMenuButtonProvideWidth		takes P_S32, returns STATUS
	category: self-sent
	Self-sent when MENU_BUTTON_STYLE.getWidth is true.

 clsPopupChoice responds by computing a width based on its menu.

 If the wsLayoutDirty bit of its menu is true, the popup choice will
 lay out its menu.  clsPopupChoice then enumerates all the children
 of its choice and computes the maximum width of all the children
 that inherit from clsLabel and whose LABEL_STYLE.infoType is not
 lsInfoWindow (if an lsInfoWindow label child is encountered, clsPopupChoice
 will find the first string-type label within it and use the width of that).
*/


/****************************************************************************
 msgMenuButtonPlaceMenu			takes P_WIN_METRICS, returns STATUS
	category: self-sent
	Self-sent whenever a menu button needs to position its associated menu.

 clsPopupChoice first gets the 'on' button from its choice.  If there is a
 button on, clsPopupChoice will position its menu so that the 'on' button
 is adjacent to the popup.  If there is no button on in the choice,
 clsPopupChoice just calls its ancestor.
*/


#endif
