/****************************************************************************
 File: menu.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.56  $
   $Author:   cmeyer  $
     $Date:   16 Mar 1992 17:35:48  $

 This file contains the API definition for clsMenu.

 clsMenu inherits from clsTkTable.
 Menus are collections of menu buttons (each of the latter may have a
 submenu associated with it, which in turn is a collection of menu
 buttons...).
****************************************************************************/
#ifndef MENU_INCLUDED
#define MENU_INCLUDED

													#ifndef TKTABLE_INCLUDED
#include <tktable.h>
													#endif
													#ifndef MBUTTON_INCLUDED
#include <mbutton.h>
													#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef OBJECT MENU, *P_MENU;

/****  Menu Type Styles  ****/
#define	msTypeMenuBar	0		// horizontal menu bar
#define	msTypeMenu		1		// pull-down or pull-right
//						2		// unused (reserved)
//						3		// unused (reserved)

typedef struct MENU_STYLE {
	U16	type	: 2,	// menu type
		spare	: 14;	// unused (reserved)
} MENU_STYLE, *P_MENU_STYLE;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							Messages									   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNew		takes P_MENU_NEW, returns STATUS
	category: class message
	Creates a menu window, together with the child windows specified in
	pEntries.

 If pArgs->menu.style.type is msTypeMenu, the following is done before
 ObjectCallAncestor():
//{
	pArgs->win.flags.style |= wsSaveUnder;
   	pArgs->win.flags.style |= wsClipSiblings;
   	pArgs->win.flags.style &= ~(U32)wsParentClip;

	pArgs->border.style.shadow			= bsShadowThinBlack;
	pArgs->border.style.shadowGap		= bsGapTransparent;

	pArgs->border.style.leftMargin		= bsMarginMedium;
	pArgs->border.style.rightMargin		= bsMarginMedium;
	pArgs->border.style.bottomMargin	= bsMarginMedium;
	pArgs->border.style.topMargin		= bsMarginMedium;

	pArgs->tableLayout.style.growChildWidth = true;
   	pArgs->tableLayout.style.wrap = false;

	pArgs->tableLayout.numRows.constraint	= tlInfinite;
	pArgs->tableLayout.numCols.constraint	= tlAbsolute;
	pArgs->tableLayout.numCols.value		= 1;
	pArgs->tableLayout.colWidth.constraint	= tlChildrenMax;
//}
*/

typedef struct MENU_NEW_ONLY {
	MENU_STYLE		style;			// overall style
	MENU_BUTTON_NEW	menuButtonNew;	// storage for default child new struct
	U32				spare;			// unused (reserved)
} MENU_NEW_ONLY, *P_MENU_NEW_ONLY;

#define	menuNewFields		\
	tkTableNewFields	\
	MENU_NEW_ONLY	 	 	menu;

typedef struct MENU_NEW {
	menuNewFields
} MENU_NEW, *P_MENU_NEW;


/****************************************************************************
 msgNewDefaults				takes P_MENU_NEW, returns STATUS
	category: class message
	Initializes the MENU_NEW structure to default values.

 Zeroes out pArgs->menu and sets
//{
	pArgs->win.flags.style |= wsFileNoBounds;

	pArgs->embeddedWin.style.selection = ewSelectPreserve;

	pArgs->gWin.style.gestureEnable = false;

	pArgs->border.style.edge = bsEdgeAll;
	pArgs->border.style.leftMargin = bsMarginMedium;
	pArgs->border.style.rightMargin = bsMarginMedium;
	pArgs->border.style.bottomMargin = bsMarginSmall;
	pArgs->border.style.topMargin = bsMarginMedium;

	// layout for msTypeMenuBar
	pArgs->tableLayout.style.growChildWidth = false;
	pArgs->tableLayout.style.growChildHeight = false;
	pArgs->tableLayout.style.wrap = true;

	pArgs->tableLayout.colWidth.gap = defaultColGap;
	pArgs->tableLayout.rowHeight.constraint = tlGroupMax;
	pArgs->tableLayout.rowHeight.gap = defaultRowGap;

	pArgs->menu.style.type = msTypeMenuBar;
//}

 The menu is a table of clsMenuButton buttons, so pArgs->tkTable.pButtonNew
 is set to the address of pArgs->menu.menuButtonNew.  This menuButtonNew
 is initialized using msgNewDefaults to clsMenuButton, then altered as in
 msgTkTableChildDefaults.  See msgTkTableChildDefaults for more info.
*/

/*
 Default Menu style:
//{
 	type = msTypeMenuBar
//}
*/


/****************************************************************************
 msgMenuGetStyle		takes P_MENU_STYLE, returns STATUS
	Passes back the current style values.
*/
#define msgMenuGetStyle		MakeMsg(clsMenu, 4)

/****************************************************************************
 msgMenuSetStyle		takes P_MENU_STYLE, returns STATUS
	Sets the style values.
	
 Note: setting style.type is not implemented.
*/
#define msgMenuSetStyle		MakeMsg(clsMenu, 5)

/****************************************************************************
 msgMenuShow		takes BOOLEAN, returns STATUS
	Puts up or takes down the menu by inserting or extracting it as a child
	of theRootWindow.

 To show the menu, first delta the menu to the desired position, in root window
 space and use pArgs of true.  To hide the menu, use pArgs of false.

 Before showing the menu, the menu's origin is altered as follows
 (in this order):
 	-: If the menu is wider or taller than theRootWindow, the menu will be
	   placed in an instance of clsScrollWin to allow the user to scroll
	   through the menu contents.

	-: If the menu falls off the right edge of the root window, the menu
	   is right-justified.

	-: If the menu falls off the left edge of the root window,
	   the menu is left-justified.

	-: If the menu falls below the bottom edge of the root window,
	   the menu is bottom-justified.

	-: If the menu falls above the top edge of the root window,
	   the menu is top-justified.

 The menu will insert itself as an input filter when shown, and remove
 itself when hidden.  The menu will be extracted from the root window
 when hidden.
*/
#define msgMenuShow		  	MakeMsg(clsMenu, 1)

/****************************************************************************
 msgMenuDone		takes WIN, returns STATUS
	category: manager notification
	Sent via msgWinSend to the manager when the menu is "done".

 The manager should use msgMenuShow to take down the menu.  See msgWinSend
 for clsMenu's response to msgMenuDone via msgWinSend.
*/
#define msgMenuDone		  	MakeMsg(clsMenu, 2)

/****************************************************************************
 msgMenuAdjustSections		takes BOOLEAN, returns STATUS
	Adjusts the border edges and margins of children to correctly reflect
	a sectioned menu.

 This message is provided for compatibility and results in a self-send of
 msgTblLayoutAdjustSections.  New clients should use
 msgTblLayoutAdjustSections directly.

 See Also
 	msgTblLayoutAdjustSections
*/
#define msgMenuAdjustSections		MakeMsg(clsMenu, 3)

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *				    Messages from other classes							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgTkTableChildDefaults		takes P_UNKNOWN, returns STATUS
	Sets the defaults in pArgs for a common child.

 clsMenu sets up defaults for each child as follows:
//{
	pArgs->win.flags.style |= wsParentClip;
	pArgs->win.flags.style &= ~(U32)(wsClipSiblings|wsClipChildren);
//}

 If the child is a descendant of clsBorder, then
//{   
	pArgs->border.style.backgroundInk |= bsInkExclusive;
//}

 If the child is a descendant of clsButton, then
//{
	pArgs->button.style.manager = bsManagerParent;
//}
*/

/****************************************************************************
 msgInputEvent 					takes P_INPUT_EVENT, returns STATUS
	Notification of an input event. 

 clsMenu receives input events as a result of the InputFilterAdd() done during
 msgMenuShow.  The events are handled as follows:
	-: If pArgs->destination is self, stsInputSkip returned.

	-: If pArgs->destination is a descendant of self (i.e. in the menu's 
	   window tree), the event is passed through to the destination by
	   returning stsInputSkip.

	-: If the pArgs->devCode is msgPenDown,  clsMenu will ObjectCallAncestor()
	   msgWinSend with the following WIN_SEND parameters:
//{
			msg		= msgMenuDone;
			data[0]	= pArgs->destination;
			flags	= wsSendDefault;
			lenSend	= SizeOf(WIN_SEND);
//}
	   This is intended as a notification to the menu's manager that the
	   menu is ready to be taken down. If pArgs->destination is a descendant
	   of clsMenuButton, stsInputContinue is returned to allow the input
	   event to continue; otherwise, the event is terminated by returning
	   stsInputTerminateRemoveStroke.

	-: All other input events result in a return status of
	   stsInputContinue.
*/

/****************************************************************************
 msgWinSend 	takes WIN_SEND, returns STATUS
    Sends a message up a window ancestry chain.

 clsMenu looks for manager notifications of msgMenuDone or msgButtonDone
 via msgWinSend.

 If pArgs->msg is msgMenuDone and pArgs->data[0] is a descendant of self,
 clsMenu will return stsOK.  This prevents self's manager from receiving
 the msgMenuDone and taking down the menu.  This prevents, for example,
 a pull-right menu coming down from taking down its main menu.

 If pArgs->msg is msgButtonDone, pArgs->msg is replaced with msgMenuDone
 before calling ObjectCallAncestor().  This results, for example, in
 the menu coming down when a button in the menu is hit.

 All other values of pArgs->msg result in ObjectCallAncestor().
*/

#endif	// MENU_INCLUDED
