/****************************************************************************
 keystate.h

 Copyright 1992, GO Corporation, All Rights Reserved

 $Revision:   1.3  $
   $Author:   kbentley  $
	 $Date:   16 Mar 1992 14:26:22  $

 Interface for the hardware independent keyboard code interpreter

 WARNING:	These API calls are not currently in a state suitable
			for developer use.

****************************************************************************/
#ifndef KEYSTATE_INCLUDED
#define KEYSTATE_INCLUDED

#ifndef GO_INCLUDED
#include <go.h>
#endif
#ifndef OSHEAP_INCLUDED
#include <osheap.h>
#endif
#ifndef KEY_INCLUDED
#include <key.h>
#endif

#define keyMultiMax		 16  // max # multi-key buffered events

typedef void (PASCAL *P_KEYSTATE_PROC)(P_UNKNOWN, MESSAGE, P_KEY_DATA);

typedef struct KEYSTATE {		// keyboard decode state 
	U16 state;					// long-term state flags 
	U16 lastScanned;			// last scan code processed 
	U16 lastSent;				// last scan code sent 
	U16 count;					// count of repeated codes while on Hold 
	S16 onHold;					// number of character events to be processed 
	S16 multi;					// number of multi-char events   "
	P_U16 pMap;					// pointer to the scan-to-char map 
	S16 multiIndex;				// index into the multi-key array 
	P_KEY_MULTI pBuffer;		// buffer for multi-key recording 
	P_KEYSTATE_PROC pKeyEvent;  // proc. pointer for reporting keystate changes 
	P_UNKNOWN pUserData;		// data for use by the user proc. 
} KEYSTATE, *P_KEYSTATE;

/****************************************************************************
 KeyStateSetup					returns nothing
 	Initializes a state structure to quiesent values.
*/
void PASCAL KeyStateSetup(
	P_KEYSTATE pState
);

/****************************************************************************
 KeyStateProcess				returns nothing
 	Converts the scan code into the approriate action for shift keys
 	and standard keys.
*/
void PASCAL KeyStateProcess(
	P_KEYSTATE pState,			// pointer to the keyboard state structure 
	U16 scanCode				// scan code to process 
);

/****************************************************************************
 KeyStateConvert 				returns nothing
 	Converts a scan code to the appropriate character code, or sets up
 	the appropriate shift state.
*/
void PASCAL KeyStateConvert(
	P_KEYSTATE pState,			// pointer to the keyboard state structure 
	U16 scanCode,				// scan code to convert 
	P_U16 pChar,				// character code
	P_U16 pDisplay				// display charactere code
);

/****************************************************************************
 KeyStateReturn				returns nothing
	Process completion of the key event.
*/
void PASCAL KeyStateReturn(
	P_KEYSTATE pState,
	MESSAGE msg, 
	P_KEY_DATA pKey
);
 
/****************************************************************************
 KeyStateFindScan				returns nothing
	Returns the scan code for a shift state flag.
*/
typedef struct KEYSTATE_SCANS {
	U16 count;					// In: max count, Out: actual count
	U16 scanCodes[4];			// can be variable number of entries
} KEYSTATE_SCANS, *P_KEYSTATE_SCANS;

void PASCAL KeyStateFindScan(
	P_KEYSTATE pState,			// pointer to the keyboard state structure 
	U16 state,					// state flag for search
	P_KEYSTATE_SCANS pScanCode	// Out: scan code
);

/****************************************************************************
 KeyStateDisplay				returns nothing
	Returns the set of display codes for the scan code.
*/
typedef struct KEYSTATE_CODES {
	U16 count;					// In: max count, Out: actual count
	struct {
		U16 shift;
		U16 charCode;
	} data[4];					// can be variable number of entries
} KEYSTATE_CODES, *P_KEYSTATE_CODES;

void PASCAL KeyStateDisplay(
	P_KEYSTATE pState,			// pointer to the keyboard state structure 
	U16 scanCode,				// scan code to be converted
	P_KEYSTATE_CODES pCodes		// Out: scan code
);

#endif
