/****************************************************************************
 File: goto.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.20  $
   $Author:   kcatlin  $
     $Date:   04 Mar 1992 09:09:10  $

 This file contains the API definition for clsGotoButton.

 clsGotoButton inherits from clsButton.
 Provides links to other documents.

 A Goto Button is a Button associated with a Mark object.  When the
 Goto Button is tapped, the data pointed to by the Mark are brought
 into view. Note that Goto Buttons are called Reference Buttons in
 the PenPoint User Interface.
****************************************************************************/
#ifndef GOTO_INCLUDED
#define GOTO_INCLUDED

#ifndef BUTTON_INCLUDED
#include <button.h>
#endif
#ifndef MARK_INCLUDED
#include <mark.h>
#endif

typedef OBJECT GOTO_BUTTON, *P_GOTO_BUTTON;

#define qhGotoButton				MakeTag(clsGotoButton, 1)

/****************************************************************************
 msgNew	takes P_GOTO_BUTTON_NEW, returns STATUS
    category: class message
	Creates a new Goto Button object.

 You can pass in the exact mark object that you want the Goto Button
 to use, or simply set up the markNew structure and let the Goto
 Button create its own mark.
*/

typedef struct GOTO_BUTTON_NEW_ONLY {
	MARK		mark;			// the mark of the button, or objNull
	MARK_NEW	markNew;		// New structure used to create a mark
	U32			reserved[2];	// Reserved.
} GOTO_BUTTON_NEW_ONLY, *P_GOTO_BUTTON_NEW_ONLY;

#define	gotoButtonNewFields		\
	buttonNewFields				\
	GOTO_BUTTON_NEW_ONLY		gotoButton;

typedef struct GOTO_BUTTON_NEW {
	gotoButtonNewFields
} GOTO_BUTTON_NEW, *P_GOTO_BUTTON_NEW;

/****************************************************************************
 msgNewDefaults 	takes P_GOTO_BUTTON_NEW, returns STATUS
    category: class message
	Initializes a GOTO_BUTTON_NEW structure.

 clsGoto sets up the structure so that the Goto Button will create its
 own mark for the selection.  The mark will be document relative because
 of the setting of the markForSelection and markDocRelative flags in
 the markNew structure.

 Zeroes out pArgs->gotoButton and sets
//{
	pArgs->win.flags.input				|= inputHoldTimeout;
	pArgs->gWin.helpId					= qhGotoButton;
	pArgs->embeddedWin.style.embeddee	= true;
	pArgs->embeddedWin.style.moveable	= true;
	pArgs->embeddedWin.style.copyable	= true;
	pArgs->embeddedWin.style.selection	= ewSelect;
	pArgs->label.scale					= lsScaleMedium;

	ObjectCall(msgNewDefaults, clsMark, &(pArgs->gotoButton.markNew));
	pArgs->gotoButton.markNew.mark.flags |=	markForSelection 
                                          | markDocRelative 
                                          | markRelaxActivate;
//}
*/

/****************************************************************************
 msgGotoButtonGetMark		takes P_MARK, returns STATUS
    category: class message
	Passes back the mark object being used by a Goto Button.
*/
#define msgGotoButtonGetMark	 				MakeMsg(clsGotoButton, 1)


/****************************************************************************
 msgGotoButtonGotoLink	takes BOOLEAN, returns STATUS
	Jumps to the mark being used by a Goto Button.

 If pArgs is true, turn to the document; if pArgs is false, float the 
 document.
*/
#define msgGotoButtonGotoLink					MakeMsg(clsGotoButton, 3)

/****************************************************************************
 msgGotoButtonDeleteLink	takes nothing, returns STATUS
	Deletes a Goto Button link.
*/
#define msgGotoButtonDeleteLink					MakeMsg(clsGotoButton, 4)

/****************************************************************************
 msgGotoButtonLinkToSelection	takes nothing, returns STATUS
	Links a Goto Button to the selection.
*/
#define msgGotoButtonLinkToSelection			MakeMsg(clsGotoButton, 5)

/****************************************************************************
 msgGotoButtonEditLabel	takes nothing, returns STATUS
	Allows the user to edit a Goto Button's label.
*/
#define msgGotoButtonEditLabel					MakeMsg(clsGotoButton, 7)

/****************************************************************************
 msgGotoButtonPressed	takes OBJECT, returns STATUS
	Sent to observers when a Goto Button has been executed.

 pArgs is the button that was pressed.
*/
#define msgGotoButtonPressed					MakeMsg(clsGotoButton, 6)


/****************************************************************************
 msgGotoButtonResetLabel	takes nothing, returns STATUS
	Causes a Goto Button to reset its label based on the thing it points to.
    
 This message is self sent at object new time, and generally should never
 be resent as it destroys any editing the user has done.
*/
#define msgGotoButtonResetLabel					MakeMsg(clsGotoButton, 2)

/****************************************************************************
 msgGotoButtonGetLabel		takes P_GOTO_BUTTON_GET_LABEL, returns STATUS
	Sent to the component containing the marked selection when the
    Goto Button's label	is reset.
    
 Components that support Goto Buttons should fill in the buffer (*pBuf)
 with the label to use.  If you don't support this message, then clsGoto
 will try msgSRGetChars to get the characters pointed to by the mark.
*/
#define msgGotoButtonGetLabel					MakeMsg(clsGotoButton, 8)

typedef struct GOTO_BUTTON_GET_LABEL {
	MARK_MSG_HEADER		header;
	U32					bufLen;
	P_CHAR				pBuf;
} GOTO_BUTTON_GET_LABEL, * P_GOTO_BUTTON_GET_LABEL;

/****************************************************************************
 msgGotoButtonRePosition	takes P_MARK_MESSAGE, returns STATUS
 	Sent to the component conataining the mark to request possible
    re-positioning for the Goto Button.
 
 This message is sent when a component wants the Goto Button to end up
 pointing at a child and not itself.  To do this the component returns
 stsMarkEnterChild to this message, and then the Goto Button will send
 msgMarkGetChild to re-position the mark at the child (but not actually
 enter it).  Most clients that support Goto Buttons ignore this message.
*/
#define msgGotoButtonRePosition					MakeMsg(clsGotoButton, 9)


#endif	// GOTO_BUTTON_INCLUDED
