/****************************************************************************
 gosearch.h

 Copyright 1992, GO Corporation, All Rights Reserved.

 $Revision:   1.6  $
   $Author:   msapsfor  $
     $Date:   27 Feb 1992 12:07:18  $

 This file contains the API definition for GO's modified binary search.
 The function described in this file is contained in MISC.LIB.

 The fundamental difference between this binary search and the search that
 is part of the standard runtime is that if the search fails, this search
 indicates where a searched for element should have been located, thereby
 aiding insertion of a new element.
****************************************************************************/
#ifndef GOSEARCH_INCLUDED
#define GOSEARCH_INCLUDED $Revision:   1.6  $ 

													#ifndef GO_INCLUDED
#include <go.h>
													#endif

typedef P_UNKNOWN (CDECL *ACCESS_FUNC)(
						const P_UNKNOWN,		// context
						const U32);				// index
typedef int 	  (CDECL *COMPARE_FUNC)(
						const P_UNKNOWN,		// context
						const P_UNKNOWN,		// key1
						const P_UNKNOWN);		// key2

/****************************************************************************
 binarySearch returns STATUS
	Performs a binary search for specified key within dataStructure.

 binarySearch performs a binary search on a sorted, indexed data structure.

 The caller provides an count of the number of items in the data structure,
 an access function that translates an item index into an address for the
 item key, and a comparison function to compare a pair of keys.

 A detailed description of the parameters follows.
	key:			key to search for.
	dataStructure:	handle of data structure to search.
	count:			number of items in data structure.
	compare:		pointer to comparison function (see below).
	access:			pointer to access function (see below).  If Nil,
					dataStructure is assumed to be the address of a sorted,
					contiguous array of items (itemSize bytes long) with the
					item key at the start of each item.
	itemSize:		size of item in bytes (only used if access is Nil).
	pFoundOrInsert:	pointer to key (see below).
	pIndex:			pointer to index (see below).

 The access function is provided with the client provided dataStructure and
 a (zero origin) index.  It is responsible for returning the key for the
 indexed item.  This key must be comprehensible to the comparison function,
 but is otherwise uninterpreted by the search.

 The comparison function is responsible for actually comparing two keys,
 and returning values as follows.
//{
	<  0:	when key1 < key2,
	== 0:	when key1 == key2,
    >  0:	when key1 > key2.
//}
 key1 is always the key originally passed to binarySearch as a parameter.
 key2 is always a key generated from dataStructure by the access function.

 When binarySearch returns, *pFoundOrInsert contains either:
//{
	the first occurrence of the desired key, if it was found; or
	NULL, if the key was not found but was greater than the keys
		of all the items in dataStructure; or
	the first key larger than the desired key.
//}
 In addition, when binarySearch returns, *pIndex contains either count,
 if *pFoundOrInsert == NULL, or the index used to access the key
 returned via *pFoundOrInsert.

 The return value is:
	stsOK:			if desired key located, or
	stsNoMatch:		if desired key not located
*/
STATUS EXPORTED binarySearch(
	const P_UNKNOWN	key,
	const P_UNKNOWN	dataStructure,
	const U32		count,
	COMPARE_FUNC	compare,
	ACCESS_FUNC		access,
	const U16		itemSize,
	PP_UNKNOWN		pFoundOrInsert,
	P_U32			pIndex);

#endif // GOSEARCH_INCLUDED
