/****************************************************************************
 File: fontlbox.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.20  $
   $Author:   sbartlet  $
     $Date:   04 Mar 1992 13:56:24  $

 This file contains the API for clsFontListBox.

 clsFontListBox inherits from clsStringListBox.
 Provides a listbox that is based on the list of currently installed fonts.
****************************************************************************/

#ifndef FONTLBOX_INCLUDED
#define FONTLBOX_INCLUDED

												#ifndef STRLBOX_INCLUDED
#include <strlbox.h>
												#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *						Common #defines and typedefs					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef struct {
	U16  prune : 16;  // FIM_PRUNE_CONTROL (see fontmgr.h)
	U16  spare : 16;  // reserved
} FONTLB_STYLE, *P_FONTLB_STYLE;

/*
 Default FONTLB_STYLE:
	prune = fimNoPruning (see fontmgr.h)
 */

/****************************************************************************
 msgNew						takes P_FONTLB_NEW, returns STATUS
	category: class message
	Creates a font list box window.

 In response to msgNew, clsFontListBox will set pArgs->listBox.nEntries
 to zero and then call ancestor.  It will then use msgFIMGetInstalledIdList
 to get the list of fonts currently installed in the system.  For each font,
 clsFontListBox will add an entry using msgListBoxInsertEntry that has
 'freeEntry' set to lbFreeDataDefault and 'data' set to the IM_HANDLE of
 the font.

 As a last step, the new listBox instance will be added as an observer
 of theInstalledFonts.

 We recommend that clients set pArgs->listBox.style.filing = lbFileMin to
 avoid unexpected results after a font listBox has been restored.  See the
 documentation for msgRestore below.

 See Also
	msgFIMGetInstalledIdList:	obtain the short IDs of all installed fonts.
*/

typedef struct {
	FONTLB_STYLE	style;		// overall style
	U32				spare;		// reserved
} FONTLB_NEW_ONLY, *P_FONTLB_NEW_ONLY;

#define fontListBoxNewFields	\
	stringListBoxNewFields		\
	FONTLB_NEW_ONLY				fontListBox;

typedef struct {
	fontListBoxNewFields
} FONTLB_NEW, *P_FONTLB_NEW;


/****************************************************************************
 msgNewDefaults					takes P_FONTLB_NEW, returns STATUS
	category: class message
	Initializes the FONTLB_NEW structure to default values.

 Zeroes out pArgs->fontListBox and sets:
//{
	pArgs->stringListBox.style.role = slbRoleChoice01;
//}
*/


/****************************************************************************
 msgFontListBoxGetStyle			takes P_FONTLB_STYLE, returns STATUS
	Gets the style of a font listbox.
*/
#define msgFontListBoxGetStyle				MakeMsg(clsFontListBox, 1)


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *				    Messages from Other Classes							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgFree	takes OBJ_KEY, returns STATUS
	Sent as the last of three msgs to destroy an object.

 The receiver will remove itself as an observer of theInstalledFonts.
*/


/****************************************************************************
 msgRestore	takes P_OBJ_RESTORE, returns STATUS
	Creates and restores an object from an object file.

 clsFontListBox responds by restoring its style values and resynchronizing
 its entries with respect to the list of installed fonts, as is done
 in msgNew.  The restored instance is added as an observer of
 theInstalledFonts.

 Note that this new information may differ from that which had been used
 the last time the listBox was saved, because the list of fonts installed
 in the system may have changed.  Depending on how clsListBox filed its
 entry data, this may lead to odd behavior.  The best approach is to use
 a LIST_BOX_STYLE.filing of lbFileMin so that clsListBox won't file any
 entry information or windows.  Because after msgRestore the value obtained
 via msgStrListBoxGetValue may no longer match any entry, clients should
 use msgStrListBoxSetValue to change the value to a short ID from the new
 list of installed fonts.
*/


/****************************************************************************
 msgSave	takes P_OBJ_SAVE, returns STATUS
	Causes an object to file itself in an object file.

 clsFontListBox responds by writing out its style values.
*/


/****************************************************************************
 msgStrListBoxGetValue			takes P_U32, returns STATUS
	Passes back the value of a string listbox.

 clsFontListBox responds by calling ancestor, converting the
 resulting IM_HANDLE *pArgs into the FIM_SHORT_ID via msgFIMGetId, and
 setting *pArgs to this short id.
*/


/****************************************************************************
 msgStrListBoxSetValue			takes U32, returns STATUS
	Sets the value of a string listbox whose role is one of slbRoleChoice*.

 clsFontListBox responds by converting the incoming pArgs from a
 FIM_SHORT_ID into the IM_HANDLE for the font (msgFIMFindId) and then
 calling ancestor with this new pArgs.
*/


/****************************************************************************
 msgStrListBoxProvideString			takes P_STRLB_PROVIDE, returns STATUS
	category: self-sent/client responsibility
	This message requests the client (or subclass) to provide a string.

 clsFontListBox first checks whether pArgs->position is >= the number of
 fonts described by its cached information.  If so, clsFontListBox returns
 stsFailed.

 Otherwise, clsFontListBox fills out pArgs->pString with the font name
 (obtained by using msgIMGetName and the IM_HANDLE pArgs->data) and
 returns stsOK.

 Return Value
	stsFailed:	pArgs->position >= number of fonts
*/


/****************************************************************************
 msgIMInstalled					takes P_IM_NOTIFY, returns STATUS
	category: observer notification
	A new item was installed.

 clsFontListBox responds by resynchronizing its entries with respect to
 the list of installed fonts, as is done in msgNew.
*/


/****************************************************************************
 msgIMDeinstalled				takes P_IM_DEINSTALL_NOTIFY, returns STATUS
	category: observer notification
	An item has been deinstalled.

 clsFontListBox responds by resynchronizing its entries with respect to
 the list of installed fonts, as is done in msgNew.
*/


#endif	// FONTLBOX_INCLUDED

