/****************************************************************************
 File: codemgr.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.42  $
   $Author:   rfoster  $
     $Date:   22 Feb 1992 15:34:46  $

 This file contains the API definition for clsCodeInstallMgr.
 clsCodeInstallMgr inherits from clsInstallMgr.
 Manages installation and deinstallation of code: applications and services.

 clsAppInstallMgr and clsServiceInstallMgr inherit from this class.

 The following superclass messages are not understood by clsCodeInstallMgr:
	-:  msgIMGetCurrent
	-:  msgIMSetCurrent
	-:  msgIMSetName
	-:  msgIMDup

 The following notification messages are not sent by clsCodeInstallMgr:
	-:  msgIMNameChanged
	-:  msgIMCurrentChanged

 See Also
	instlmgr.h
****************************************************************************/
#ifndef CODEMGR_INCLUDED
#define CODEMGR_INCLUDED

#ifndef INSTLMGR_INCLUDED
#include <instlmgr.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * 				  		Common #defines and typedefs  					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****  Status Codes  ****/

/* An application or service's name can be a max of nameBufLength - 4 chars. */
#define  stsCIMNameTooLong			 	MakeStatus(clsCodeInstallMgr, 0)

/****  Filesystem Attribute Definitions  ****/
/* 
 Note: Most clients do not deal with attributes directly. 
*/

/* Application or service class */
#define cimAttrClass				FSMakeFix32Attr(clsCodeInstallMgr, 0)

/* Application or service program handle */
#define cimAttrProgHandle			FSMakeFix32Attr(clsCodeInstallMgr, 1)

/* Application or service program well-known name */
#define cimAttrProgramName			FSMakeStrAttr(clsCodeInstallMgr, 2)

/*
 Should this app or service be seen in the installer? This determines 
 whether the user can configure and deinstall it.
*/ 
#define cimAttrDeinstallable	 	FSMakeFix32Attr(clsCodeInstallMgr, 4)
typedef enum CIM_ATTR_DEINSTALLABLE {
	cimDeinstallable	  = 0,	 // Same as no attribute
	cimNotDeinstallable	  = 1 
} CIM_ATTR_DEINSTALLABLE;

/* Dependent application list */
#define cimAttrAppList		  		FSMakeVarAttr(clsCodeInstallMgr, 6)

/* Dependent services list */
#define cimAttrServiceList 	  		FSMakeVarAttr(clsCodeInstallMgr, 7)

/*
 Common data structure used by msgCIMTerminateVetoed and
 msgCIMGetTerminateStatus.
*/
typedef struct CIM_TERMINATE_VETOED {
	IM_HANDLE		   	handle;		
	OBJECT				vetoer;	// Object that vetoed the terminate.
	STATUS				status;	// Veto status.
} CIM_TERMINATE_VETOED, *P_CIM_TERMINATE_VETOED;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * 				  				  	Messages  		  					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgCIMGetClassList				takes P_LIST, returns STATUS
	Passes back a list of the classes of the installed applications
	or services.

 CAUTION:
	 The caller must destroy the list object when it is finished using it.

 See Also
	msgIMGetList (instlmgr.h):		Returns a list of handles.

*/
#define msgCIMGetClassList	 				MakeMsg(clsCodeInstallMgr, 1)


/****************************************************************************
 msgCIMGetClass					takes P_CIM_GET_CLASS, returns STATUS
	Given a handle, passes back the class.

*/
#define msgCIMGetClass			 			MakeMsg(clsCodeInstallMgr, 2)

typedef struct CIM_GET_CLASS {
	IM_HANDLE			handle;	 // Handle to get class on.	
	CLASS				classId; // Out: class.	
} CIM_GET_CLASS, *P_CIM_GET_CLASS;


/****************************************************************************
 msgCIMFindClass				takes P_CIM_FIND_CLASS, returns STATUS
	Returns the handle which references the specified class.

 Return Value
	stsNoMatch:		No handle for this class was found.
*/
#define msgCIMFindClass		 				MakeMsg(clsCodeInstallMgr, 3)

typedef struct CIM_FIND_CLASS {
	CLASS				classId;	// Class to search for.
	IM_HANDLE	 		handle;		// Out: Resulting handle.
} CIM_FIND_CLASS, *P_CIM_FIND_CLASS;


/****************************************************************************
 msgCIMFindProgram					takes P_CIM_FIND_PROGRAM, returns STATUS
	Finds a item's handle, given its program name.

 Return Value
	stsNoMatch:			Item not found.
*/
#define msgCIMFindProgram	 					MakeMsg(clsCodeInstallMgr, 22)

typedef struct CIM_FIND_PROGRAM {
	P_STRING			pName;		// Program name to search for
	IM_HANDLE			handle;		// Out: Resulting handle
} CIM_FIND_PROGRAM, * P_CIM_FIND_PROGRAM;


/****************************************************************************
 msgCIMLoad					takes P_CIM_LOAD, returns STATUS
	category:  descendant responsibility
	Installs code for the item specified.

 This message is sent to subclasses to do the actual work of installing
 the item.  The working directory is set to the source.  pArgs->handle 
 references the deactivated item to load.
*/
#define msgCIMLoad				 			MakeMsg(clsCodeInstallMgr, 4)

typedef struct CIM_LOAD {
	IM_HANDLE		   	handle;	 // Handle of item to load.
} CIM_LOAD, *P_CIM_LOAD;


/****************************************************************************
 msgCIMTerminateOK			takes P_CIM_TERMINATE_OK, returns STATUS
	category:  descendant responsibility
	Is this item willing to be terminated?

*/
#define msgCIMTerminateOK		 			MakeMsg(clsCodeInstallMgr, 5)

typedef struct CIM_TERMINATE_OK {
	IM_HANDLE			handle;	// Item to ask.
	OBJECT				vetoer;	// Out: Object which vetoed the terminate.
} CIM_TERMINATE_OK, *P_CIM_TERMINATE_OK;


/****************************************************************************
 msgCIMTerminate			takes P_CIM_TERMINATE, returns STATUS
	category:  descendant responsibility
	Unconditionally terminate this item.
*/
#define msgCIMTerminate 					MakeMsg(clsCodeInstallMgr, 6)

typedef struct CIM_TERMINATE {
	IM_HANDLE			handle;		
} CIM_TERMINATE, *P_CIM_TERMINATE;


/****************************************************************************
 msgCIMTerminateVetoed			takes P_CIM_TERMINATE, returns STATUS
	category:  descendant responsibility
	Somebody vetoed the termination sequence.
*/
#define msgCIMTerminateVetoed  				MakeMsg(clsCodeInstallMgr, 7)


/****************************************************************************
 msgCIMGetTerminateStatus	takes P_CIM_TERMINATE_VETOED, returns STATUS
	Gets termination status of last item deinstalled.

 If there was and error then pArgs->vetoer is the object which caused the
 error; an application instance in the case of applications and a service
 instance in the case of services.  pArgs->status is the termination status.
*/
#define msgCIMGetTerminateStatus   			MakeMsg(clsCodeInstallMgr, 8)


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							Private Messages							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgCIMDoTerminateOK 		takes P_CIM_TERMINATE_OK, returns STATUS
	Propogates CIMTerminateOK.
*/
#define msgCIMDoTerminateOK 	   			MakeMsg(clsCodeInstallMgr, 20)


/****************************************************************************
 msgCIMDoTerminateVetoed	takes P_CIM_TERMINATE_VETOED, returns STATUS
	Propogates msgCIMTerminateVetoed.
*/
#define msgCIMDoTerminateVetoed    			MakeMsg(clsCodeInstallMgr, 21)

#endif	// CODEMGR_INCLUDED


