/****************************************************************************
 File: appimgr.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.47  $
   $Author:   rfoster  $
     $Date:   22 Feb 1992 15:34:42  $

 This file contains the API definition for clsAppInstallMgr.
 clsAppInstallMgr inherits from clsCodeInstallMgr.
 Manages installation and deinstallation of applications.

 There is a single instance of clsAppInstallMgr in the system; the 
 well-known uid theInstalledApps.

 theInstalledApps performs installation and deinstallation of applications
 and allows you to enumerate all of the applications that are currently
 installed.

 An application is a directory, usually located under \penpoint\app on
 a given filesystem volume.  The name of the directory is the name of the 
 application.  Within this directory is a .exe and zero or more .dlls that
 make up the application.  If a application includes .dlls there must also
 be a .dlc file which lists all the .dlls and the .exe.  The name of the
 .dlc file (or the name of the .exe file if there are no .dlls) must be
 the same as the name of the application.  If a application is called MAIL,
 for example, its .dlc file must be named MAIL.DLC.  You can use the
 STAMP.EXE utility to give an application an extended name.  Be sure
 to stamp the .dlc file as well.

 There can also be a service.ini and app.ini file in the application's
 directory.  These specify any additional services and applications that 
 should be installed when this application is installed.  These services 
 and applications are deinstalled when the application is deinstalled.
 If one of these services or applications is already installed it is
 reference counted, not installed again. 

 This directory also contains subdirectories which hold entries in the
 Help notebook (HELP), stationery (STATNRY), tools (ACCESSRY), and any 
 app-specific files that should be copied in when the app is installed (MISC).
 The application's resource file, app.res, is also in this directory.

 The application monitor is responsible for managing the installation of 
 these items.  When an app is installed its code is loaded and app.res is
 copied in.  The application monitor object is then created and completes
 the installation.  You can subclass the application monitor if you need 
 control over the installation process.  See appmon.h for details.

 An application is installed by sending msgIMInstall to theInstalledApps.
 Applications are installed under user control from the Applications card
 of the Settings Notebook.  \\boot\penpoint\boot\app.ini specifies
 applications that are automatically loaded when the system cold-boots.

 Each installed application has an application directory in the RAM 
 filesystem under \penpoint\sys\app.  For example, MAIL be in
 \penpoint\sys\app\MAIL.  The application resource file and the MISC directory
 are copied to this directory.

 Each installed application is represented by a handle, in a fashion similar
 to other install managers (see instlmgr.h).  This handle is a directory 
 handle onto the application's directory in the RAM filesystem.

 NOTE: THE MESSAGES IN THIS CLASS ARE SENT TO THE MANAGER, NOT TO 
 THE HANDLES.

 An application can be deinstalled.  Deinstallation removes all
 traces of an application.

 An application can be deinstalled even if there are running or filed
 instances of that application in the machine.  All running instances
 are shut down (saved, then terminated) when an application is removed.
 The application framework will use the Placeholder (MaskApp) class if
 it tries to start up document with a missing application.
 
 The following superclass messages are not understood by clsAppInstallMgr:
	-:  msgIMGetCurrent
	-:  msgIMSetCurrent
	-:  msgIMSetName
	-:  msgIMDup

 The following notification messages are not sent by clsAppInstallMgr:
	-:  msgIMNameChanged
	-:  msgIMCurrentChanged

 See Also
	-:  instlmgr.h
	-:  appmon.h

****************************************************************************/
#ifndef APPIMGR_INCLUDED
#define APPIMGR_INCLUDED

#ifndef CODEMGR_INCLUDED
#include <codemgr.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * 				  		Common #defines and typedefs  					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * 				  				  	Messages  		  					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNew						takes P_AIM_NEW, returns STATUS
	category: class message
	Creates a new application installation manager.

 There is only one instance of this class, theInstalledApps, in the system.
 Clients should never send msgNew.
*/

typedef struct AIM_NEW {
	installMgrNewFields
} AIM_NEW, *P_AIM_NEW;


/****************************************************************************
 msgAIMGetMaskClass 	 		takes P_CLASS, returns STATUS
	Passes back the mask class.

 The mask application class is used by the application framework when
 it tries to start up a document with an unavailable application.
*/
#define msgAIMGetMaskClass 					MakeMsg(clsAppInstallMgr, 6)


/****************************************************************************
 msgAIMSetMaskClass 	 		takes CLASS, returns STATUS
	Sets the mask class.

 The mask application class is used by the application framework when
 it tries to start up a document with an unavailable application.

 This message can be sent at any time; however, the new mask class will
 only be used for subsequent switches.
*/
#define msgAIMSetMaskClass 					MakeMsg(clsAppInstallMgr, 7)


#endif	// APPIMGR_INCLUDED


