*
**=====================================================**
*							*
*	XEBEC 1410 CONTROLLER FORMATTER			*
*	FOR USE WITH SEAGATE ST-506 5.25 DRIVE		*
*					[092784]	*
**=====================================================**
*
* SASI PORTS AND MASKS
*
UNIT	EQU	020H		;020H for second drive
XSTEP	EQU	1
DATA	EQU	0D8H		;SASI DATA
CONTROL	EQU	0D9H		;     CONTROL
*
CMDMSK	EQU	00100000B
BSYMSK	EQU	00000010B
REQMSK	EQU	10000000B
*
SEL	EQU	3
RESET	EQU	2
ON	EQU	00001000B
*
CR	EQU	0DH
LF	EQU	0AH
*
	ORG	0100H
*
*=============================*
*   INITIALIZATION ROUTINTES  *
*=============================*
*
START:	LXI	SP,STACK	;INIT STACK
	MVI	A,1		;SELECT CONTROLLER 1
	OUT	DATA
	MVI	A,RESET+ON	;RESET 
	OUT	CONTROL
	MVI	A,RESET
	OUT	CONTROL
	XRA	A
STARTW:	DCR	A
	JNZ	STARTW
*
*=============================*
*   DIAGNOSTIC TEST ROUTINES  *
*=============================*
*
* INIT DRIVE CHARACTERISTICS 
*
TEST3:	LXI	H,T3DCB
	CALL	CMDOUT		
	CALL	REQWAIT
	LXI	H,T35DCB
TEST35:	IN	CONTROL		
	ANI	CMDMSK
	JNZ	TEST36
	MOV	A,M
	OUT	DATA
	INX	H
	JMP	TEST35
TEST36:	CALL	GETSTAT
*
	MVI	A,50
	STA	SCOUNT
*	
* SEEK OUT
*
TEST4:	LXI	H,T4DCB
	CALL	CMDOUT
	CALL	GETSTAT
*
* SEEK IN 
*
	LXI	H,T8DCB		;RECALIBRATE
	CALL	CMDOUT
	CALL	GETSTAT
	LDA	SCOUNT
	DCR	A
	STA	SCOUNT
	JNZ	TEST4
	JMP	0
*
* COMMAND CONTROL BLOCKS
*
T3DCB	DB	00CH,UNIT,0,0,0,000H
T35DCB	DB	000H,099H	;NUMBER OF CYLINDERS
	DB	004H		;NUMBER OF HEADS
	DB	000H,080H	;CYL TO REDUCE WRITE CURRENT
	DB	000H,040H	;CYL TO WRITE PRECOMP
	DB	00BH		;ERROR BURST LENGTH

T4DCB	DB	00BH,UNIT,028H,090H,0,XSTEP

T8DCB	DB	00BH,UNIT,0,0,0,XSTEP 
*
*=============================*
*   SASI INTERFACE ROUTINES   *
*=============================*
*
* OUTPUT COMMAND
*
CMDOUT:	CALL	SELCTLR
	CALL	REQWAIT
	MVI	B,6
CMDOU1:	MOV	A,M
	OUT	DATA
	INX	H
	DCR	B
	JNZ	CMDOU1
	RET
*
* SELECT CONTROLLER
*
SELCTLR:IN	CONTROL		;WAIT CONTROLLER NOT BUSY
	ANI	BSYMSK
	JNZ	SELCTLR
	MVI	A,1		;SELECT XEBEC CTLR # 1
	OUT	DATA
	MVI	A,SEL+ON
	OUT	CONTROL
	XRI	ON
	OUT	CONTROL
SELC1:	IN	CONTROL		;WAIT CONTROLLER BUSY
	ANI	BSYMSK	
	JZ	SELC1
	RET
*
* GET CONTROLLER STATUS BYTES
*
GETSTAT:CALL	REQWAIT
	IN	DATA		;READ FIRST COMPLETION BYTE
	MOV	B,A
	CALL	REQWAIT
	IN	DATA		;READ SECOND COMPLETION BYTE
	MOV	A,B
	ANI	002H
	CNZ	ERROR
	CALL	BREAK
	RET
*
* WAIT FOR REQUEST ACTIVE FROM CONTROLLER
*
REQWAIT:IN	CONTROL
	ANI	REQMSK
	RNZ
	JMP	REQWAIT
*
* CONSOLE BREAK
*
BREAK:	MVI	C,11
	CALL	0005H
	ORA	A
	RZ
	MVI	C,1
	CALL	0005H
	LXI	H,BRKMSG
	CALL	PTXT
	MVI	C,1
	CALL	0005H
	PUSH	PSW
	CALL	CRLF
	POP	PSW
	CPI	'Y'
	JZ	BREAK1
	CPI	'y'
	RNZ
BREAK1:	JMP	0
*
BRKMSG	DB	'  USER BREAK? (Y/N) ',0
*
* READ SENSE BYTES 
*
READS:	LXI	H,RSSDCB
	CALL	CMDOUT		;READ-SENSE-STATUS COMMAND
	CALL	REQWAIT
	LXI	H,ERRBUF
	MVI	B,4
READS1:	IN	DATA
	MOV	M,A
	INX	H
	DCR	B
	JNZ	READS1
	CALL	GETSTAT
	RET
*
RSSDCB	DB	003H,0,0,0,0,000H
*
*=============================*
*   ERROR HANDLING ROUTINES   *
*=============================*
*
ERROR:	LXI	H,ERRMSG
	CALL	PTXT		
	CALL	READS		;READ SENSE BYTES
	LDA	ERRBUF
	CALL	PUTHEX
	LDA	ERRBUF+1
	CALL	PUTHEX
	LDA	ERRBUF+2
	CALL	PUTHEX
	LDA	ERRBUF+3
	CALL	PUTHEX
	RET
*
ERRMSG	DB	CR,LF,'  ** SASI ERROR: ',0
*
* PRINT HEX NUMBER IN A-REG FOLLOWED BY '.'
*
PUTHEX:	PUSH	PSW
	RRC ! RRC ! RRC ! RRC
	CALL	PNYBBL		;PRINT HIGH NYBBLE OF HEX BYTE
	POP	PSW
	CALL	PNYBBL		;PRINT LOW NYBBLE OF HEX BYTE
	MVI	E,'.'
	CALL	OUTC		;PRINT DELIMITER CHARACTER @HL
	RET
*
* PRINT NIBBLE
*
PNYBBL:	ANI	00FH
	ADI	090H
	DAA
	ACI	040H
	DAA
	MOV	E,A
	CALL	OUTC
	RET
*
* OUTPUT CHARACTER
*
OUTC:	PUSH	H
	PUSH	D
	PUSH	B
	MVI	C,2
	CALL	0005H		;BDOS
	POP	B
	POP	D
	POP	H
	RET
*
* NEWLINE
*
CRLF	MVI	E,CR
	CALL	OUTC
	MVI	E,LF
	CALL	OUTC
	RET
*
* OUTPUT TEXT
*
PTXT:	MOV	A,M
	ORA	A
	RZ
	MOV	E,A
	CALL	OUTC
	INX	H
	JMP	PTXT
*
*=============================*
*   DATA AND STACK AREA       *
*=============================*
*
ERRBUF	DB	0,0,0,0		;ADDRESS ERROR BYTES
SCOUNT	DB	0
*
	DS	64
STACK	DS	0
*
	END

