/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xasyncio.c,v 1.2 87/04/24 16:49:06 davidb Exp $ */
/*
$Header: xasyncio.c,v 1.2 87/04/24 16:49:06 davidb Exp $
 /* Revision 1.1  86/10/08  14:18:20  mark
 * merging in new ftp
 * 
 * Revision 1.2  86/09/04  20:42:51  mark
 * Updating source from Generic trees
 * 
 * Revision 1.2  86/08/25  17:49:50  mark
 * syncing revision level
 * 
 * Revision 1.1  86/04/18  18:58:13  mark
 * Initial revision
 * 
*/

#include <xstdio.h>
#include <xerrno.h>
#include <ex_errno.h>	/* Contains constants used by XMAPERRNO(). */
#include <UnixXos.h>	/* Contains XMAPERRNO(). dab 861219. */
#include <sys/socket.h>
#include <signal.h>

#ifdef BSD4dot2
#define SIGASYNC SIGIO
#else /* BSD4dot2 */
#define SIGASYNC SIGCLD
#endif /* BSD4dot2 */

static int (*whd_array[ _XNFILE ])() = { 0 };
static int (*rhd_array[ _XNFILE ])() = { 0 };
static long wasync_bits = 0;
static long rasync_bits = 0;
static int max_od = 0;
static int fdmap[32] = { 0 };

extern int errno;

static
dispatch()
{
	static int n = 0;
	long readbits;
	long writebits;
	int instance;
	static int entered = 0;
	int	od;	/* current socket */
	int	i;

	instance = entered++;
	if (n > 0) {
		entered--;
		return;
	}
	for (;;) {
		signal(SIGASYNC, dispatch);
	doselect:
		readbits = rasync_bits;
		writebits = wasync_bits;
		n = select(32, &readbits, &writebits, 0L);
		if (n <= 0) {
			if (n == 0)
				break;
			n = XMAPERRNO(errno);
			if (n == XEINTR )
				goto doselect;
			xperror(n,"dispatch");
		}
		signal(SIGASYNC, SIG_IGN);
		for( od =0 ; od < max_od ; ++od ) {
			if( readbits & ( 1 << od ) ) {
				/* 
				call handler for socket
				*/
				(*rhd_array[od])( fdmap[od] );
			}
		}
		for( od =0 ; od < max_od ; ++od ) {
			if( writebits & ( 1 << od ) ) {
				/* 
				call handler for socket
				*/
				(*whd_array[od])( fdmap[od] );
			}
		}
	}
	entered--;
}


xsetasync( od, handler, flags )
	int od;		/* EXOS object descriptor for socket */
	int (*handler)( /* od */);	/* routine to execute
					0 == turn off notification
					*/
	int flags;	/* 1 == allow notification for writes,
			   2 == allow notification for reads
			   */
{
	int rval;
	long od_bit;
	int fd;

	/*
	check that od is valid
	*/
	if( od >= 0 && od < _XNFILE && (_xiob[od]._flag & _XUsed) ) {
		fd = getfd( od );
		if( fd < 0 ) {
			xperror( fd, "getfd" );
			return( fd );
		}
		od_bit = 1 << fd;
		fdmap[fd] = od;
		if( max_od <= fd )
			max_od = fd + 1;
		if( handler ) {
			if( flags & 1 ) {
				whd_array[fd] = handler;
				wasync_bits |= od_bit;
			}
			if( flags & 2 ) {
				rhd_array[fd] = handler;
				rasync_bits |= od_bit;
			}
			asyncio( max_od, wasync_bits | rasync_bits, SIGASYNC );
			dispatch();
		} else {
			if( flags & 1 ) {
				whd_array[fd] = handler;
				wasync_bits &= ~od_bit;
			}
			if( flags & 2 ) {
				rhd_array[fd] = handler;
				rasync_bits &= ~od_bit;
			}
			if( rasync_bits | wasync_bits ) {
				/*
				There's still something to do.
				*/
			} else {
				signal( SIGASYNC, SIG_DFL );
			}
		}
		rval = 0;
	}
	return ( rval );
}

xblkasync()
{
	signal( SIGASYNC, SIG_IGN );
}

xublkasync()
{
	dispatch();
}
