/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xtelwrite.c,v 1.4 87/04/24 16:47:43 davidb Exp $ */


/*
$Header: xtelwrite.c,v 1.4 87/04/24 16:47:43 davidb Exp $
$Log:	xtelwrite.c,v $
 * Revision 1.4  87/04/24  16:47:43  davidb
 * Fixing copyright message
 * 
 * Revision 1.3  87/03/26  19:40:23  grant
 * Updating source from Generic trees
 * 
 * Revision 1.3  87/01/19  16:51:44  grant
 * davidbs's cleanup. header stuff.
 * 
 * Revision 1.7  86/12/19  18:00:46  davidb
 * Updating source from Generic trees
 * 
 * Revision 1.3  86/11/05  08:28:06  alexl
 * Updating source from Generic trees
 * 
 * Revision 1.2  86/11/03  17:33:33  mark
 * do telnet processing even when we aren't looking for an escape
 * character.
 * 
 * Revision 1.2  86/10/28  17:47:11  alexl
 * Updating source from Generic trees
 * 
 * Revision 1.1  86/10/08  10:51:20  mark
 * merging in changes for new ftp
 * 
 * Revision 1.3  86/09/19  10:20:57  albert
 * allow use of Excelan's standard include file specification.
 * 
 * Revision 1.2  86/09/10  10:53:02  albert
 * Use Excelan's standard style of include specification.
 * 
 * Revision 1.1  86/09/04  16:19:36  albert
 * first working version
 * 
 * Revision 1.2  86/08/25  17:47:44  mark
 * syncing revision level
 * 
 * Revision 1.1  86/04/18  19:13:14  mark
 * Initial revision
 * 
*/
#ifdef	vms
#include "h_xlib/xstdio.h"
#include "h_xlib/xerrno.h"
#include "h_xlib/telnet.h"
#else	/* vms */
#include <xstdio.h>
#include <xerrno.h>
#include <xtelnet.h> 	/* Xlib specific stuff. Used to be in */
#include <arpa/telnet.h> /* include/EXOS/telnet.h. dab 861125. */
#endif	/* vms */

xtelwrite( sys_id, buf, len )
struct tel_state *sys_id;
char *buf;
int len;
{
	int cnt;
	int cnt2;
	char *backpt = buf;
	register char *frontpt = buf;
	int c;
	int rval = 0;	/* what to return to the user */
	int mask;
	int escape;

	if( !sys_id )
		return( XEBADF );
	if( sys_id->write_state ) {
		/*
		An error occured on previous write after we had written
		some data.
		So, we return the error now,
		having returned the amount of data written previously.
		*/
		rval = sys_id->write_state;
		sys_id->write_state = 0;
		return( rval );
	}
	/*
	If no escape processing is to be done, we still do telnet
	processing, but set the escape value to a character that cann't exist.
	ie. > 255
	*/
	mask = ( sys_id->his_opts[ TELOPT_BINARY ] )? 0xff : 0x7f;
	escape = ( sys_id->escape )? sys_id->escape & 0xff : 1000; 
	if( escape ) {
		cnt = 0;
		while (cnt < len) {
			c = *frontpt++ & mask;
			cnt++;
			if( escape == c ) {
				(*sys_id->esc_action)( sys_id );
				if( cnt > 1 ) {
					cnt2 =
					   xwrite( sys_id->od, backpt, cnt-1 );
					if( cnt2 < 0 ) {
						if( rval > 0 ) {
							sys_id->write_state =
								cnt2;
							return( rval );
						} else {
							return( cnt2 );
						}
					}
				}
				backpt = frontpt;
				len -= cnt;
				rval += cnt;
				cnt = 0;
			} else if ( c == '\n' &&
				!sys_id->his_opts[TELOPT_BINARY] ) {
				/*
				expand lf to <cr><lf>.
				*/
				cnt2 = xwrite( sys_id->od, backpt, cnt-1 );
				if( cnt2 < 0 ) {
					if( rval > 0 ) {
						sys_id->write_state =
							cnt2;
						return( rval );
					} else {
						return( cnt2 );
					}
				}
				rval += cnt - 1;
				cnt2 = xwrite( sys_id->od, "\r\n", 2 );
				if( cnt2 < 0 ) {
					if( rval > 0 ) {
						sys_id->write_state =
							cnt2;
						return( rval );
					} else {
						return( cnt2 );
					}
				}
				backpt = frontpt;
				len -= cnt;
				rval += 1;
				cnt = 0;
			}
		}
	}
	if ( len > 0 ) {
		cnt = xwrite( sys_id->od, backpt, len );
		if( cnt < 0 ) {
			if( rval > 0 ) {
				sys_id->write_state = cnt;
				return( rval );
			} else {
				return( cnt );
			}
		}
		rval += cnt;
	}
	return( rval );
}
