/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xstretc.c,v 1.2 87/04/24 16:46:32 davidb Exp $ */
/*
 * @(#)xstretc.c	1.7 6/5/85
 * GENERIC LIBRARY
 *
 * filename: XSTRETC.C
 */

#include "xgenlib.h"


/*
 * XSTRLEN: return the size of the string
 */

int xstrlen( s )
  char *s;
  {
   char *p = s;

   while ( *p != '\0' ) p++;
   return ( p-s );
  }

/*
 * XSTRCPY: copy string 2 to string 1
 */

xstrcpy( s, t)
  char *s, *t;
  {
    while ( *s++ = *t++ );
  }

/*
 * XSTRNCPY: copy a string into a buffer n characters in length
 */

char *xstrncpy( s, t, n)
  char *s, *t;
  int n;
  {
   char *cp;

   for ( cp = s; n && ( *cp++ = *t++ ); --n );
   while ( n-- )
     *cp++ = '\0';
   return ( s );
  }

     
/*
 * XSTRCMP: compare strings and return -ve, 0 or +ve accordingly
 */	

int xstrcmp( s, t)  /* return <0 if s<t, 0 if s==t, >0 if s>t */
  char *s, *t;
  {
   for ( ; *s == *t; s++, t++ )
     if ( *s == '\0' )
       return ( 0 );
   return ( *s - *t );
  }

/*
 * XSTRICMP: case insensitive string comparision
 */

int xstricmp( s, t)
  char *s, *t;
  {
   for ( ; _tolower(*s) == _tolower(*t); s++, t++ )
     if ( *s == '\0' )
       return ( 0 );
   return ( _tolower(*s) - _tolower(*t) );
  }


/*
 * XSTRNCMP: string compare up to n characters
 */

int xstrncmp( s, t, n)
  char *s, *t;
  int n;
  {
   for ( ; n-- && ( *s == *t ); t++ ) 
     if ( !*s++ )
       return ( 0 );
   if ( n < 0 )
     return ( 0 );
   if ( *s < *t )
     return ( -1 );
   return ( 1 );
  }
     
/*
 * XSTRCAT: concatenates string 2 to the end of string 1
 */

int xstrcat( s, t )
  char *s, *t;
  {
   while ( *s++ != '\0' );
   for ( --s; (*s++ = *t++) != '\0'; );
  }


/*
 * XSTRNCAT: concatenate string 2 to string 1 , max n chars
 */

char *xstrncat( s, t, n)
  char *s, *t;
  int n;
  {
    char *cp;

    for ( cp = s; *cp++; );
    for ( --cp; --n && ( *cp++ = *t++ ); ) ;
    *cp = '\0';
    return s;
   }


/*
 * XSTRCHR: return c pointer to first occurance of character
 */

char *xstrchr( s, c)
  char *s, c;
  {
   while ( *s )
     if ( *s++ == c )
       return --s;
   if( c == '\0' )
	return( s );
   return ( 0 );
  }

/*
 * XSTRRCHR: return a pointer to the last occurance of char
 */

char *xstrrchr( s, c)
  char *s, c;
  {
   char *cp;

   for ( cp = s + xstrlen(s); --cp >= s; )
     if ( *cp == c )
       return cp;
   return 0;
  }

int
xbcopy( src, dest, n )
	register char *src;
	register char *dest;
	register int n;
{

	for( ; n > 0 ; --n ){
		*dest++ = *src++;
	}
	return( n );
}



xbzero (what, size)
register char *what;
register int size;
{
	while (size-- > 0)
		*what++ = 0;
}
