/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xgetaddr.c,v 1.4 87/04/24 16:17:04 davidb Exp $ */
/*
$Header: xgetaddr.c,v 1.4 87/04/24 16:17:04 davidb Exp $
$Log:	xgetaddr.c,v $
 * Revision 1.4  87/04/24  16:17:04  davidb
 * Fixing copyright message
 * 
 * Revision 1.3  87/03/26  19:37:14  grant
 * Updating source from Generic trees
 * 
 * Revision 1.3  86/10/15  18:09:47  mark
 * return better error code
 * 
 * Revision 1.2  86/10/15  15:55:48  albert
 * allow application to set port number for a service.
 * 
 * Revision 2.2  86/10/15  09:35:35  albert
 * add in provision for user to set the port number for a protocol and service.
 * 
 * Revision 2.1  86/10/09  15:06:13  albert
 * Updating source from Generic trees
 * 
 * Revision 1.1  86/10/08  10:44:53  mark
 * merging in changes for new ftp
 * 
 * Revision 1.2  86/09/04  20:40:48  mark
 * Updating source from Generic trees
 * 
 * Revision 1.2  86/08/25  17:33:09  mark
 * syncing revision level
 * 
 * Revision 1.1  86/04/18  19:10:27  mark
 * Initial revision
 * 
*/

/*
$Implementation:
	For port lookup, we use a data structure called portbank that
stores the port number according to protocol and service.  A private
routine lookup_port is provided to look up the port number from the 
data base.  

	An export routine, xsetport() is provided for application layer
to define the port to be used for a certain service and port.
$
*/

#include "elib.h"

struct portbank {
	int	port_service;		/* service */
	int	port_protocol;		/* protocol used */
	int	port_no;		/* corresponding port no. in host rep.*/
	};

static struct portbank	ports[] = {
	{ XFILE_SERVICE, FTP, IPPORT_FTP},
	{ 0, 0, 0}};

extern long xrhost();

static	int lookup_port(service, protocol)
int	service;		/* service	*/
int	protocol;		/* protocol	*/
{
struct	portbank	*portptr;

	portptr = ports;
	while (portptr->port_service) {
		if ((portptr->port_service == service) &&
		    (portptr->port_protocol == protocol))
			return (portptr->port_no);
		portptr++;
	};
	return (XEPFNOSUPPORT);	/* no support */
}

extern int xsetport(service, protocol, port)
int	service;		/* service	*/
int	protocol;		/* protocol	*/
int	port;			/* port		*/
{	/* set a new port number for service and protocol specified */

struct	portbank	*portptr;

	portptr = ports;
	while (portptr->port_service) {
		if ((portptr->port_service == service) &&
		    (portptr->port_protocol == protocol)) {
			portptr->port_no = port;
			return (0);
		};
		portptr++;
	};
	return (XEPFNOSUPPORT);	/* no support */
}

xgetaddr( service, protocol, system, addr )
	int service;
	int protocol;
	char **system;
	struct sockaddr *addr;
{
	int rval;
	int port;

	switch( service ) {
		case XFILE_SERVICE:
			switch( protocol ) {
				case FTP:
					{
					struct sockaddr_in *in_addr;

					in_addr = (struct sockaddr_in *)addr;
					in_addr->sin_family = AF_INET;
					port = lookup_port(XFILE_SERVICE, FTP);
					if (port == XEPFNOSUPPORT)
						return port;
					in_addr->sin_port = xhtons(port);
					in_addr->sin_addr.s_addr =
						xrhost( system );
					if( in_addr->sin_addr.s_addr == -1 ) {
						rval = XEHOSTUNKNOWN;
					} else {
						rval = 0;
					}
					break;
					}
				default:
					rval = XEPFNOSUPPORT;
					break;
			}
			break;
		default:
			rval = XEPFNOSUPPORT;
			break;
	}
	return( rval );
}
