/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xatoi.c,v 1.2 87/04/24 16:13:24 davidb Exp $ */
/*
@(#)xatoi.c	1.3 3/29/85

Xatoi(3X).
states for parsing numbers of different radii.
*/
#include "xgenlib.h"

#define START_ST 1
#define ZERO_ST 2
#define OCTAL_ST 3
#define DECIMAL_ST 4
#define HEX_ST 5
#define ACCEPT_ST 6
#define DONE_ST 7
#define MINUS_ST 8

xatoi( a )
	char *a;
{
int i, o;
int minus;
int state;
char *ch = a;

/*
and the numbers may be in either decimal or
hexadecimal (or octal).
*/

state = START_ST;
minus = 0;
o = 0;
for( ; state != DONE_ST ; ++ch )
	{
	switch ( state ) {
		case START_ST:
			if( '0' == *ch )
				{
				state = ZERO_ST;
				}
			else if( '1' <= *ch &&
				'9' >= *ch )
				{
				state = DECIMAL_ST;
				o = *ch - '0';
				}
			else if( *ch == ' ' || *ch == '\t' )
				{
				}
			else if( *ch == '-' )
				{
				minus = 1;
				state = MINUS_ST;
				}
			else
				{
				state = DONE_ST;
				}
			break;
		case MINUS_ST:
			if( '0' == *ch )
				{
				state = ZERO_ST;
				}
			else if( '1' <= *ch &&
				'9' >= *ch )
				{
				state = DECIMAL_ST;
				o = *ch - '0';
				}
			else
				{
				state = DONE_ST;
				}
			break;
		case ZERO_ST:
			if( 'x' == *ch )
				{
				state = HEX_ST;
				}
			else if( '0' <= *ch &&
				'7' >= *ch )
				{
				state = OCTAL_ST;
				o = *ch - '0';
				}
			else
				{
				state = DONE_ST;
				o = 0;
				}
			break;
		case OCTAL_ST:
			if( '0' <= *ch &&
				'7' >= *ch )
				{
				o *= 8;
				o += *ch - '0';
				}
			else
				{
				state = DONE_ST;
				}
			break;
		case DECIMAL_ST:
			if( '0' <= *ch &&
				'9' >= *ch )
				{
				o *= 10;
				o += *ch - '0';
				}
			else
				{
				state = DONE_ST;
				}
			break;
		case HEX_ST:
			if( '0' <= *ch &&
				'9' >= *ch )
				{
				o *= 16;
				o += *ch - '0';
				}
			else if( 'a' <= *ch &&
				'f' >= *ch )
				{
				o *= 16;
				o +=(*ch - 'a') + 10;
				}
			else if( 'A' <= *ch &&
				'F' >= *ch )
				{
				o *= 16;
				o +=(*ch - 'A') + 10;
				}
			else
				{
				state = DONE_ST;
				}
			break;
		default:
			xperror( XSYSERR, "xatoi" );
			xexit( 1 );
			break;
		}  /* switch */
	} /* for state != DONE  */
if( minus )
	{
	o = -o;
	}
return( o );
}
