/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: _xflsbuf.c,v 1.2 87/04/24 16:09:36 davidb Exp $ */
/*
@(#)_xflsbuf.c	1.6 5/22/85

System independent routine for filling io buffers.
( used to implement xputc ).
*/
#include "xgenlib.h"

_xflsbf( x, file )

unsigned int x;
register XFILE *file;
{
int rval;
int nmtowrite;
int storex;
char xch;
char *pt;

if( !(file->_flag & _XUsed) )
	return( XEBADF );
if( !(file->_flag & _XIOWRT ) )
	return( XEBADF );
if( file->_flag & _XIOERR )
	{
	/*
	 * Allow user to retry after an error.
	 */
	 file->_flag &= ~_XIOERR;
	 }
if( file->_base )
	{
	storex = 1;		/* put x in buffer after flush */
	pt = file->_base;
	/*
	Check for line buffering
	*/
	if( file->_flag & _XIOLBF )
		{
		nmtowrite = (int)(file->_ptr - file->_base);
		if( nmtowrite >= file->_bufsiz )
			{
			/*
			flush buffer, because it is full.
			*/
			}
		else if( x == '\n' || x == '\r' )
			{
			/*
			flush buffer, because of end of line
			*/
			storex = 0;
			*(file)->_ptr++ = x;
			++nmtowrite;
			}
		else
			{
			*(file)->_ptr++ = x;
			file->_cnt = 0;
			return( 0 );
			}
		}
	else
		{
		nmtowrite = file->_bufsiz - ( file->_cnt + 1 );
		}
	while ( nmtowrite > 0 )
		{
		rval = xwrite( xfileno(file), pt, nmtowrite );
		if( rval < 0 )
			{
			file->_flag |= _XIOERR;
			return( rval );
			}
		if( rval == 0 )
			{
			file->_flag |= _XIOERR;
			return( XEIO );
			}
		nmtowrite -= rval;		/* Assert: rval <= nmtowrite */
		pt += rval;
		}
	if( file->_flag & _XIOLBF )
		{
		if( storex && ( x == '\n' || x == '\r' ) )
			{
			/*
			write out carriage return
			*/
			xch = x;
			rval = xwrite( xfileno(file), &xch, 1 );
			storex = 0;
			if( rval < 0 )
				return( rval );
			}
		file->_cnt = 0;
		}
	else
		file->_cnt = file->_bufsiz - 1;	/* _cnt == #chars remaining,
							-1 for "x" */
	if ( file->_cnt < 0 )
		{
		/*
		This should not happen.
		*/
		return( XEFAULT );
		}
	file->_ptr = file->_base;
	if( storex )
		*file->_ptr++ = x;
	}
else
	{
	xch = x;
	rval = xwrite( xfileno(file), &xch, 1 );
	if( rval < 0 )
		{
		file->_flag |= _XIOERR;
		return( rval );
		}
	if( rval != 1 )
		{
		file->_flag |= _XIOERR;
		return( XEIO );
		}
	file->_cnt = 0;
	}
return( 0 );
}
