/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: bstat.c,v 1.2 87/04/24 15:22:31 davidb Exp $ */


/*
 * @(#)bstat.c	1.8 7/3/85
 *
 * filename: BSTAT.C
 */

#include "bstat.h"

char 	usage[]="usage: bstat [-b n] [-r] [-v] \n";
struct EXbdstats stats = {0};

xmain(argc, argv)
    int argc;
    char *argv[];
{
    int boardno = 0;		/* board number	*/
    register int exos = -1 ;
    register char *ap;
    register int an;
    int rval;


    if ((argc >= 3) && (xstricmp(argv[1], "-b") == 0)) { /* board number specified	*/
	boardno = xatoi(argv[2]);
	argv += 2;
	argc -= 2;
    };

    if (argc > 3) {
	    xoprintf(xstderr, usage);
	    goto error;
    };

    if ((exos = xbrdopen( boardno, 3)) < 0) {
	    xperror(exos, DEV);
	    goto error;
    }
    if (argc == 1) {
	if ((rval = xioctl(exos, BRDGSTAT, &stats)) < 0) {
	    xoprintf(xstdout, "%s: stats failed\n", argv[0]);
	    xperror( rval, "reason" );
	    goto error;
	}
	stat();
	xexit(0);
    }
    for (an =1; an < argc && *(ap = argv[an]) == '-'; ++an)
	switch(*++ap) {
	case 'r':
		if ((rval = xioctl(exos, BRDRSSTAT, &stats)) < 0) {
		    xoprintf(xstdout, "%s: stats failed\n",argv[0]);
		    xperror( rval, "reason" );
		    goto error;
		    }
		stat();
		break;
	case 'v':
		if ((rval = xioctl(exos, BRDGSTAT, &stats)) < 0) {
		    xoprintf(xstdout, "%s: stats failed\n", argv[0]);
		    xperror( rval, "reason" );
		    goto error;
		    }
		ver();
	        break;  
	default:
		xoprintf(xstderr, usage);
		    goto error;
	    }
     xclose(exos);
     xexit(0);
error:
     xclose(exos);
     xexit(-1);
}
stat()
{
    if (stats.xmt) 
	xoprintf(xstdout, "%8D frames successfully transmitted\n",
		stats.xmt);
    if (stats.excess_coll) 
	xoprintf(xstdout,
		"%8D transmissions aborted due to excess collisions\n",
		stats.excess_coll);
    /*
     * GAP 6/19/85: These two stats are defined only for the 200 series.
     */
    if ( (stats.late_coll) && (((char *)(&stats.fw_release))[0] & 0xff)>='4' )
	xoprintf(xstdout, "%8D SQE (transceiver heartbeat) test failures\n",
		stats.late_coll);
    if ( (stats.tdr) && (((char *)(&stats.fw_release))[0] & 0xff)>='4' )
	xoprintf(xstdout, "%8D transmissions failed with DMA underrun\n",
		stats.tdr);

    if (stats.rcv)
	xoprintf(xstdout, "%8D frames successfully received\n",
		stats.rcv);
    if (stats.align_err)
	xoprintf(xstdout, "%8D frames received with alignment errors\n",
		stats.align_err);
    if (stats.crc_err)
	xoprintf(xstdout, "%8D frames received with CRC errors\n",
		stats.crc_err);
    if (stats.lost_err)
	xoprintf(xstdout, "%8D frames lost (no receive buffers)\n",
		stats.lost_err);
}
ver()
{
    int fw, hw;

    xoprintf(xstdout, "\n");
    xoprintf(xstdout, "EXOS:Firmware Release:%c.%c\n",
              ((char *)(&stats.fw_release))[0] & 0xff,
	      ((char *)(&stats.fw_release))[1] & 0xff);
    xoprintf(xstdout, "EXOS:Hardware Release:%c.%c\n",
              ((char *)(&stats.hw_release))[0] & 0xff,
	      ((char *)(&stats.hw_release))[1] & 0xff);
    xoprintf(xstdout, "EXOS:Software Release:%c.%c\n",
              ((char *)(&stats.sw_release))[0] & 0xff,
	      ((char *)(&stats.sw_release))[1] & 0xff);
    
    /* check for incompatibility */

    fw = (((char *)(&stats.fw_release))[0]  & 0xff) - '0';
    hw = (((char *)(&stats.hw_release))[0]  & 0xff) - '0';
    if ((fw <= 3) && (hw <= 3)) {
	    
	/* indicate that user MUST use version 1 xceiver */

	xoprintf(xstdout, "WARNING: With a EXOS 101 board (Rev 1,2,3)");
	xoprintf(xstdout, "you MUST use Version 1 transceiver\n");
    }
}
 
 
clientinit()
{
 /* dummy */
}
 
