/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: rwhod.c,v 1.2 87/04/24 15:19:28 davidb Exp $ */
static char sccsId[] = "@(#)rwhod.c	1.12 8/29/85";

/*
 * Remote who daemon
 */
#ifdef scoxenix5
#include <sys/types.h>
#include <sys/param.h>
#else
#ifdef tower
#include <sys/param.h>
#include <sys/types.h>
#else
#if (xenix286 || zilog)
#include <sys/param.h>
#else
#include <sys/types.h>
#endif
#endif
#endif	/* /* */

#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/file.h>

#ifdef BSD4dot2
#include <nlist.h>
#define	NLIST	nlist
#else
#ifdef zilog
#include <nlist.h>
#define	NLIST	nlist
#define	n_value	nl_value
#else
#ifdef S5vax750
#include <nlist.h>
#define	NLIST	nlist
#else
#ifdef tower
#include <nlist.h>
#define	NLIST	nlist
#else
#include <a.out.h>
#define	NLIST	nlist
#endif
#endif
#endif
#endif


#if ( SYSTEM3 || SYSTEM5 )
#ifndef zilog
#include <sys/var.h>
#endif
#endif

#include <stdio.h>
#include <signal.h>
#include <errno.h>
#include <utmp.h>
#include <ctype.h>
#include "rwhod.h"
#include <sys/extypes.h>	/* Defines u_long, etc., used by if.h.
				   dab 861125. */
#include <net/if.h>
#include <netinet/in.h>
#define TICKS
/*#include <sys/swap.h>*/
#undef TICKS

/* load average magic for unisoft ports */
#if UNISOFT
#define	fxtod(i)	(((double)(i))/1024.0)
#endif
#define	RWHODIR		"/usr/spool/rwho"

#ifdef zilog
#define KNAME		"/zeus"
#else
#ifdef xenix286
#define KNAME		"/xenix"
#else
#ifdef BSD4dot2
#define KNAME		"/vmunix"
#else
#define KNAME		"/unix"
#endif
#endif
#endif

#ifdef tower
#define ROOTDEVSTR "rootdev"
#else
#define ROOTDEVSTR "_rootdev"
#endif

#define	INFINITY	((long)10000000)
#define	SIZE_DK_TIME	32

struct	NLIST nl[] = {
#define	NL_ROOTDEV	0		/* something everyone has */
	{ ROOTDEVSTR },
#define	NL_AVENRUN	1
	{ "_avenrun" },
#define	NL_TIME		2
	{ "_time" },
#define	NL_LBOLT	3
	{ "_lbolt" },
#define	NL_DK_TIME	4
	{ "_dk_time" },
#define	NL_HZ		5
	{ "_hz" },
	{ "" }
};

struct	sockaddr_in sin = { AF_INET, IPPORT_WHOSERVER };
struct	whod mywd;
int	utmpf, s, uptmptime, kmemf = -1;
char	myname[32], unixname[32];
time_t	uptime;
int	getkmem(), onalrm();
long	in_netof();
extern	int errno;
extern	long time();
#define	WHDRSIZE	(sizeof(mywd) - sizeof(mywd.wd_we))

main(argc, argv)
	int argc;
	char *argv[];
{
	struct sockaddr_in from;
	long host_addr, rhost();
	char *host_name;
	int pid;

	(void) signal(SIGHUP, getkmem);
#ifndef	DEBUG
	if (fork())
		exit(0);
#endif
	signal( SIGTERM, SIG_IGN );
	signal( SIGQUIT, SIG_IGN );
	signal( SIGINT, SIG_IGN );

	if (argc > 1)
		strcpy(unixname, argv[1]);
	else
		sprintf(unixname, KNAME );

    /* for determining idle time... */
	(void) chdir("/dev");

    /* get local network information */
	if (gethostname(myname, sizeof(myname)-1)) {
		experror("rwhod: gethostname");
		exit(1);
	}
	host_name = myname;
	host_addr = rhost(&host_name);
	if (host_addr != -1)
		sin.sin_addr.s_addr = host_addr;
	else {
		fprintf(stderr, "%s: unknown host\n", myname);
		exit(1);
	}

	/* billn -- get network part of addr.  4.2 does it better. */
	sin.sin_addr.s_addr = in_netof(sin.sin_addr);

	sin.sin_port = htons(sin.sin_port);
	strncpy(mywd.wd_hostname, myname, sizeof(myname)-1);

    /* get current utmp info */
	if ((utmpf = open("/etc/utmp", 0)) < 0) {
		(void) close(creat("/etc/utmp", 0644));
		utmpf = open("/etc/utmp", 0);
	}
	if (utmpf < 0) {
		experror("rwhod: /etc/utmp");
		exit(1);
	}

	errno = 0;
	if ((s = socket(SOCK_DGRAM, (struct sockproto *)0, &sin, 0)) < 0) {
		experror("rwhod: socket");
		fprintf(stderr, "errno=%d\n", errno);
		exit(1);
	}
	getkmem();
	if ( (pid = fork()) < 0 )
		{
		experror( "fork" );
		exit(1);
		}
	else if ( pid )
		{
		for (;;)
			{
			onalrm();
			sleep( 60 );
			}
		}

    /* go... */
	for (;;) {
		struct whod wd;
		register int cc, whodf;
		char path[64];
		int i, n;
		struct whoent *we;
#if SYSTEM3 || SYSTEM5
#else
		/*
		 * the select stuff seems not too work on
		 * the unisoft SYSTEM3 and SYSTEM5 ports.
		 */
		long ibits = (1<<s);

		cc = select(32, &ibits, 0, INFINITY);
#ifdef	DEBUG
fprintf(stderr, "ibits = %d\n", ibits);
#endif
		if( cc <= 0 )
			continue;
		if (ibits == 0)
			continue;
#endif
		cc = receive(s, &from, (char *)&wd, sizeof(struct whod));
#ifdef	DEBUG
fprintf(stderr, "cc = %d\n", cc);
#endif
		if (cc <= 0) {
			if (cc < 0 && errno == EINTR)
				{
				continue;
				}
			else
				{
				experror("rwhod: recv" );
				exit( 1 );
				}
			continue;
		}

	    /* validity checks on data received */
		if (ntohs(from.sin_port) != IPPORT_WHOSERVER) {
			fprintf(stderr, "rwhod: bad from port %d\n",
					ntohs(from.sin_port));
			continue;
		}
		if (wd.wd_vers != WHODVERSION) {
			fprintf(stderr, "rwhod: bad version: port %d\n",
					ntohs(from.sin_port));
			continue;
		}
		if (wd.wd_type != WHODTYPE_STATUS) {
			fprintf(stderr, "rwhod: bad type: port %d\n",
					ntohs(from.sin_port));
			continue;
		}
		if (!verify(wd.wd_hostname)) {
			fprintf(stderr, "rwhod: malformed host name from %x\n",
					from.sin_addr);
			continue;
		}

	    /* create daemon file */
		(void) sprintf(path, "%s/whod.%s", RWHODIR, wd.wd_hostname);
		whodf = creat(path, 0666);
		if (whodf < 0) {
			fprintf(stderr, "rwhod: ");
			experror(path);
			continue;
		}

	    /* undo header byte swapping before writing to file */
		n = (cc - WHDRSIZE)/sizeof(struct whoent);
		wd.wd_sendtime = ntohl(wd.wd_sendtime);
		for (i = 0; i < 3; i++)
			wd.wd_loadav[i] = ntohl(wd.wd_loadav[i]);
		wd.wd_boottime = ntohl(wd.wd_boottime);
		we = wd.wd_we;
		for (i = 0; i < n; i++) {
			we->we_idle = ntohl(we->we_idle);
			we->we_utmp.out_time =
			    ntohl(we->we_utmp.out_time);
			we++;
		}
		(void) time(&wd.wd_recvtime);
		(void) write(whodf, (char *)&wd, cc);
		(void) close(whodf);
	}
}

/*
 * getkmem
 *	This code works but has a flaw.
 *	We measure the time the demon has been up and not
 *	the time the system has been up.
 *	But, I couldn't get the other thing to work.
 */
getkmem()
{
	time_t systime;
	static time_t syslbolt = 0;

	if( !syslbolt )
		(void)time(&syslbolt);
	(void) time(&systime);
	mywd.wd_boottime = syslbolt ;
	mywd.wd_boottime = htonl(mywd.wd_boottime);
}

int	utmptime;
int	utmpent;
struct	utmp utmp[100];
int	alarmcount;

/*
 * onalrm -
 *	- check if utmp modified; if so update utmp vars
 *	- update load average vectors -- system dependent
 */
onalrm()
{
	register i, cc;
	register struct whoent *we = mywd.wd_we, *wlast;
	struct stat stb;
	time_t now = time(0);
#if UNISOFT
	long avenrun[3];
#endif

	if (alarmcount++ % 10 == 0)
		getkmem();
	(void) fstat(utmpf, &stb);
	if (stb.st_mtime != uptime) {
		uptime = stb.st_mtime;
		(void) lseek(utmpf, (long)0, 0);
		cc = read(utmpf, (char *)utmp, sizeof(utmp));
		if (cc < 0) {
			experror("/etc/utmp");
			goto done;
		}
		wlast = &mywd.wd_we[1024 / sizeof (struct whoent) - 1];
		utmpent = cc / sizeof (struct utmp);
		for (i = 0; i < utmpent; i++)
#ifdef SYSTEM5
			if (utmp[i].ut_name[0] &&
				utmp[i].ut_type == USER_PROCESS ) {
#else
			if (utmp[i].ut_name[0]) {
#endif	/* SYSTEM5 */
				xbcopy(utmp[i].ut_line, we->we_utmp.out_line,
				   sizeof (utmp[i].ut_line));
				xbcopy(utmp[i].ut_name, we->we_utmp.out_name,
				   sizeof (utmp[i].ut_name));
				we->we_utmp.out_time = htonl(utmp[i].ut_time);
				if (we >= wlast)
					break;
				we++;
			}
		utmpent = we - mywd.wd_we;
	}
	we = mywd.wd_we;
	for (i = 0; i < utmpent; i++) {
		if (stat(we->we_utmp.out_line, &stb) >= 0)
			we->we_idle = htonl(now - stb.st_atime);
		we++;
	}

	/* 
	 *  here is the system load average stuff
	 */
#if UNISOFT
	(void) lseek(kmemf, (long)nl[NL_AVENRUN].n_value, 0);
	(void) read(kmemf, (char *)avenrun, sizeof(avenrun));
#endif
	for (i = 0; i < 3; i++)
#if UNISOFT
		mywd.wd_loadav[i] = htonl((u_long)(fxtod(avenrun[i])*100));
#else
		mywd.wd_loadav[i] = 0;
#endif

	cc = (char *)we - (char *)&mywd;
	mywd.wd_sendtime = htonl(now);
	mywd.wd_type = WHODTYPE_STATUS;
	mywd.wd_vers = WHODVERSION;
	if( -1 == send(s, &sin, (char *)&mywd, cc) ) {
		experror( "rwhod: send" );
		exit(1);
	}
done:
	;
}

/*
 * Check out host name for unprintables
 * and other funnies before allowing a file
 * to be created.  Sorry, but blanks aren't allowed.
 */
verify(name)
	register char *name;
{
	register int size = 0;

	while (*name) {
		if (!isascii(*name) && !isalnum(*name))
			return (0);
		name++, size++;
	}
	return (size > 0);
}

long
in_netof(a)
	struct in_addr a;
{
	return IN_NETOF(a);
}
