/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: ts.c,v 1.2 87/04/24 15:12:23 davidb Exp $ */
char	tsvers[] = " %W% %G% ";

#define TELOPTS
#include "netstat.h"

#define	TSNSOCK		(TSNCON+2)	/* 2 extra for refusals */
#define	TSMAXCON	32
#define	TSMAXSOCK	(TSMAXCON+2)
#define	TSBUFSIZ 32

struct tsdata {
	char	td_frhost	[TSBUFSIZ],
		td_tohost	[TSBUFSIZ],
		td_frnet	[TSBUFSIZ],
		td_tonet	[TSBUFSIZ];
};

char idmap[TSMAXCON];

struct tsstat {
	char	ts_hostid;	/* host connection id, index to idmap[] */
	char	ts_cstate;
#define			DORMANT		0
#define			DOSOCKET	1
#define			DOACCEPT	3
#define			DIDACCEPT	4
#define			DOCARON		5
#define			DOOPTIONS	6
#define			DIDOPTIONS	7
#define			ESTABLISHED	8
#define			DOREFUSE	9
#define			DOCLOSE		10
#define			DOCAROFF	11
#define			DOMALLOC	12
#define			SOCKWAIT	13
#define			MALLOCWAIT	16
	u_short	ts_flags;
#define			ALLOCATED	(1<<0)
#define			RLOGIN		(1<<1)	/* else telnet */
#define			CONNECTED	(1<<2)
#define			CARRIER		(1<<3)	/* sent TSCARON to host */
#define			REFUSED		(1<<4)
#define			NSPENDING	(1<<5)
#define			H2XPENDING	(1<<6)
#define			RLSYNC		(1<<7)	/* rlogin sync-up pending */
#define			DOREAD		(1<<8)
#define			DOWRITE		(1<<9)
#define			DOTOHOST	(1<<10)
#define			HAVCWORK	(1<<11)

#define	DOANYIO	(DOREAD|DOWRITE|DOTOHOST)

	char	ts_rstate;	/* state of telnet read (net-to-host) side */
#define			TS_DATA		0	/* telnet base state */
#define			TS_RLDATA	1	/* rlogin base state */
#define			TS_IAC		2	/* look for double IAC's */
#define			TS_CR		3	/* CR-LF ->'s CR */
#define			TS_BEGINNEG	4	/* throw away begin's... */
#define			TS_ENDNEG	5	/* ...end's (subopt negottn) */
#define			TS_WILL		6	/* will option negotiation */
#define			TS_WONT		7	/* wont " */
#define			TS_DO		8	/* do " */
#define			TS_DONT		9	/* dont " */
#define			TS_READ0	10	/* rlogin sync-up */
#define			TS_RLS1		11	/* rlogin -r strings */
#define			TS_RLS2		12
#define			TS_RLS3		13

	char	ts_wstate;	/* state of telnet write (host-to-net) side */
#define			TSW_DATA	0	/* base state */
#define			TSW_IAC		1	/* send double IAC's */

	u_short	ts_soid;		/* not the same as tsi */
	u_short ts_tdptr;		/* points to a tsdata structure */
	u_short	ts_pfrhost;		/* pointers to 1st byte in buffer */
	u_short	ts_ptohost;
	u_short	ts_pfrnet;
	u_short	ts_ptonet;
	u_short	ts_nfrhost;		/* # bytes in buffer */
	u_short	ts_ntohost;
	u_short	ts_nfrnet;
	u_short	ts_ntonet;
	char	ts_myopts;		/* my effective telnet options */
	char	ts_hisopts;		/* my idea of his telnet options */
	u_long	ts_userid;		/* for host request messages */
	u_short	ts_timout;		/* for connection mgmt */
	char	ts_tsrqst;		/* stash for next request to host */
	char	ts_filler;		/* required as some systems do not 
					   automatically aligned to next word
					   boundary */
};

struct lkuptab {
	int	lu_val;
	char	*lu_name;
};

struct lkuptab tsstates[] = {
	{DORMANT,	"DORMANT"},
	{DOSOCKET,	"DOSOCKET"},
	{DOACCEPT,	"DOACCEPT"},
	{DIDACCEPT,	"DIDACCEPT"},
	{DOCARON,	"DOCARON"},
	{DOOPTIONS,	"DOOPTIONS"},
	{DIDOPTIONS,	"DIDOPTIONS"},
	{ESTABLISHED,	"ESTABLISHED"},
	{DOREFUSE,	"DOREFUSE"},
	{DOCLOSE,	"DOCLOSE"},
	{DOCAROFF,	"DOCAROFF"},
	{DOMALLOC,	"DOMALLOC"},
	{SOCKWAIT,	"SOCKWAIT"},
	{MALLOCWAIT,	"MALLOCWAIT"},
	{-1,		""}
};

struct lkuptab tsflags[] = {
	{ALLOCATED,	"ALLOCATED"},
	{RLOGIN,	"RLOGIN"},
	{CONNECTED,	"CONNECTED"},
	{CARRIER,	"CARRIER"},
	{REFUSED,	"REFUSED"},
	{NSPENDING,	"NSPENDING"},
	{H2XPENDING,	"H2XPENDING"},
	{RLSYNC,	"RLSYNC"},
	{DOREAD,	"DOREAD"},
	{DOWRITE,	"DOWRITE"},
	{DOTOHOST,	"DOTOHOST"},
	{HAVCWORK,	"HAVCWORK"},
	{-1,		""}
};

extern	int exos;
extern	int dflag;

char	*lookup();
u_short	xtohs();

struct tsstat tsstat;

/*
 * Print telnet server information.
 */
tspr(tsaddr0, idaddr)
	u_short tsaddr0;
	u_short idaddr;
{
	int i;
	u_short tsaddr;

	if (tsaddr0 == 0) {
		xprintf("tsstat: symbol not in namelist\n");
		return;
	}
	if (idaddr == 0) {
		xprintf("idmap: symbol not in namelist\n");
		return;
	}
	klseek(exos, tsaddr0, 0);
	klread(exos, &tsaddr, sizeof(tsaddr));
	tsaddr = xtohs(tsaddr);
	for (i = 0; i < TSMAXSOCK; i++) {
		klseek(exos, idaddr, 0);
		klread(exos, idmap, sizeof(idmap));
		klseek(exos, tsaddr, 0);
		klread(exos, &tsstat, sizeof(struct tsstat));
		fixtsstat(&tsstat);
		if (tsstat.ts_cstate != DORMANT) {
			xprintf("TS connection #%d (at 0x%x):\n", i, tsaddr);
			if ( (idmap[tsstat.ts_hostid] != i)
			  && (tsstat.ts_flags & CARRIER) )
				xprintf("BAD ID MAP: tsi=%d, idmap[%d]=%d\n", i,
				  tsstat.ts_hostid, idmap[tsstat.ts_hostid]);
			showtsstat(&tsstat);
		}
		tsaddr += sizeof(struct tsstat);
	}
}

char *
lookup(tp, value)
	struct lkuptab *tp;
{
	while (tp->lu_val != -1) {
		if (dflag)
			xprintf("tp=%lx, val=%d, name=%s\n",
			  tp, tp->lu_val, tp->lu_name);
		if (tp->lu_val == value)
			return tp->lu_name;
		tp += 1;
	}
	return "";
}

#define	SFIX(x) tsp->x = xtohs(tsp->x)
fixtsstat(tsp)
	struct tsstat *tsp;
{
	SFIX(ts_flags);
	SFIX(ts_soid);
	SFIX(ts_tdptr);
	SFIX(ts_pfrhost);
	SFIX(ts_ptohost);
	SFIX(ts_pfrnet);
	SFIX(ts_ptonet);
	SFIX(ts_nfrhost);
	SFIX(ts_ntohost);
	SFIX(ts_nfrnet);
	SFIX(ts_ntonet);
	SFIX(ts_timout);
}

showtsstat(tsp)
	struct tsstat *tsp;
{
	register int i;
	char *np;

	xprintf("\tts_hostid = %x\n", tsp->ts_hostid);
	xprintf("\tts_cstate = %x (%s) \n", tsp->ts_cstate,
	  lookup(tsstates, tsp->ts_cstate));
	xprintf("\tts_flags = %x (", tsp->ts_flags);
	for (i = 0; i < 16; i++) {
		np = lookup(tsflags, tsp->ts_flags & 1<<i);
		xprintf("%s%s", np, *np ? " " : "");
	}
	xprintf(")\n");
	xprintf("\tts_rstate = %x\n", tsp->ts_rstate);
	xprintf("\tts_wstate = %x\n", tsp->ts_wstate);
	xprintf("\tts_soid = %x\n", tsp->ts_soid);
	xprintf("\tts_tdptr = %x\n", tsp->ts_tdptr);
	xprintf("\tts_pfrhost = %x\n", tsp->ts_pfrhost);
	xprintf("\tts_ptohost = %x\n", tsp->ts_ptohost);
	xprintf("\tts_pfrnet = %x\n", tsp->ts_pfrnet);
	xprintf("\tts_ptonet = %x\n", tsp->ts_ptonet);
	xprintf("\tts_nfrhost = %x\n", tsp->ts_nfrhost);
	xprintf("\tts_ntohost = %x\n", tsp->ts_ntohost);
	xprintf("\tts_nfrnet = %x\n", tsp->ts_nfrnet);
	xprintf("\tts_ntonet = %x\n", tsp->ts_ntonet);
	xprintf("\tts_myopts = %x\n", tsp->ts_myopts);
	xprintf("\tts_hisopts = %x\n", tsp->ts_hisopts);
	xprintf("\tts_userid = %lx\n", tsp->ts_userid);
	xprintf("\tts_timout = %x\n", tsp->ts_timout);
	xprintf("\tts_tsrqst = %x\n", tsp->ts_tsrqst);
	xprintf("\n");
}
