/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: ftpcmd.y,v 1.2 87/04/24 14:57:30 davidb Exp $ */
/*
 * Grammar for FTP commands.
 * See RFC 765.
 */

%{

#ifndef lint
static char sccsid[] = "@(#)ftpcmd.y	1.16 8/15/85";
#endif

#define PARSER
#include "ftpd.h"

#ifdef	vms
#define	PARENT_DIRECTORY	"[-]"
#else
#define	PARENT_DIRECTORY	".."
#endif

/*
* MWP: 03/06/85
*  Make machines which have different sized ints and pointers happy.
*  (at least as far as the parser stack is concerned).
********************************************************************
*/
typedef char * YYSTDEF;
#define YYSTYPE YYSTDEF
YYSTYPE copy();
/*
********************************************************************
*/

extern	struct sockaddr_in data_dest;
extern	int logged_in;
extern	int guest;
extern	int logging;
extern	int type;
extern	int form;
extern	int stru;
extern	int mode;
extern	int bytesize;
extern	int debug;
extern	int timeout;
extern	int data;
extern	int abortxfer;
extern	char hostname[];
extern	char *globerr;
extern	char *xghome;
extern	int usedefault;
extern	char	**xglob();
extern	char	**nglob();
extern char **xmkarglist();
extern	char	*xrerror();
extern	int	poption();
extern	int	pescape();
static char	**globargs = 0;
static char	**rnf_glob = 0;
static char	*username = 0;
static char	*userpass = 0;
#ifdef	vms
static char	*userpass2 = (char *) 0;
#endif

static	int cmd_type = 0;
static	int cmd_form = 0;
static	int cmd_bytesz = 0;

char	*xstrchr();
extern XFILE *dataconn();
%}

%token
	A	B	C	E	F	I
	L	N	P	R	S	T

	SP	CRLF	COMMA	STRING	NUMBER

	USER	PASS	ACCT	REIN	QUIT	PORT
	PASV	TYPE	STRU	MODE	RETR	STOR
	APPE	MLFL	MAIL	MSND	MSOM	MSAM
	MRSQ	MRCP	ALLO	REST	RNFR	RNTO
	ABOR	DELE	CWD	LIST	NLST	SITE
	STAT	HELP	NOOP	XMKD	XRMD	XPWD
	XCUP	XEXC

	LEXERR

%start	cmd_list

%%

cmd_list:	/* empty */
	|	cmd_list cmd
		{
		if( globargs )
			xdealglob( globargs );
		globargs = (char **)0;
		}
	;

cmd:		USER SP username CRLF
		= {
			int success;

			if( logged_in )
				{
				reply(531, "Already logged in.");
				xfree( $3 );
				}
			else if ((success =
				xinit_env($3, (char *)0, (char *)0, 1))
				<= 0 
			) 
				{
				guest = 0;
				reply(331, "Password required for %s.", $3);
				if( username )
					xfree( username );
				username = $3;
				}
			else if ( success < 0 )
				{
				/*
				Do we want to give out this informantion?
				*/
				reply(530, "User %s unknown.", $3);
				xfree($3);
				if( username )
					xfree( username );
				username = (char *)0;
				}
			else
				{
				username = $3;
				reply(230, "User %s logged in.", $3);
				logged_in = 1;
				guest = restricted( username );
				}
		}
	|	PASS SP password CRLF
		= {
			int success;

			if( !username )
				{
				reply(530, "Log in with user first.");
				xfree( $3 );
				}
			else if( logged_in )
				{
				reply(531, "Already logged in.");
				xfree( $3 );
				}
			else if ((success =
				xinit_env(username, $3, (char *)0, 1))
				== 0 
			) 
				{
				guest = 0;
#ifdef	vms
				reply(331,"Secondary password required for %s.", username);
#else
				reply(331,"Account required for %s.", username);
#endif
				if( userpass )
					xfree( userpass );
				userpass = $3;
				}
			else if ( success > 0 )
				{
				userpass = $3;
				reply(230, "User %s logged in.", username);
				logged_in = 1;
				guest = restricted( username );
				}
			else		/* sucess < 0 (tricotomy) */
				{
				reply( 530, "Login failed." );
				xfree( $3 );
				}
		}
	|	ACCT SP account CRLF
		= {
			int success;

			if( !username )
				{
				reply(530, "Log in with user first.");
				xfree( $3 );
				}
			else if( logged_in )
				{
				reply(531, "Already logged in.");
				xfree( $3 );
				}
			else if ((success =
				xinit_env(username, userpass, $3, 1))
				<= 0 
			) 
				{
				guest = 0;
				reply( 530, "Login incorrect." );
				xfree( $3 );
				}
			else if ( success > 0 )
				{
				reply(230, "User %s logged in.", username);
				logged_in = 1;
#ifdef	vms
				if (userpass2)
					xfree(userpass2);
				userpass2 = $3;
#endif
				guest = restricted( username );
				xfree( $3 );
				}
		}
	|	PORT check_login SP host_port CRLF
		= {
			usedefault = 0;
			ack($1);
		}
	|	STAT CRLF
		= {
			char cur[5];	/* current transfer parameter */

			cur[4] = '\0';
			switch (type) {
				case TYPE_A:	cur[0] = 'A';
						break;
				case TYPE_E:	cur[0] = 'E';
						break;
				case TYPE_I:	cur[0] = 'I';
						break;
				case TYPE_L:	cur[0] = 'L';
						break;
				default:	cur[0] = ' ';
						break;
			};
			switch (form) {
				case FORM_N:	cur[1] = 'N';
						break;
				case FORM_T:	cur[1] = 'T';
						break;
				case FORM_C:	cur[1] = 'C';
						break;
				default:	cur[1] = ' ';
						break;
			};
			switch (stru) {
				case STRU_F:	cur[2] = 'F';
						break;
				case STRU_R:	cur[2] = 'R';
						break;
				case STRU_P:	cur[2] = 'P';
						break;
				default:	cur[2] = ' ';
						break;
			};
			switch (mode) {
				case MODE_S:	cur[3] = 'S';
						break;
				case MODE_B:	cur[3] = 'B';
						break;
				case MODE_C:	cur[3] = 'C';
						break;
				default:	cur[3] = ' ';
						break;
			};

			if (type == TYPE_L) {
				reply(211, "%s%d. %s FTP server is alive.",
					cur, bytesize, hostname);
			} else {
				reply(211, "%s. %s FTP server is alive.",
					cur, hostname);
			};

		}
	|	STAT check_login SP pathname CRLF
		= {
			struct xstatbuf info;
			char type[6];
			int rval;

			if ($2 && $4) {
				rval = xstat( $4, FILE_NAME, &info );
				if( rval < 0 ) {
					reply( 550, "%s:%s", $4, 
						xrerror( rval ) );
				} else {
					if( info.x_mode & X_IFDIR ) {
						xstrcpy( type, "D" );
					} else {
						if ( info.x_mode & X_IFTEXT ) {
							xstrcpy( type, "ANFS" );
						} else {
							xstrcpy( type, "INFS" );
						};
						if ( info.x_mode & X_IFRECORD) 
							*(type + 2) = 'R';
					}
					reply(213, "%s %s",
						type, info.x_ncompo );
				}
			}
		}
	|	XEXC check_mlogin SP pathname CRLF
		= {
			char **eargv;
			int madeargs = 0;
			int eargc;
			int rval;
			XFILE *fod;
			int od;
			int telod = -1;
			int i;

			if( !$2 || !$4 ) {
				/* reply( 500, "Sorry, you're not trusted." );
					(reply sent by check_login) */
				goto endxexc;
			}
			eargv = xmkarglist( $4, &eargc );
			if( eargv == XNULL ) {
				reply( 500, "No memory in server." );
				goto endxexc;
			}
			madeargs = 1;
			fod = dataconn( "XEXC", (off_t)-1, "r" );
			if (fod == XNULL)
				goto endxexc;
			od = xfileno( fod );
			if( type == TYPE_A ) {
				telod = xtelopen( od, poption, pescape );
				if( telod < 0 ) {
					reply( 550, "%s:%s", $3, xrerror(rval));
					xclose( od ), data = -1;
					goto endxexc;
				}
			} else {
				telod = od;
			}
			rval = xexec( eargc, eargv, telod, telod, telod );
			xclose( telod ), data = -1;
			if( rval < 0 ) {
				reply( 550, "%s:%s", $3, xrerror( rval ) );
			} else {
				reply( 226, "Transfer Complete." );
			}
		endxexc:
			if( madeargs )
				xdealglob( eargv );
			;
		}
	|	ABOR CRLF
		= {
			if( data != -1 ) {
				xclose( data ), data = -1;
				reply( 226, "Transfer aborted." );
			} else {
				reply( 225, "No Transfer in progress." );
			}
		}
	|	TYPE SP type_code CRLF
		= {
			switch (cmd_type) {

			case TYPE_A:
				if (cmd_form == FORM_N) {
					reply(200, "Type set to A.");
					type = cmd_type;
					form = cmd_form;
				} else
					reply(504, "Form must be N.");
				break;

			case TYPE_E:
				reply(504, "Type E not implemented.");
				break;

			case TYPE_I:
				reply(200, "Type set to I.");
				type = cmd_type;
				break;

			case TYPE_L:
				if (cmd_bytesz == 8) {
					reply(200,
					    "Type set to L (byte size 8).");
					type = cmd_type;
					bytesize = cmd_bytesz;
				} else
					reply(504, "Byte size must be 8.");
			}
		}
	|	STRU SP struct_code CRLF
		= {
			switch ((int)$3) {

			case STRU_F:
				reply(200, "STRU F ok.");
				stru = STRU_F;
				break;

			case STRU_R:
				reply(200, "STRU R ok.");
				stru = STRU_R;
				break;

			default:
				reply(502, "Unimplemented STRU type.");
			}
		}
	|	MODE SP mode_code CRLF
		= {
			switch ((int)$3) {

			case MODE_S:
				mode = MODE_S;
				reply(200, "MODE S ok.");
				break;

			default:
				reply(502, "Unimplemented MODE type.");
			}
		}
	|	ALLO SP NUMBER CRLF
		= {
			ack($1);
		}
	|	RETR check_login SP pathname CRLF
		= {
			if ($2 && $4 != XNULL)
				retrieve(0, $4);
		}
	|	STOR check_mlogin SP pathname CRLF
		= {
			if ($2 && $4 != XNULL)
				store($4, "w");
		}
	|	APPE check_mlogin SP pathname CRLF
		= {
			if ($2 && $4 != XNULL)
				store($4, "a");
		}
	|	NLST check_login CRLF
		= {
			if ($2)
				retrieve( LS, "");
		}
	|	NLST check_login SP pathcheck CRLF
		= {
			if ($2 && $4 != XNULL)
				retrieve( LS_ARG, $4);
			if ($4 != XNULL)
				xfree($4);
		}
	|	LIST check_login CRLF
		= {
			if ($2)
				retrieve( LSLONG, "");
		}
	|	LIST check_login SP pathcheck CRLF
		= {
			if ($2 && $4 != XNULL)
				retrieve( LSLONG_ARG, $4);
			if ($4 != XNULL)
				xfree($4);
		}
	|	DELE check_mlogin SP pathname CRLF
		= {
			if ($2 && $4 != XNULL)
				delete($4);
		}
	|	CWD check_mlogin CRLF
		= {
			if ($2)
				xchdir( (char *)0, HOME_DIR);
		}
	|	CWD check_mlogin SP pathname CRLF
		= {
			if ($2 && $4 != XNULL)
				cwd($4, FILE_NAME );
		}
	|	rename_cmd
	|	HELP CRLF
		= {
			help(0);
		}
	|	HELP SP STRING CRLF
		= {
			help($3);
		}
	|	NOOP CRLF
		= {
			ack($1);
		}
	|	XMKD check_mlogin SP pathname CRLF
		= {
			if ($2 && $4 != XNULL)
				makedir($4);
		}
	|	XRMD check_mlogin SP pathname CRLF
		= {
			if ($2 && $4 != XNULL)
				removedir($4);
		}
	|	XPWD check_login CRLF
		= {
			if ($2)
				pwd();
		}
	|	XCUP check_mlogin CRLF
		= {
			if ($2 && !inappropriate_request(PARENT_DIRECTORY))
				cwd(PARENT_DIRECTORY, FILE_NAME );
		}
	|	QUIT CRLF
		= {
			reply(221, "Goodbye.");
			xexit(0);
		}
	|	error CRLF
		= {
			yyerrok;
		}
	;

username:	STRING
	;

password:	STRING
	;

account:	STRING
	;

byte_size:	NUMBER
	;

host_port:	NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA 
		NUMBER COMMA NUMBER
		= {
			register char *a, *p;

			a = (char *)&data_dest.sin_addr;
			a[0] = (int)$1; a[1] = (int)$3;
			a[2] = (int)$5; a[3] = (int)$7;
			p = (char *)&data_dest.sin_port;
			p[0] = (int)$9; p[1] = (int)$11;
			data_dest.sin_family = AF_INET;
		}
	;

form_code:	N
	= {
		$$ = (YYSTYPE)FORM_N;
	}
	|	T
	= {
		$$ = (YYSTYPE)FORM_T;
	}
	|	C
	= {
		$$ = (YYSTYPE)FORM_C;
	}
	;

type_code:	A
	= {
		cmd_type = TYPE_A;
		cmd_form = FORM_N;
	}
	|	A SP form_code
	= {
		cmd_type = TYPE_A;
		cmd_form = (int)$3;
	}
	|	E
	= {
		cmd_type = TYPE_E;
		cmd_form = FORM_N;
	}
	|	E SP form_code
	= {
		cmd_type = TYPE_E;
		cmd_form = (int)$3;
	}
	|	I
	= {
		cmd_type = TYPE_I;
	}
	|	L
	= {
		cmd_type = TYPE_L;
		cmd_bytesz = 8;
	}
	|	L SP byte_size
	= {
		cmd_type = TYPE_L;
		cmd_bytesz = (int)$3;
	}
	/* this is for a bug in the BBN ftp */
	|	L byte_size
	= {
		cmd_type = TYPE_L;
		cmd_bytesz = (int)$2;
	}
	;

struct_code:	F
	= {
		$$ = (YYSTYPE)STRU_F;
	}
	|	R
	= {
		$$ = (YYSTYPE)STRU_R;
	}
	|	P
	= {
		$$ = (YYSTYPE)STRU_P;
	}
	;

mode_code:	S
	= {
		$$ = (YYSTYPE)MODE_S;
	}
	|	B
	= {
		$$ = (YYSTYPE)MODE_B;
	}
	|	C
	= {
		$$ = (YYSTYPE)MODE_C;
	}
	;

pathname:	pathcheck
	= {
		char *argv[2];

		argv[0] = (char *)$1;
		argv[1] = (char *)0;
		globargs = nglob(argv, 1);
		if (globerr != XNULL) {
			reply(550, globerr);
			$$ = (YYSTYPE)XNULL;
		} else if( globargs == XNULL || *globargs == XNULL ) {
			reply(550, "No file name matches.");
			$$ = (YYSTYPE)XNULL;
		} else {
			$$ = (YYSTYPE)*globargs;
		}
		if (inappropriate_request($$))
			$$ = (YYSTYPE)XNULL;
		xfree($1);
	}
	;

pathcheck:	pathstring
	= {
		if ($1 && inappropriate_request($1)) {
			$$ = (YYSTYPE)XNULL;
			xfree($1);
		} else
			$$ = $1;
	}
	;

pathstring:	STRING
	;

rename_cmd:	rename_from rename_to
	= {
		if ($1 && $2)
			renamecmd($1, $2);
		else if ( !$1 && $2 )
			reply(503, "Bad sequence of commands.");
		/*
		  Otherwise ...
		  (Presumably, one of the previous reductions has already
		  sent the bad news. )
		*/
		/*
		 * Since two path names are involved, we should delalocate
		 * space for the first one, as globargs contains the result
		 * of the second globbing, and will be dealocated when
		 * the reduction to cmd takes place.
		 */
		if (rnf_glob)
			xdealglob(rnf_glob);
	}
	;

rename_from:	RNFR check_mlogin SP pathname CRLF
	= {
		char *from = 0, *renamefrom();

		if ($2 && $4)
			from = renamefrom($4);
		rnf_glob = globargs;
		$$ = (YYSTYPE)from;
	}
	;

rename_to:	RNTO SP pathname CRLF
	= {
		$$ = $3;
	}
	;

check_login:	/* empty */
	= {
		if (logged_in)
			$$ = (YYSTYPE)1;
		else {
			reply(530, "Please login with USER and PASS.");
			$$ = (YYSTYPE)0;
		}
	}
	;

check_mlogin:	/* empty: check that user is allowed to modify filesystem */
	= {
		if (logged_in) {
			if( guest ) {
				reply(550, "Action not permitted guest users.");
				$$ = (YYSTYPE)0;
			} else {
				$$ = (YYSTYPE)1;
			}
		} else {
			reply(530, "Please login with USER and PASS.");
			$$ = (YYSTYPE)0;
		}
	}
	;

%%

#ifdef zilog
extern ret_buf errcatch;
#else
extern jmp_buf errcatch;
#endif

#define	CMD	0	/* beginning of command */
#define	ARGS	1	/* expect miscellaneous arguments */
#define	STR1	2	/* expect SP followed by STRING */
#define	STR2	3	/* expect STRING */
#define	OSTR	4	/* optional STRING */

struct tab {
	char	*name;
	short	token;
	short	state;
	short	implemented;	/* 1 if command is implemented */
	char	*help;
};

struct tab cmdtab[] = {		/* In order defined in RFC 765 */
	{ "USER", USER, STR1, 1,	"<sp> username" },
	{ "PASS", PASS, STR1, 1,	"<sp> password" },
#ifdef	vms
	{ "ACCT", ACCT, STR1, 1,	"(specify account)" },
#else
	{ "ACCT", ACCT, STR1, 0,	"(specify account)" },
#endif
	{ "REIN", REIN, ARGS, 0,	"(reinitialize server state)" },
	{ "QUIT", QUIT, ARGS, 1,	"(terminate service)" },
	{ "PORT", PORT, ARGS, 1,	"<sp> b0, b1, b2, b3, b4" },
	{ "PASV", PASV, ARGS, 0,	"(set server in passive mode)" },
	{ "TYPE", TYPE, ARGS, 1,	"<sp> [ A | E | I | L ]" },
	{ "STRU", STRU, ARGS, 1,	"(specify file structure)" },
	{ "MODE", MODE, ARGS, 1,	"(specify transfer mode)" },
	{ "RETR", RETR, STR1, 1,	"<sp> file-name" },
	{ "STOR", STOR, STR1, 1,	"<sp> file-name" },
	{ "APPE", APPE, STR1, 1,	"<sp> file-name" },
	{ "MLFL", MLFL, OSTR, 0,	"(mail file)" },
	{ "MAIL", MAIL, OSTR, 0,	"(mail to user)" },
	{ "MSND", MSND, OSTR, 0,	"(mail send to terminal)" },
	{ "MSOM", MSOM, OSTR, 0,	"(mail send to terminal or mailbox)" },
	{ "MSAM", MSAM, OSTR, 0,	"(mail send to terminal and mailbox)" },
	{ "MRSQ", MRSQ, OSTR, 0,	"(mail recipient scheme question)" },
	{ "MRCP", MRCP, STR1, 0,	"(mail recipient)" },
	{ "ALLO", ALLO, ARGS, 1,	"allocate storage (vacuously)" },
	{ "REST", REST, STR1, 0,	"(restart command)" },
	{ "RNFR", RNFR, STR1, 1,	"<sp> file-name" },
	{ "RNTO", RNTO, STR1, 1,	"<sp> file-name" },
	{ "ABOR", ABOR, ARGS, 2,	"(abort operation)" },
	{ "DELE", DELE, STR1, 1,	"<sp> file-name" },
	{ "CWD",  CWD,  OSTR, 1,	"[ <sp> directory-name]" },
	{ "CDUP", XCUP, ARGS, 1,	"(change to parent directory)" },
	{ "XCWD", CWD,	OSTR, 1,	"[ <sp> directory-name ]" },
	{ "LIST", LIST, OSTR, 1,	"[ <sp> path-name ]" },
	{ "MKD",  XMKD, STR1, 1,	"<sp> path-name" },
	{ "NLST", NLST, OSTR, 1,	"[ <sp> path-name ]" },
	{ "PWD",  XPWD, ARGS, 1,	"(return current directory)" },
	{ "RMD",  XRMD, STR1, 1,	"<sp> path-name" },
	{ "SITE", SITE, STR1, 0,	"(get site parameters)" },
	{ "STAT", STAT, OSTR, 2,	"(get server status)" },
	{ "HELP", HELP, OSTR, 1,	"[ <sp> <string> ]" },
	{ "NOOP", NOOP, ARGS, 1,	"" },
	{ "XMKD", XMKD, STR1, 1,	"<sp> path-name" },
	{ "XRMD", XRMD, STR1, 1,	"<sp> path-name" },
	{ "XPWD", XPWD, ARGS, 1,	"(return current directory)" },
	{ "XCUP", XCUP, ARGS, 1,	"(change to parent directory)" },
#ifdef	vms
	{ "XEXC", XEXC, STR1, 0,	"execute command" },
#else
	{ "XEXC", XEXC, STR1, 1,	"execute command" },
#endif
	{ XNULL,   0,    0,    0,	0 }
};

struct tab *
lookup(cmd)
	char *cmd;
{
	register struct tab *p;

	for (p = cmdtab; p->name != XNULL; p++)
		if (xstrcmp(cmd, p->name) == 0)
			return (p);
	return (0);
}


/*
 * getline - a hacked up version of fgets to ignore TELNET escape codes.
 */
char *
getline(s, n, iop)
	char *s;
	register XFILE *iop;
{
	register c;
	register char *cs;

	cs = s;
	while (--n > 0 && (c = xgetc(iop)) >= 0) {
		while (c == IAC) {
			/* get IAC, it may be IAC IAC which is a legal data
			   byte. OR it may be IAC COMMAND PARAMETER which 
			   we should skip 
			*/
			c = xgetc(iop);	/* skip command */
			if (c == IAC) {
				break; /* data byte */
			} else {
				c = xgetc(iop);	/* skip parameter */
				c = xgetc(iop);	/* get next */
			};
		}
		*cs++ = c;
		if (c=='\n')
			break;
	}
	if (c < 0 && cs == s)
		return (XNULL);
	*cs++ = '\0';
	if (debug) {
		xoprintf(xstderr, "FTPD: command: %s", s);
		if (c != '\n')
			xputc('\n', xstderr);
		xfflush(xstderr);
	}
	return (s);
}

static int
toolong()
{
	long now;
	extern long xtime();

	reply(421,
	  "Timeout (%d seconds): closing control connection.", timeout);
	if (logging) {
		xoprintf(xstderr,
			"FTPD: User %s timed out after %d seconds at %ld",
			(username ? username : "unknown"), timeout,xtime());
		xfflush(xstderr);
	}
	xexit(1);
}

yylex()
{
	/*
	 * Don't use register variables -- Zilog S8000 setret() can't cope.
	 */
	static char cbuf[512];
	static int cpos, state;
	char *cp;
	struct tab *p;
	int n;
	int errcnt = 0;
	char c;

retry:
	for (;;) {
		switch (state) {

		case CMD:
			if( abortxfer )
				clearabort();
			if (getline(cbuf, sizeof(cbuf)-1, xstdin) == XNULL) {
				if( xferror( xstdin ) && (errcnt < 3) ) {
					++errcnt;
					goto retry;
				}
				reply(221, "You could at least say goodbye.");
				xexit(0);
			}
			if (cp = xstrchr(cbuf, '\r')) {
				cp[0] = '\n'; cp[1] = 0;
			}
			if (cp = xstrchr(cbuf, ' '))
				cpos = cp - cbuf;
			else if(cp = xstrchr(cbuf, '\n'))
				cpos = cp - cbuf;
			else
				cpos = 4;
			c = cbuf[cpos];
			cbuf[cpos] = '\0';
			upper(cbuf);
			p = lookup(cbuf);
			cbuf[cpos] = c;
			if (p != 0) {
				if (p->implemented == 0) {
					nack(p->name);
					xlongjmp(errcatch);
					/* NOTREACHED */
				}
				state = p->state;
				yylval = (YYSTYPE) p->name;
				return (p->token);
			}
			break;

		case OSTR:
			if (cbuf[cpos] == '\n') {
				state = CMD;
				return (CRLF);
			}
			/* FALL THRU */

		case STR1:
			if (cbuf[cpos] == ' ') {
				cpos++;
				state = STR2;
				return (SP);
			}
			break;

		case STR2:
			cp = &cbuf[cpos];
			n = xstrlen(cp);
			cpos += n - 1;
			/*
			 * Make sure the string is nonempty and \n terminated.
			 */
			if (n > 1 && cbuf[cpos] == '\n') {
				cbuf[cpos] = '\0';
				yylval = (YYSTYPE)copy(cp);
				cbuf[cpos] = '\n';
				state = ARGS;
				return (STRING);
			}
			break;

		case ARGS:
			if (isdigit(cbuf[cpos])) {
				cp = &cbuf[cpos];
				while (isdigit(cbuf[++cpos]))
					;
				c = cbuf[cpos];
				cbuf[cpos] = '\0';
				yylval = (YYSTYPE)xatoi(cp);
				cbuf[cpos] = c;
				return (NUMBER);
			}
			switch (cbuf[cpos++]) {

			case '\n':
				state = CMD;
				return (CRLF);

			case ' ':
				return (SP);

			case ',':
				return (COMMA);

			case 'A':
			case 'a':
				return (A);

			case 'B':
			case 'b':
				return (B);

			case 'C':
			case 'c':
				return (C);

			case 'E':
			case 'e':
				return (E);

			case 'F':
			case 'f':
				return (F);

			case 'I':
			case 'i':
				return (I);

			case 'L':
			case 'l':
				return (L);

			case 'N':
			case 'n':
				return (N);

			case 'P':
			case 'p':
				return (P);

			case 'R':
			case 'r':
				return (R);

			case 'S':
			case 's':
				return (S);

			case 'T':
			case 't':
				return (T);

			}
			break;

		default:
			fatal("Unknown state in scanner.");
		}
		state = CMD;
		yyerror( "lexical error" );
	}
}

upper(s)
	char *s;
{
	while (*s != '\0') {
		if (islower(*s))
			*s = _toupper(*s);
		s++;
	}
}

YYSTYPE
copy(s)
	char *s;
{
	char *p;
	extern char *xmalloc();

	p = xmalloc(xstrlen(s) + 1);
	if (p == XNULL)
		fatal("Ran out of memory.");
	xstrcpy(p, s);
	return ((YYSTYPE)p);
}

help(s)
	char *s;
{
	register struct tab *c;
	register int width, NCMDS;

	width = 0, NCMDS = 0;
	for (c = cmdtab; c->name != XNULL; c++) {
		int len = xstrlen(c->name);

		if (c->implemented == 0)
			len++;
		if (len > width)
			width = len;
		NCMDS++;
	}
	width = (width + 8) &~ 7;
	if (s == 0) {
		register int i, j, w;
		int columns, lines;

		lreply(214,
	  "The following commands are recognized (* =>'s unimplemented).");
		columns = 76 / width;
		if (columns == 0)
			columns = 1;
		lines = (NCMDS + columns - 1) / columns;
		for (i = 0; i < lines; i++) {
			xoprintf(xstdout,"   ");
			for (j = 0; j < columns; j++) {
				c = cmdtab + j * lines + i;
				xoprintf(xstdout,"%s%c", c->name,
					c->implemented ? ' ' : '*');
				if ((long)(c + lines) >= (long)&cmdtab[NCMDS])
					break;
				w = xstrlen(c->name);
				while (w < width) {
					xputchar(' ');
					w++;
				}
			}
			xoprintf(xstdout,"\r\n");
		}
		xfflush(xstdout);
		reply(214, "Direct comments to ftp-bugs@%s.", hostname);
		return;
	}
	upper(s);
	c = lookup(s);
	if (c == (struct tab *)0) {
		reply(504, "Unknown command %s.", s);
		return;
	}
	if (c->implemented)
		reply(214, "Syntax: %s %s", c->name, c->help);
	else
		reply(214, "%-*s\t%s; unimplemented.", width, c->name, c->help);
}
